/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.history;

import com.tridium.rdb.BRdbmsDiscoverTablesJob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryExport;
import javax.baja.rdb.history.BRdbmsHistoryImport;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BRdbmsHistoryDeviceExt
extends BHistoryDeviceExt {
    public static final Property useLastTimestamp = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property useHistoryConfigTimeZone = BRdbmsHistoryDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action submitRdbTableDiscoveryJob = BRdbmsHistoryDeviceExt.newAction((int)4, null);
    public static final Action updateLastTimestamp = BRdbmsHistoryDeviceExt.newAction((int)132, null);
    public static final Action clearLastTimestamp = BRdbmsHistoryDeviceExt.newAction((int)132, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$history$BRdbmsHistoryDeviceExt == null ? (class$javax$baja$rdb$history$BRdbmsHistoryDeviceExt = BRdbmsHistoryDeviceExt.class$("javax.baja.rdb.history.BRdbmsHistoryDeviceExt")) : class$javax$baja$rdb$history$BRdbmsHistoryDeviceExt));
    private static final Log LOG = Log.getLog((String)"rdb");
    static /* synthetic */ Class class$javax$baja$rdb$history$BRdbmsHistoryDeviceExt;
    static /* synthetic */ Class class$javax$baja$rdb$history$BRdbmsHistoryExport;

    public boolean getUseLastTimestamp() {
        return this.getBoolean(useLastTimestamp);
    }

    public void setUseLastTimestamp(boolean bl) {
        this.setBoolean(useLastTimestamp, bl, null);
    }

    public boolean getUseHistoryConfigTimeZone() {
        return this.getBoolean(useHistoryConfigTimeZone);
    }

    public void setUseHistoryConfigTimeZone(boolean bl) {
        this.setBoolean(useHistoryConfigTimeZone, bl, null);
    }

    public BOrd submitRdbTableDiscoveryJob() {
        return (BOrd)this.invoke(submitRdbTableDiscoveryJob, null, null);
    }

    public void updateLastTimestamp() {
        this.invoke(updateLastTimestamp, null, null);
    }

    public void clearLastTimestamp() {
        this.invoke(clearLastTimestamp, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getImportDescriptorType() {
        return BRdbmsHistoryImport.TYPE;
    }

    public boolean supportsGenericArchiveFolder() {
        return true;
    }

    public BOrd doSubmitRdbTableDiscoveryJob(Context context) {
        if (this.getDevice().isFatalFault() || this.getDevice().isDown() || this.getDevice().isDisabled()) {
            return null;
        }
        return new BRdbmsDiscoverTablesJob(this).submit(context);
    }

    public void doUpdateLastTimestamp() {
        LOG.trace("Beginning timestamp update...");
        long l = System.currentTimeMillis();
        BRdbms bRdbms = (BRdbms)this.getDevice();
        BHistoryDatabase bHistoryDatabase = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
        if (bRdbms.getExportMode().getOrdinal() == 0) {
            throw new BajaRuntimeException("updateLastTimestamp does not work when the export mode is set to BY_HISTORY_ID.");
        }
        Map map = this.makeTimestampMap(bRdbms);
        BRdbmsHistoryExport[] bRdbmsHistoryExportArray = (BRdbmsHistoryExport[])this.getChildren(class$javax$baja$rdb$history$BRdbmsHistoryExport == null ? (class$javax$baja$rdb$history$BRdbmsHistoryExport = BRdbmsHistoryDeviceExt.class$("javax.baja.rdb.history.BRdbmsHistoryExport")) : class$javax$baja$rdb$history$BRdbmsHistoryExport);
        for (int i = 0; i < bRdbmsHistoryExportArray.length; ++i) {
            BHistoryId bHistoryId = bRdbmsHistoryExportArray[i].getHistoryId();
            BAbsTime bAbsTime = (BAbsTime)map.get(bHistoryId.toString());
            bRdbmsHistoryExportArray[i].setLastTimestamp(bAbsTime == null ? BAbsTime.NULL : bAbsTime);
        }
        long l2 = System.currentTimeMillis() - l;
        LOG.trace("Updated " + bRdbmsHistoryExportArray.length + " timestamps (" + l2 + "ms)");
    }

    private Map makeTimestampMap(BRdbms bRdbms) {
        try {
            HashMap<String, BAbsTime> hashMap = new HashMap<String, BAbsTime>();
            Connection connection = bRdbms.getConnection(bRdbms.getUserName(), bRdbms.getPassword());
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT DISTINCT TABLE_NAME FROM HISTORY_TYPE_MAP");
            while (resultSet.next()) {
                ResultSet resultSet2 = connection.createStatement().executeQuery("SELECT MAX(TIMESTAMP) AS MAX_TIMESTAMP, HISTORY_ID FROM " + resultSet.getString("TABLE_NAME") + " GROUP BY HISTORY_ID");
                while (resultSet2.next()) {
                    BAbsTime bAbsTime = BAbsTime.make((long)resultSet2.getTimestamp("MAX_TIMESTAMP").getTime());
                    hashMap.put(resultSet2.getString("HISTORY_ID"), bAbsTime);
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void doClearLastTimestamp() {
        BRdbmsHistoryExport[] bRdbmsHistoryExportArray = (BRdbmsHistoryExport[])this.getChildren(class$javax$baja$rdb$history$BRdbmsHistoryExport == null ? (class$javax$baja$rdb$history$BRdbmsHistoryExport = BRdbmsHistoryDeviceExt.class$("javax.baja.rdb.history.BRdbmsHistoryExport")) : class$javax$baja$rdb$history$BRdbmsHistoryExport);
        for (int i = 0; i < bRdbmsHistoryExportArray.length; ++i) {
            bRdbmsHistoryExportArray[i].setLastTimestamp(BAbsTime.NULL);
        }
        LOG.trace("Cleared " + bRdbmsHistoryExportArray.length + " timestamps.");
    }

    public String getUserName(BRdbms bRdbms, BRdbmsHistoryExport bRdbmsHistoryExport) {
        String string = bRdbmsHistoryExport.getUserName();
        if (string != null && !string.equals("")) {
            return string;
        }
        string = bRdbms.getUserName();
        if (string != null && !string.equals("")) {
            return string;
        }
        return "";
    }

    public BPassword getPassword(BRdbms bRdbms, BRdbmsHistoryExport bRdbmsHistoryExport) {
        BPassword bPassword = bRdbmsHistoryExport.getPassword();
        if (bPassword != null && !bPassword.equals((Object)BPassword.DEFAULT)) {
            return bPassword;
        }
        bPassword = bRdbms.getPassword();
        if (bPassword != null && !bPassword.equals((Object)BPassword.DEFAULT)) {
            return bPassword;
        }
        return BPassword.DEFAULT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

