/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Column;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.rdb.ddl.DdlCommand;

public class CreateTable
implements DdlCommand {
    private final String tableName;
    private final Column[] columns;
    private final Constraint[] constraints;

    public CreateTable(String string, Column[] columnArray, Constraint[] constraintArray) {
        this.tableName = string;
        this.columns = columnArray;
        this.constraints = constraintArray;
    }

    public String getDdl(RdbmsContext rdbmsContext) {
        int n;
        RdbmsDialect rdbmsDialect = (RdbmsDialect)rdbmsContext;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ").append(this.tableName).append(" (");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n].getDdl(rdbmsDialect));
        }
        for (n = 0; n < this.constraints.length; ++n) {
            stringBuffer.append(", ");
            stringBuffer.append(this.constraints[n].getDdl(rdbmsDialect, this.tableName));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Constraint[] getConstraints() {
        return this.constraints;
    }
}

