/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.log.Log;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.DdlCommand;

public class CreateIndex
implements DdlCommand {
    private final String indexName;
    private final String tableName;
    private final boolean isUnique;
    private final BClustered clustered;
    private final Column[] columns;

    public CreateIndex(String string, String string2, boolean bl, Column[] columnArray) {
        this(string, string2, bl, BClustered.unspecified, columnArray);
    }

    public CreateIndex(String string, String string2, boolean bl, BClustered bClustered, Column[] columnArray) {
        this.indexName = string;
        this.tableName = string2;
        this.isUnique = bl;
        this.clustered = bClustered;
        this.columns = columnArray;
    }

    public CreateIndex(String string, String string2, boolean bl, String[] stringArray) {
        this(string, string2, bl, CreateIndex.makeColumns(stringArray));
    }

    public CreateIndex(String string, String string2, boolean bl, BClustered bClustered, String[] stringArray) {
        this(string, string2, bl, bClustered, CreateIndex.makeColumns(stringArray));
    }

    private static Column[] makeColumns(String[] stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = new Column(stringArray[i]);
        }
        return columnArray;
    }

    public String getDdl(RdbmsContext rdbmsContext) {
        RdbmsDialect rdbmsDialect = (RdbmsDialect)rdbmsContext;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE ");
        if (this.isUnique) {
            stringBuffer.append("UNIQUE ");
        }
        stringBuffer.append(CreateIndex.clusteredDdl(rdbmsDialect, this.tableName, this.clustered));
        stringBuffer.append("INDEX ").append(this.indexName);
        stringBuffer.append(" ON ").append(this.tableName);
        stringBuffer.append("(");
        for (int i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[i].getName());
            if (!this.columns[i].isDescending()) continue;
            stringBuffer.append(" DESC");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static String clusteredDdl(RdbmsDialect rdbmsDialect, String string, BClustered bClustered) {
        if (!bClustered.equals((Object)BClustered.unspecified) && !rdbmsDialect.supportsClusteredIndex()) {
            Log.getLog((String)"rdb.jdbc").warning(rdbmsDialect.getClass().getName() + " does not support clustered indexes. " + "Table " + string + " will not have clustering specified.");
            return "";
        }
        switch (bClustered.getOrdinal()) {
            case 0: {
                return "";
            }
            case 1: {
                return "CLUSTERED ";
            }
            case 2: {
                return "NONCLUSTERED ";
            }
        }
        throw new IllegalStateException();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public BClustered isClustered() {
        return this.clustered;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public static class Column {
        private final String name;
        private final boolean descending;

        public Column(String string) {
            this(string, false);
        }

        public Column(String string, boolean bl) {
            this.name = string;
            this.descending = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDescending() {
            return this.descending;
        }
    }
}

