/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.BOnDelete;
import javax.baja.rdb.ddl.CreateIndex;

public class Constraint {
    public static final int UNIQUE = 0;
    public static final int PRIMARY_KEY = 1;
    public static final int FOREIGN_KEY = 2;
    private final String name;
    private final String[] columns;
    private final int type;
    private final BClustered clustered;
    private final String refTable;
    private final String[] refColumns;
    private final BOnDelete refOnDelete;

    public static Constraint makeUnique(String string, String[] stringArray) {
        return new Constraint(string, stringArray, 0);
    }

    public static Constraint makeUnique(String string, String[] stringArray, BClustered bClustered) {
        return new Constraint(string, stringArray, 0, bClustered);
    }

    public static Constraint makePrimaryKey(String string, String[] stringArray) {
        return new Constraint(string, stringArray, 1);
    }

    public static Constraint makePrimaryKey(String string, String[] stringArray, BClustered bClustered) {
        return new Constraint(string, stringArray, 1, bClustered);
    }

    public static Constraint makeForeignKey(String string, String[] stringArray, String string2, String[] stringArray2, BOnDelete bOnDelete) {
        return new Constraint(string, stringArray, string2, stringArray2, bOnDelete);
    }

    public static Constraint makeUnique(String string, String string2) {
        return new Constraint(string, new String[]{string2}, 0);
    }

    public static Constraint makePrimaryKey(String string, String string2) {
        return new Constraint(string, new String[]{string2}, 1);
    }

    public static Constraint makeForeignKey(String string, String string2, String string3, String string4, BOnDelete bOnDelete) {
        return new Constraint(string, new String[]{string2}, string3, new String[]{string4}, bOnDelete);
    }

    private Constraint(String string, String[] stringArray, int n) {
        this.name = string;
        this.columns = stringArray;
        this.type = n;
        this.clustered = BClustered.unspecified;
        this.refTable = null;
        this.refColumns = null;
        this.refOnDelete = null;
    }

    private Constraint(String string, String[] stringArray, int n, BClustered bClustered) {
        this.name = string;
        this.columns = stringArray;
        this.type = n;
        this.clustered = bClustered;
        this.refTable = null;
        this.refColumns = null;
        this.refOnDelete = null;
    }

    private Constraint(String string, String[] stringArray, String string2, String[] stringArray2, BOnDelete bOnDelete) {
        this.name = string;
        this.columns = stringArray;
        this.type = 2;
        this.clustered = BClustered.unspecified;
        this.refTable = string2;
        this.refColumns = stringArray2;
        this.refOnDelete = bOnDelete;
    }

    public String getDdl(RdbmsContext rdbmsContext, String string) {
        int n;
        RdbmsDialect rdbmsDialect = (RdbmsDialect)rdbmsContext;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CONSTRAINT ").append(this.getName()).append(" ");
        switch (this.type) {
            case 0: {
                stringBuffer.append("UNIQUE ");
                break;
            }
            case 1: {
                stringBuffer.append("PRIMARY KEY ");
                break;
            }
            case 2: {
                stringBuffer.append("FOREIGN KEY ");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        stringBuffer.append(CreateIndex.clusteredDdl(rdbmsDialect, string, this.clustered));
        stringBuffer.append("(");
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n]);
        }
        stringBuffer.append(")");
        if (this.type == 2) {
            stringBuffer.append(" REFERENCES ").append(this.refTable).append(" ");
            stringBuffer.append("(");
            for (n = 0; n < this.refColumns.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.refColumns[n]);
            }
            stringBuffer.append(")");
            stringBuffer.append(" ON DELETE ");
            stringBuffer.append(rdbmsDialect.getOnDelete(this.refOnDelete.getOrdinal()));
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int getConstraintType() {
        return this.type;
    }

    public BClustered isClustered() {
        return this.clustered;
    }

    public String getRefTable() {
        if (this.type != 2) {
            throw new UnsupportedOperationException();
        }
        return this.refTable;
    }

    public String[] getRefColumns() {
        if (this.type != 2) {
            throw new UnsupportedOperationException();
        }
        return this.refColumns;
    }

    public BOnDelete getRefOnDelete() {
        if (this.type != 2) {
            throw new UnsupportedOperationException();
        }
        return this.refOnDelete;
    }
}

