/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb.ddl;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BFixedWidthTranslator;
import javax.baja.rdb.RdbmsContext;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;

public class Column {
    private static final int IDENTITY = 1;
    private static final int KEY = 2;
    private static final int UNIQUE = 4;
    private static final int CLOB = 8;
    private final String name;
    private final Type type;
    private final BValue defaultValue;
    private final int width;
    private final int flags;

    public static Column makeIdentity(String string, boolean bl) {
        return new Column(string, BInteger.TYPE, (BValue)BInteger.DEFAULT, -1, bl ? 3 : 1);
    }

    public static Column makeKey(String string, Type type, BValue bValue) {
        return new Column(string, type, bValue, -1, 2);
    }

    public static Column makeKey(String string, Type type, BValue bValue, int n) {
        return new Column(string, type, bValue, n, 2);
    }

    public static Column makeUnique(String string, Type type, BValue bValue) {
        return new Column(string, type, bValue, -1, 4);
    }

    public static Column makeUnique(String string, Type type, BValue bValue, int n) {
        return new Column(string, type, bValue, n, 4);
    }

    public static Column makeClob(String string) {
        return new Column(string, BString.TYPE, (BValue)BString.DEFAULT, -1, 8);
    }

    public static Column make(String string, Type type, BValue bValue) {
        return new Column(string, type, bValue, -1, 0);
    }

    public static Column make(String string, Type type, BValue bValue, int n) {
        return new Column(string, type, bValue, n, 0);
    }

    public static Column make(String string, Type type, BValue bValue, int n, int n2) {
        return new Column(string, type, bValue, n, n2);
    }

    private Column(String string, Type type, BValue bValue, int n, int n2) {
        this.name = string;
        this.type = type;
        this.defaultValue = bValue;
        this.width = n;
        this.flags = n2;
    }

    public String getDdl(RdbmsContext rdbmsContext) {
        return this.getDdl(rdbmsContext, false);
    }

    public String getDdl(RdbmsContext rdbmsContext, boolean bl) {
        RdbmsDialect rdbmsDialect = (RdbmsDialect)rdbmsContext;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append(" ");
        if (bl && rdbmsDialect.getAlterColumnSuffix() != null) {
            stringBuffer.append(rdbmsDialect.getAlterColumnSuffix()).append(" ");
        }
        stringBuffer.append(this.makeTypeDdl(rdbmsDialect));
        if (this.isIdentity()) {
            if (rdbmsDialect.getInsertionMode() != 0 && !bl) {
                stringBuffer.append(" ").append(rdbmsDialect.getIdentityCreation());
            }
            if (!bl || rdbmsDialect.getAlterColumnSupportsNotNull()) {
                stringBuffer.append(" NOT NULL");
            }
        } else if ((this.isKey() || this.isUnique()) && (!bl || rdbmsDialect.getAlterColumnSupportsNotNull())) {
            stringBuffer.append(" NOT NULL");
        }
        return stringBuffer.toString();
    }

    private String makeTypeDdl(RdbmsDialect rdbmsDialect) {
        BColumnTranslator bColumnTranslator = BColumnTranslator.makeTranslator(rdbmsDialect, this.defaultValue);
        switch (bColumnTranslator.getSqlType().getOrdinal()) {
            case 0: {
                this.checkNoWidth();
                return rdbmsDialect.getIntType();
            }
            case 1: {
                this.checkNoWidth();
                return rdbmsDialect.getLongType();
            }
            case 2: {
                this.checkNoWidth();
                return rdbmsDialect.getFloatType();
            }
            case 3: {
                this.checkNoWidth();
                return rdbmsDialect.getDoubleType();
            }
            case 9: {
                this.checkNoWidth();
                return rdbmsDialect.getUuidType();
            }
            case 10: {
                this.checkNoWidth();
                return rdbmsDialect.getBlobType();
            }
            case 4: {
                this.checkNoWidth();
                return rdbmsDialect.supportsBooleanType() ? rdbmsDialect.getBooleanType() : rdbmsDialect.getCharType() + "(1)";
            }
            case 5: {
                this.checkNoWidth();
                return rdbmsDialect.supportsMillisecondTimestamp() ? rdbmsDialect.getTimestampType() : rdbmsDialect.getLongType();
            }
            case 11: {
                this.checkNoWidth();
                return rdbmsDialect.supportsDateType() ? rdbmsDialect.getDateType() : rdbmsDialect.getTimestampType();
            }
            case 6: {
                if (bColumnTranslator instanceof BFixedWidthTranslator) {
                    this.checkNoWidth();
                    return rdbmsDialect.getCharType() + "(" + ((BFixedWidthTranslator)bColumnTranslator).getColumnWidth() + ")";
                }
                this.checkHasWidth();
                return rdbmsDialect.getCharType() + "(" + this.width + ")";
            }
            case 7: {
                if (this.isClob()) {
                    this.checkNoWidth();
                    return rdbmsDialect.getClobType();
                }
                this.checkHasWidth();
                return rdbmsDialect.getVarCharType() + "(" + this.width + ")";
            }
        }
        throw new IllegalStateException();
    }

    private void checkNoWidth() {
        if (this.width != -1) {
            throw new BajaRuntimeException("Illegal WIDTH specification '" + this.width + "' for column  '" + this.name + "'");
        }
    }

    private void checkHasWidth() {
        if (this.width == -1) {
            throw new BajaRuntimeException("Missing WIDTH specification for column  '" + this.name + "'");
        }
    }

    public static boolean requiresWidth(RdbmsContext rdbmsContext, BValue bValue) {
        RdbmsDialect rdbmsDialect = (RdbmsDialect)rdbmsContext;
        BColumnTranslator bColumnTranslator = BColumnTranslator.makeTranslator(rdbmsDialect, bValue);
        switch (bColumnTranslator.getSqlType().getOrdinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 11: {
                return false;
            }
            case 6: {
                return !(bColumnTranslator instanceof BFixedWidthTranslator);
            }
            case 7: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public BValue getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isIdentity() {
        return (this.flags & 1) != 0;
    }

    public boolean isKey() {
        return (this.flags & 2) != 0;
    }

    public boolean isUnique() {
        return (this.flags & 4) != 0;
    }

    public boolean isClob() {
        return (this.flags & 8) != 0;
    }
}

