/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb;

import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSession;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsScheme;
import javax.baja.rdb.RdbmsQuery;
import javax.baja.security.AuthenticationException;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BRdbmsSession
extends BSession
implements AuthenticationRealm {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$BRdbmsSession == null ? (class$javax$baja$rdb$BRdbmsSession = BRdbmsSession.class$("javax.baja.rdb.BRdbmsSession")) : class$javax$baja$rdb$BRdbmsSession));
    private static final BIcon iconConnected = BIcon.std((String)"database.png");
    private static final BIcon iconDisconnected = BIcon.std((String)"databaseDisconnected.png");
    private BHost host;
    private RdbmsQuery query;
    private BRdbmsScheme scheme;
    private BOrd ordInHost;
    private BOrd absOrd;
    private BRdbms database;
    private Connection connection;
    private BUsernameAndPassword credentials;
    static /* synthetic */ Class class$javax$baja$rdb$BRdbmsSession;

    public Type getType() {
        return TYPE;
    }

    public static BRdbmsSession make(BHost bHost, RdbmsQuery rdbmsQuery, BRdbmsScheme bRdbmsScheme) {
        String string = rdbmsQuery.getNavName();
        BRdbmsSession bRdbmsSession = (BRdbmsSession)bHost.getNavChild(string);
        if (bRdbmsSession == null) {
            bRdbmsSession = new BRdbmsSession(bHost, rdbmsQuery, bRdbmsScheme);
            bHost.addNavChild((BINavNode)bRdbmsSession);
        }
        return bRdbmsSession;
    }

    private BRdbmsSession(BHost bHost, RdbmsQuery rdbmsQuery, BRdbmsScheme bRdbmsScheme) {
        super(rdbmsQuery.getNavName());
        this.host = bHost;
        this.query = rdbmsQuery;
        this.scheme = bRdbmsScheme;
        this.ordInHost = BOrd.make((OrdQuery)rdbmsQuery.duplicate());
        this.absOrd = BOrd.make((BOrd)bHost.getAbsoluteOrd(), (BOrd)this.ordInHost);
        this.database = bRdbmsScheme.newDatabase(bHost, rdbmsQuery);
        this.connection = null;
        this.credentials = null;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void connect() throws Exception {
        if (this.isConnected()) {
            return;
        }
        try {
            this.connection = this.database.getConnection(this.credentials == null ? "" : this.credentials.getUsername(), this.credentials == null ? BPassword.DEFAULT : this.credentials.getPassword());
            this.database.setStatus(BStatus.makeDown((BStatus)this.database.getStatus(), (boolean)false));
        }
        catch (SQLException sQLException) {
            this.database.setStatus(BStatus.makeDown((BStatus)this.database.getStatus(), (boolean)true));
            throw new AuthenticationException((AuthenticationRealm)this, (Throwable)sQLException);
        }
    }

    public void disconnect() {
        if (this.connection == null) {
            return;
        }
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.connection = null;
    }

    public void close() {
        this.disconnect();
        this.host.removeNavChild((BINavNode)this);
    }

    public BHost getHost() {
        return this.host;
    }

    public BOrd getAbsoluteOrd() {
        return this.absOrd;
    }

    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    public String getAuthenticationRealmName() {
        return this.absOrd.toString();
    }

    public String getAuthenticationScheme() {
        return this.scheme.getAuthName();
    }

    public BICredentials makeCredentials() {
        return new BUsernameAndPassword();
    }

    public BICredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(BICredentials bICredentials) {
        this.credentials = (BUsernameAndPassword)bICredentials;
    }

    public String getNavDisplayName(Context context) {
        String string = this.scheme.getAuthName() + ":" + this.getHost().toString() + ":" + this.query.getBody();
        if (this.isConnected()) {
            return string + " [Connected]";
        }
        return string + " [Disconnected]";
    }

    public BOrd getNavOrd() {
        return this.absOrd;
    }

    public String getHostName() {
        return this.host.toString();
    }

    public RdbmsQuery getQuery() {
        return this.query;
    }

    public BRdbmsScheme getScheme() {
        return this.scheme;
    }

    public BRdbms getDatabase() {
        return this.database;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public BIcon getIcon() {
        return this.isConnected() ? iconConnected : iconDisconnected;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

