/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rdb;

import com.tridium.rdb.jdbc.RdbmsDialect;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.BRdbmsWorker;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.rdb.point.BRdbmsPointDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

public abstract class BRdbms
extends BDevice
implements BILicensed {
    public static final Property hostAddress = BRdbms.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:HostOrdFE")));
    public static final Property ownerName = BRdbms.newProperty((int)4, (String)"", null);
    public static final Property userName = BRdbms.newProperty((int)0, (String)"", null);
    public static final Property password = BRdbms.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property worker = BRdbms.newProperty((int)0, (BValue)new BRdbmsWorker(), null);
    public static final Property exportMode = BRdbms.newProperty((int)0, (BValue)BRdbmsHistoryExportMode.byHistoryId, null);
    public static final Property useUnicodeEncodingScheme = BRdbms.newProperty((int)0x10000000, (boolean)false, null);
    public static final Property timestampStorage = BRdbms.newProperty((int)0x10000000, (BValue)BRdbmsTimestampStorage.dialectDefault, null);
    public static final Property points = BRdbms.newProperty((int)0, (BValue)new BRdbmsPointDeviceExt(), null);
    public static final Property sqlSchemeEnabled = BRdbms.newProperty((int)0, (boolean)false, null);
    public static final Action allowDialectModifications = BRdbms.newAction((int)128, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$rdb$BRdbms == null ? (class$javax$baja$rdb$BRdbms = BRdbms.class$("javax.baja.rdb.BRdbms")) : class$javax$baja$rdb$BRdbms));
    static /* synthetic */ Class class$javax$baja$rdb$BRdbms;

    public BOrd getHostAddress() {
        return (BOrd)this.get(hostAddress);
    }

    public void setHostAddress(BOrd bOrd) {
        this.set(hostAddress, (BValue)bOrd, null);
    }

    public String getOwnerName() {
        return this.getString(ownerName);
    }

    public void setOwnerName(String string) {
        this.setString(ownerName, string, null);
    }

    public String getUserName() {
        return this.getString(userName);
    }

    public void setUserName(String string) {
        this.setString(userName, string, null);
    }

    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    public void setPassword(BPassword bPassword) {
        this.set(password, (BValue)bPassword, null);
    }

    public BRdbmsWorker getWorker() {
        return (BRdbmsWorker)this.get(worker);
    }

    public void setWorker(BRdbmsWorker bRdbmsWorker) {
        this.set(worker, (BValue)bRdbmsWorker, null);
    }

    public BRdbmsHistoryExportMode getExportMode() {
        return (BRdbmsHistoryExportMode)this.get(exportMode);
    }

    public void setExportMode(BRdbmsHistoryExportMode bRdbmsHistoryExportMode) {
        this.set(exportMode, (BValue)bRdbmsHistoryExportMode, null);
    }

    public boolean getUseUnicodeEncodingScheme() {
        return this.getBoolean(useUnicodeEncodingScheme);
    }

    public void setUseUnicodeEncodingScheme(boolean bl) {
        this.setBoolean(useUnicodeEncodingScheme, bl, null);
    }

    public BRdbmsTimestampStorage getTimestampStorage() {
        return (BRdbmsTimestampStorage)this.get(timestampStorage);
    }

    public void setTimestampStorage(BRdbmsTimestampStorage bRdbmsTimestampStorage) {
        this.set(timestampStorage, (BValue)bRdbmsTimestampStorage, null);
    }

    public BRdbmsPointDeviceExt getPoints() {
        return (BRdbmsPointDeviceExt)this.get(points);
    }

    public void setPoints(BRdbmsPointDeviceExt bRdbmsPointDeviceExt) {
        this.set(points, (BValue)bRdbmsPointDeviceExt, null);
    }

    public boolean getSqlSchemeEnabled() {
        return this.getBoolean(sqlSchemeEnabled);
    }

    public void setSqlSchemeEnabled(boolean bl) {
        this.setBoolean(sqlSchemeEnabled, bl, null);
    }

    public void allowDialectModifications() {
        this.invoke(allowDialectModifications, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BRdbmsNetwork.TYPE;
    }

    protected IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        try {
            Connection connection = this.getConnection(this.getUserName(), this.getPassword());
            RdbmsDialect rdbmsDialect = (RdbmsDialect)this.getRdbmsContext();
            connection.createStatement().execute(rdbmsDialect.getValidationQuery());
            connection.close();
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)false));
            this.pingOk();
        }
        catch (Throwable throwable) {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
            this.pingFail(throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public final void started() throws Exception {
        super.started();
        this.checkLicense();
    }

    public void pingOk() {
        super.pingOk();
        this.preventDialectModifications();
    }

    public void preventDialectModifications() {
        Property[] propertyArray = this.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!Flags.isUserDefined1((BComplex)this, (Slot)propertyArray[i]) || Flags.isReadonly((BComplex)this, (Slot)propertyArray[i])) continue;
            this.setFlags((Slot)propertyArray[i], this.getFlags((Slot)propertyArray[i]) | 1);
        }
    }

    public void doAllowDialectModifications(Context context) {
        Property[] propertyArray = this.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!Flags.isUserDefined1((BComplex)this, (Slot)propertyArray[i]) || !Flags.isReadonly((BComplex)this, (Slot)propertyArray[i])) continue;
            this.setFlags((Slot)propertyArray[i], this.getFlags((Slot)propertyArray[i]) & 0xFFFFFFFE);
        }
    }

    public abstract Feature getLicenseFeature();

    private void checkLicense() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
        }
        catch (Exception exception) {
            this.getLog().error("Unlicensed: " + this.toPathString(), (Throwable)exception);
            this.configFatal("Unlicensed: " + exception);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUserName(), this.getPassword());
    }

    public abstract Connection getConnection(String var1, BPassword var2) throws SQLException;

    public final String getHostname() {
        if (this.getHostAddress().isNull()) {
            return "";
        }
        try {
            return ((BHost)this.getHostAddress().get()).getHostname();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public abstract RdbmsContext getRdbmsContext();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

