/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util.history;

import com.tridium.rdb.jdbc.trans.BSqlType;
import com.tridium.rdb.util.BRdbmsUpdater;
import com.tridium.rdb.util.BStoredTimeZone;
import com.tridium.rdb.util.BTimezoneUpdateJob;
import com.tridium.rdb.util.history.BHistoryTimezoneUpdater;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryTimezoneUpdateJob
extends BTimezoneUpdateJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob == null ? (class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob = BHistoryTimezoneUpdateJob.class$("com.tridium.rdb.util.history.BHistoryTimezoneUpdateJob")) : class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob));
    private BHistoryTimezoneUpdater historyUpdater;
    private static final String HISTORY_CONFIG_TABLE = "HISTORY_CONFIG";
    private static final String HISTORY_TYPE_MAP_TABLE = "HISTORY_TYPE_MAP";
    private static final String RECORD_TYPE_COLUMN = "RECORDTYPE";
    private static final String TABLE_NAME_COLUMN = "TABLE_NAME";
    private static final String HISTORY_ID_COLUMN = "ID_";
    private static final String HISTORY_CONFIG_TIMEZONE_COLUMN = "TIMEZONE";
    private static final String DB_TIMEZONE_COLUMN = "DB_TIMEZONE";
    private static final String UTC_OFFSET_COLUMN = "UTC_OFFSET";
    private static final String TIMESTAMP_COLUMN = "TIMESTAMP";
    private static final String ID_COLUMN = "ID";
    private static final Calendar UTC_CALENDER = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    static /* synthetic */ Class class$com$tridium$rdb$util$history$BHistoryTimezoneUpdateJob;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public BHistoryTimezoneUpdateJob() {
    }

    public BHistoryTimezoneUpdateJob(BRdbmsUpdater bRdbmsUpdater) {
        super(bRdbmsUpdater);
        this.historyUpdater = (BHistoryTimezoneUpdater)bRdbmsUpdater;
    }

    protected void updateEnding() {
        super.updateEnding();
        if (this.transactionCommitted) {
            this.database.setTimestampStorage(BRdbmsTimestampStorage.utcTimestamp);
            BRdbmsHistoryDeviceExt bRdbmsHistoryDeviceExt = (BRdbmsHistoryDeviceExt)this.database.get("histories");
            bRdbmsHistoryDeviceExt.setUseLastTimestamp(false);
            bRdbmsHistoryDeviceExt.setUseHistoryConfigTimeZone(false);
        }
    }

    protected String[] getTableNamesToUpdate() throws Exception {
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BHistoryTimezoneUpdateJob.class$("java.lang.String")) : class$java$lang$String);
        if (this.dialect.tableExists(this.database, this.conn, HISTORY_CONFIG_TABLE)) {
            array.add((Object)HISTORY_CONFIG_TABLE);
        }
        if (this.dialect.tableExists(this.database, this.conn, HISTORY_TYPE_MAP_TABLE)) {
            array.add((Object)HISTORY_TYPE_MAP_TABLE);
        }
        return (String[])array.trim();
    }

    private String[] getHistoryTableNames(String string) throws Exception {
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BHistoryTimezoneUpdateJob.class$("java.lang.String")) : class$java$lang$String);
        String string2 = "SELECT * FROM " + string;
        ResultSet resultSet = this.statement.executeQuery(string2);
        while (resultSet.next()) {
            array.add((Object)resultSet.getString(TABLE_NAME_COLUMN));
        }
        resultSet.close();
        return (String[])array.trim();
    }

    protected void updateTable(String string) throws Exception {
        if (string.equals(HISTORY_CONFIG_TABLE)) {
            this.upgradeHistoryConfigTable();
        } else if (string.equals(HISTORY_TYPE_MAP_TABLE)) {
            this.upgradeHistoryTypeMapTable();
        }
    }

    private void upgradeHistoryConfigTable() throws SQLException {
        String string;
        if (this.schemaUpgradeRequired(HISTORY_CONFIG_TABLE)) {
            string = this.getAddDbTimezoneColumnSql(HISTORY_CONFIG_TABLE);
            this.statement.execute(string);
            BTimeZone bTimeZone = this.historyUpdater.getCurrentTimestampStoragePolicy().equals((Object)BStoredTimeZone.stationTimeZone) ? BTimeZone.getLocal() : null;
            String string2 = bTimeZone == null ? HISTORY_CONFIG_TIMEZONE_COLUMN : "'" + bTimeZone + "'";
            String string3 = "UPDATE HISTORY_CONFIG SET DB_TIMEZONE = " + string2;
            this.statement.execute(string3);
        } else {
            this.log().message("No schema upgrades required for table HISTORY_CONFIG");
        }
        this.addUtcOffsetsForMetaTable(HISTORY_CONFIG_TABLE);
        string = "UPDATE HISTORY_CONFIG SET DB_TIMEZONE = '" + BTimeZone.UTC + "'";
        this.statement.execute(string);
    }

    private void upgradeHistoryTypeMapTable() throws SQLException {
        Object object;
        if (this.schemaUpgradeRequired(HISTORY_TYPE_MAP_TABLE)) {
            BTimeZone bTimeZone;
            String string;
            Object object2;
            Object object3;
            object = null;
            Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BHistoryTimezoneUpdateJob.class$("java.lang.String")) : class$java$lang$String);
            String string2 = "SELECT * FROM HISTORY_TYPE_MAP";
            object = this.statement.executeQuery(string2);
            while (object.next()) {
                array.add((Object)(object.getString(TABLE_NAME_COLUMN) + "&" + object.getString(RECORD_TYPE_COLUMN)));
            }
            object.close();
            this.statement.execute("DELETE FROM HISTORY_TYPE_MAP");
            String string3 = this.dialect.makeAddColumnSql(HISTORY_TYPE_MAP_TABLE, HISTORY_ID_COLUMN, BSqlType.sqlNVarchar, 100, "<id>");
            String string4 = this.dialect.makeAddColumnSql(HISTORY_TYPE_MAP_TABLE, HISTORY_CONFIG_TIMEZONE_COLUMN, BSqlType.sqlNVarchar, 100, BTimeZone.NULL.toString());
            this.statement.addBatch(string3);
            this.statement.addBatch(string4);
            this.statement.addBatch(this.getAddDbTimezoneColumnSql(HISTORY_TYPE_MAP_TABLE));
            this.statement.executeBatch();
            String[] stringArray = (String[])array.trim();
            HashMap<Object, BTimeZone> hashMap = new HashMap<Object, BTimeZone>();
            for (int i = 0; i < stringArray.length; ++i) {
                object3 = stringArray[i];
                int n = stringArray[i].lastIndexOf("&");
                String string5 = stringArray[i].substring(0, n);
                object2 = new Array(class$java$lang$String == null ? BHistoryTimezoneUpdateJob.class$("java.lang.String") : class$java$lang$String);
                string = "SELECT DISTINCT HISTORY_ID FROM " + string5;
                object = this.statement.executeQuery(string);
                while (object.next()) {
                    object2.add((Object)object.getString("HISTORY_ID"));
                }
                object.close();
                bTimeZone = (BTimeZone)object2.trim();
                hashMap.put(object3, bTimeZone);
            }
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                String string6 = object3.getKey().toString();
                int n = string6.lastIndexOf("&");
                object2 = string6.substring(0, n);
                string = string6.substring(n + 1);
                bTimeZone = BTimeZone.NULL;
                BStoredTimeZone bStoredTimeZone = this.historyUpdater.getCurrentTimestampStoragePolicy();
                BTimeZone bTimeZone2 = bStoredTimeZone.equals((Object)BStoredTimeZone.stationTimeZone) ? BTimeZone.getLocal() : (bStoredTimeZone.equals((Object)BStoredTimeZone.historyConfigTimeZone) ? bTimeZone : BTimeZone.NULL);
                String[] stringArray2 = (String[])object3.getValue();
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string7 = stringArray2[i];
                    BIHistory bIHistory = this.getHistorySpace().getHistory(BHistoryId.make((String)string7));
                    if (bIHistory != null) {
                        bTimeZone = bIHistory.getConfig().getTimeZone();
                    }
                    String[] stringArray3 = new String[]{RECORD_TYPE_COLUMN, TABLE_NAME_COLUMN, HISTORY_ID_COLUMN, HISTORY_CONFIG_TIMEZONE_COLUMN, DB_TIMEZONE_COLUMN};
                    BString[] bStringArray = new BString[]{BString.make((String)string), BString.make((String)object2), BString.make((String)string7), BString.make((String)bTimeZone.toString()), BString.make((String)bTimeZone2.toString())};
                    BFacets[] bFacetsArray = new BFacets[bStringArray.length];
                    PreparedStatement preparedStatement = this.conn.prepareStatement(this.dialect.makeInsertSql(HISTORY_TYPE_MAP_TABLE, new Property[0], stringArray3));
                    this.dialect.insertRecord(preparedStatement, null, new Property[0], (BObject[])bStringArray, bFacetsArray);
                    preparedStatement.executeBatch();
                    preparedStatement.close();
                }
            }
        } else {
            this.log().message("No schema upgrades required for table HISTORY_TYPE_MAP");
        }
        this.addUtcOffsetsForMetaTable(HISTORY_TYPE_MAP_TABLE);
        object = "UPDATE HISTORY_TYPE_MAP SET DB_TIMEZONE = '" + BTimeZone.UTC + "'";
        this.statement.execute((String)object);
    }

    private void addUtcOffsetsForMetaTable(String string) throws SQLException {
        ResultSet resultSet = this.statement.executeQuery("SELECT DISTINCT TABLE_NAME, DB_TIMEZONE FROM " + string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(TABLE_NAME_COLUMN), resultSet.getString(DB_TIMEZONE_COLUMN));
        }
        resultSet.close();
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = entry.getKey().toString();
            String string3 = entry.getValue().toString();
            this.addUtcOffsetsToTable(string2, string3);
        }
    }

    private void addUtcOffsetsToTable(String string, String string2) throws SQLException {
        if (!this.dialect.supportsTimestamp()) {
            this.log().message("UTC offset column update not required for table " + string);
            return;
        }
        String string3 = string2.substring(0, string2.indexOf("(")).trim();
        TimeZone timeZone = TimeZone.getTimeZone(string3);
        Calendar calendar = Calendar.getInstance(timeZone);
        PreparedStatement preparedStatement = this.conn.prepareStatement("UPDATE " + string + " SET " + TIMESTAMP_COLUMN + " = ? WHERE ID = ?");
        String string4 = "SELECT ID, TIMESTAMP FROM " + string;
        ResultSet resultSet = this.statement.executeQuery(string4);
        while (resultSet.next()) {
            int n = resultSet.getInt(ID_COLUMN);
            Timestamp timestamp = resultSet.getTimestamp(TIMESTAMP_COLUMN, calendar);
            preparedStatement.setTimestamp(1, timestamp, UTC_CALENDER);
            preparedStatement.setInt(2, n);
            preparedStatement.addBatch();
        }
        resultSet.close();
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    private boolean schemaUpgradeRequired(String string) throws SQLException {
        ResultSet resultSet = this.metadata.getColumns(null, null, string, DB_TIMEZONE_COLUMN);
        boolean bl = !resultSet.next();
        resultSet.close();
        return bl;
    }

    private String getAddDbTimezoneColumnSql(String string) {
        return this.dialect.makeAddColumnSql(string, DB_TIMEZONE_COLUMN, BSqlType.sqlNVarchar, 100, BTimeZone.NULL.toString());
    }

    private String getAddUtcOffsetColumnSql(String string) {
        return this.dialect.makeAddColumnSql(string, UTC_OFFSET_COLUMN, BSqlType.sqlLong, -1, "0");
    }

    private BHistorySpace getHistorySpace() {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        return bHistoryService.getDatabase();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

