/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.util.BJobMonitorPane;
import com.tridium.rdb.util.BRdbmsUpdater;
import com.tridium.rdb.util.BStoredTimeZone;
import com.tridium.rdb.util.history.BHistoryTimezoneUpdater;
import com.tridium.rdb.util.history.BHistoryUnicodeUpdater;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.StepWizardModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.ui.wizard.step.util.WizardHeaderUiHandler;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;

public class RdbmsUpdateWizard {
    private BWidget owner;
    private BRdbmsNetwork rdbmsNetwork;
    private Context cx;
    private static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$rdb$util$RdbmsUpdateWizard == null ? (class$com$tridium$rdb$util$RdbmsUpdateWizard = RdbmsUpdateWizard.class$("com.tridium.rdb.util.RdbmsUpdateWizard")) : class$com$tridium$rdb$util$RdbmsUpdateWizard));
    private static final BImage WIZARD_ICON = BImage.make((BIcon)BIcon.std((String)"wizard.png"));
    private static final BImage DATABASE_ICON = BImage.make((BIcon)BIcon.std((String)"database.png"));
    private static final String WIZARD_DIALOG_TITLE = lex.getText("rdb.wizard.dialog.title");
    private static final String STEP1_TITLE = lex.getText("rdb.wizard.step1.title");
    private static final String STEP1_DESC = lex.getText("rdb.wizard.step1.description");
    private static final String STEP2_UNICODE_TITLE = lex.getText("rdb.wizard.step2.unicode.title");
    private static final String STEP2_UNICODE_DESC = lex.getText("rdb.wizard.step2.unicode.description");
    private static final String STEP2_TIMEZONE_TITLE = lex.getText("rdb.wizard.step2.timezone.title");
    private static final String STEP2_TIMEZONE_DESC = lex.getText("rdb.wizard.step2.timezone.description");
    private static final String STEP3_UNICODE_TITLE = lex.getText("rdb.wizard.step3.unicode.title");
    private static final String STEP3_UNICODE_DESC = lex.getText("rdb.wizard.step3.unicode.description");
    private static final String STEP3_TIMEZONE_TITLE = lex.getText("rdb.wizard.step3.timezone.title");
    private static final String STEP3_TIMEZONE_DESC = lex.getText("rdb.wizard.step3.timezone.description");
    private static final String STEP4_TIMEZONE_TITLE = lex.getText("rdb.wizard.step4.timezone.title");
    private static final String STEP4_TIMEZONE_DESC = lex.getText("rdb.wizard.step4.timezone.description");
    private BCheckBox step1UnicodeUpdateCb = new BCheckBox(lex.getText("rdb.wizard.step1.unicodeCbLabel"));
    private BCheckBox step1TimezoneUpdateCb = new BCheckBox(lex.getText("rdb.wizard.step1.timezoneCbLabel"));
    private BCheckList unicodeDbList = new BCheckList();
    private BCheckList timezoneDbList = new BCheckList();
    private BRadioButton stationTzRb;
    private BRadioButton historyConfigTzRb;
    private static final String STATION_TIMEZONE_STORAGE = "Timestamps are being stored using the station timezone";
    private static final String HISTORY_CONFIG_TIMEZONE_STORAGE = "Timestamps are being stored using the history config timezone";
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$javax$baja$rdb$BRdbms;
    static /* synthetic */ Class class$com$tridium$rdb$util$RdbmsUpdateWizard;

    private RdbmsUpdateWizard(BWidget bWidget, BRdbmsNetwork bRdbmsNetwork, Context context) {
        this.owner = bWidget;
        this.rdbmsNetwork = bRdbmsNetwork;
        this.cx = context;
    }

    public static RdbmsUpdateWizard make(BWidget bWidget, BRdbmsNetwork bRdbmsNetwork, Context context) {
        return new RdbmsUpdateWizard(bWidget, bRdbmsNetwork, context);
    }

    public CommandArtifact doInvoke() {
        BWizard.open((BWidget)this.owner, (WizardModel)this.makeWizardModel());
        return null;
    }

    private WizardModel makeWizardModel() {
        final WizardStep wizardStep = RdbmsUpdateWizard.makeStep(STEP1_TITLE, STEP1_DESC, this.makeStep1Widget());
        final WizardStep wizardStep2 = RdbmsUpdateWizard.makeStep(STEP2_UNICODE_TITLE, STEP2_UNICODE_DESC, this.makeSelectDbsWidget(this.unicodeDbList));
        final WizardStep wizardStep3 = RdbmsUpdateWizard.makeStep(STEP2_TIMEZONE_TITLE, STEP2_TIMEZONE_DESC, this.makeSelectDbsWidget(this.timezoneDbList));
        WizardStep wizardStep4 = RdbmsUpdateWizard.makeStep(STEP3_TIMEZONE_TITLE, STEP3_TIMEZONE_DESC, this.makeSpecifyTimezonePolicyWidget());
        wizardStep3.setNext(wizardStep4);
        wizardStep.setRouter(new WizardStep.IRouter(){

            public WizardStep next(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
                return RdbmsUpdateWizard.this.step1UnicodeUpdateCb.isSelected() ? wizardStep2 : (RdbmsUpdateWizard.this.step1TimezoneUpdateCb.isSelected() ? wizardStep3 : wizardStep);
            }
        });
        wizardStep2.setRouter(new WizardStep.IRouter(){

            public WizardStep next(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
                WizardStep wizardStep = RdbmsUpdateWizard.makeStep(STEP3_UNICODE_TITLE, STEP3_UNICODE_DESC, RdbmsUpdateWizard.this.makeJobProgressWidget(RdbmsUpdateWizard.this.unicodeDbList, new BHistoryUnicodeUpdater()));
                if (RdbmsUpdateWizard.this.step1TimezoneUpdateCb.isSelected()) {
                    wizardStep.setNext(wizardStep3);
                }
                return wizardStep;
            }
        });
        wizardStep4.setRouter(new WizardStep.IRouter(){

            public WizardStep next(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
                BHistoryTimezoneUpdater bHistoryTimezoneUpdater = new BHistoryTimezoneUpdater();
                bHistoryTimezoneUpdater.setCurrentTimestampStoragePolicy(RdbmsUpdateWizard.this.stationTzRb.isSelected() ? BStoredTimeZone.stationTimeZone : BStoredTimeZone.historyConfigTimeZone);
                WizardStep wizardStep = RdbmsUpdateWizard.makeStep(STEP4_TIMEZONE_TITLE, STEP4_TIMEZONE_DESC, RdbmsUpdateWizard.this.makeJobProgressWidget(RdbmsUpdateWizard.this.timezoneDbList, bHistoryTimezoneUpdater));
                return wizardStep;
            }
        });
        StepModel stepModel = StepModel.make((WizardStep)wizardStep);
        StepWizardModel stepWizardModel = new StepWizardModel(stepModel, WIZARD_DIALOG_TITLE);
        return stepWizardModel;
    }

    private static WizardStep makeStep(String string, String string2, BWidget bWidget) {
        WizardHeaderUiHandler wizardHeaderUiHandler = new WizardHeaderUiHandler(WIZARD_ICON, string, string2, (WizardStep.IUiHandler)new WidgetUiHandler(bWidget));
        WizardStep wizardStep = new WizardStep((WizardStep.IUiHandler)wizardHeaderUiHandler);
        return wizardStep;
    }

    private BWidget makeStep1Widget() {
        BGridPane bGridPane = new BGridPane(1, new BWidget[]{this.step1UnicodeUpdateCb, new BNullWidget(), this.step1TimezoneUpdateCb});
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, BInsets.make((double)10.0));
        return bBorderPane;
    }

    private BWidget makeSelectDbsWidget(BCheckList bCheckList) {
        BRdbms[] bRdbmsArray = this.getDatabases();
        for (int i = 0; i < bRdbmsArray.length; ++i) {
            bCheckList.addItem(DATABASE_ICON, (Object)new DbEntry(bRdbmsArray[i].getDisplayName(null), bRdbmsArray[i].getHandleOrd()));
        }
        BBorderPane bBorderPane = new BBorderPane((BWidget)bCheckList, BInsets.make((double)10.0));
        return bBorderPane;
    }

    private BWidget makeJobProgressWidget(BCheckList bCheckList, BRdbmsUpdater bRdbmsUpdater) {
        BOrdList bOrdList = RdbmsUpdateWizard.getDbOrdList(bCheckList);
        bRdbmsUpdater.setDatabaseOrds(bOrdList);
        return new BJobMonitorPane(bRdbmsUpdater, this.rdbmsNetwork);
    }

    private BWidget makeSpecifyTimezonePolicyWidget() {
        ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
        this.stationTzRb = new BRadioButton(toggleCommandGroup, STATION_TIMEZONE_STORAGE, true);
        this.historyConfigTzRb = new BRadioButton(toggleCommandGroup, HISTORY_CONFIG_TIMEZONE_STORAGE);
        BGridPane bGridPane = new BGridPane(1, new BWidget[]{this.stationTzRb, this.historyConfigTzRb});
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, BInsets.make((double)10.0));
        return bBorderPane;
    }

    private static BOrdList getDbOrdList(BCheckList bCheckList) {
        Object[] objectArray = bCheckList.getSelectedItems();
        Array array = new Array(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = RdbmsUpdateWizard.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
        for (int i = 0; i < objectArray.length; ++i) {
            DbEntry dbEntry = (DbEntry)objectArray[i];
            array.add((Object)dbEntry.dbOrd);
        }
        return BOrdList.make((BOrd[])((BOrd[])array.trim()));
    }

    private BRdbms[] getDatabases() {
        if (this.rdbmsNetwork == null) {
            return new BRdbms[0];
        }
        Array array = new Array(class$javax$baja$rdb$BRdbms == null ? (class$javax$baja$rdb$BRdbms = RdbmsUpdateWizard.class$("javax.baja.rdb.BRdbms")) : class$javax$baja$rdb$BRdbms);
        array.addAll((Object[])this.rdbmsNetwork.getDevices());
        return (BRdbms[])array.trim();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DbEntry {
        private BOrd dbOrd;
        private String displayName;

        DbEntry(String string, BOrd bOrd) {
            this.displayName = string;
            this.dbOrd = bOrd;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

