/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.util.BRdbmsUpdater;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.util.Array;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BRdbmsUpdateJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$util$BRdbmsUpdateJob == null ? (class$com$tridium$rdb$util$BRdbmsUpdateJob = BRdbmsUpdateJob.class$("com.tridium.rdb.util.BRdbmsUpdateJob")) : class$com$tridium$rdb$util$BRdbmsUpdateJob));
    protected BRdbmsUpdater updater;
    protected Context cx;
    protected BRdbms database;
    protected Connection conn;
    protected DatabaseMetaData metadata;
    protected BRdbmsDeprecatedDialect dialect;
    protected Statement statement;
    protected boolean transactionCommitted;
    static /* synthetic */ Class class$com$tridium$rdb$util$BRdbmsUpdateJob;
    static /* synthetic */ Class class$javax$baja$rdb$BRdbms;

    public Type getType() {
        return TYPE;
    }

    public BRdbmsUpdateJob() {
    }

    public BRdbmsUpdateJob(BRdbmsUpdater bRdbmsUpdater) {
        this.updater = bRdbmsUpdater;
    }

    public void run(Context context) throws Exception {
        BRdbms[] bRdbmsArray = this.resolveDatabases(context);
        for (int i = 0; i < bRdbmsArray.length; ++i) {
            BRdbms bRdbms = bRdbmsArray[i];
            if (!bRdbms.getStatus().isValid()) {
                this.log().message("Skipping update for " + bRdbms.getDisplayName(context) + ". Status is " + bRdbms.getStatus());
                continue;
            }
            this.updateStarting(bRdbms, context);
            this.log().message("Updating tables for database: " + bRdbms.getDisplayName(context));
            this.updateTables();
            this.progress((int)((double)(i + 1) * 1.0 / (double)bRdbmsArray.length * 100.0));
            this.log().success("Table updates for database: " + bRdbms.getDisplayName(context) + " complete");
            this.updateEnding();
        }
    }

    protected void updateStarting(BRdbms bRdbms, Context context) throws SQLException {
        this.database = bRdbms;
        this.cx = context;
        this.conn = bRdbms.getConnection();
        this.metadata = this.conn.getMetaData();
        this.dialect = BRdbmsDeprecatedDialect.make(bRdbms);
        this.statement = this.conn.createStatement();
        this.conn.setAutoCommit(false);
        this.transactionCommitted = false;
        this.disableDatabaseDescriptors(bRdbms);
    }

    protected void updateEnding() {
        try {
            this.log().message("Committing transaction..");
            this.conn.commit();
            this.log().message("Transaction comitted..");
            this.statement.close();
            this.conn.setAutoCommit(true);
            this.transactionCommitted = true;
        }
        catch (SQLException sQLException) {
            this.failed(sQLException);
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                this.failed(sQLException);
            }
        }
        this.enableDatabaseDescriptors(this.database);
    }

    private BRdbms[] resolveDatabases(Context context) {
        BOrdList bOrdList = this.updater.getDatabaseOrds();
        BatchResolve batchResolve = new BatchResolve(bOrdList.toArray()).resolve((BObject)this, context);
        Array array = new Array(class$javax$baja$rdb$BRdbms == null ? (class$javax$baja$rdb$BRdbms = BRdbmsUpdateJob.class$("javax.baja.rdb.BRdbms")) : class$javax$baja$rdb$BRdbms);
        array.addAll((Object[])batchResolve.getTargetObjects());
        return (BRdbms[])array.trim();
    }

    private void updateTables() {
        if (!this.database.getStatus().isValid()) {
            this.log().message("Skipping update for database: " + this.database.getDisplayName(this.cx) + ". Status is " + this.database.getStatus());
            return;
        }
        try {
            String[] stringArray = this.getTableNamesToUpdate();
            for (int i = 0; i < stringArray.length; ++i) {
                this.updateTable(stringArray[i]);
            }
        }
        catch (Exception exception) {
            this.failed(exception);
            try {
                this.log().message("Rolling back changes");
                this.conn.rollback();
            }
            catch (SQLException sQLException) {
                this.failed(sQLException);
            }
        }
    }

    protected abstract String[] getTableNamesToUpdate() throws Exception;

    protected abstract void updateTable(String var1) throws Exception;

    protected void enableDatabaseDescriptors(BRdbms bRdbms) {
        this.setDescriptorsEnabledState(bRdbms, true);
    }

    protected void disableDatabaseDescriptors(BRdbms bRdbms) {
        this.setDescriptorsEnabledState(bRdbms, false);
    }

    private void setDescriptorsEnabledState(BRdbms bRdbms, boolean bl) {
        BDeviceExt[] bDeviceExtArray = bRdbms.getDeviceExts();
        for (int i = 0; i < bDeviceExtArray.length; ++i) {
            if (!(bDeviceExtArray[i] instanceof BDescriptorDeviceExt)) continue;
            BDescriptorDeviceExt bDescriptorDeviceExt = (BDescriptorDeviceExt)bDeviceExtArray[i];
            BDescriptor[] bDescriptorArray = bDescriptorDeviceExt.getDescriptors();
            for (int j = 0; j < bDescriptorArray.length; ++j) {
                bDescriptorArray[j].setEnabled(bl);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

