/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.rdb.util.BRdbmsUpdater;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.job.JobEvent;
import com.tridium.workbench.job.JobListener;
import com.tridium.workbench.job.JobMonitor;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbmsNetwork;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;

public class BJobMonitorPane
extends BEdgePane
implements JobListener {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$util$BJobMonitorPane == null ? (class$com$tridium$rdb$util$BJobMonitorPane = BJobMonitorPane.class$("com.tridium.rdb.util.BJobMonitorPane")) : class$com$tridium$rdb$util$BJobMonitorPane));
    private BRdbmsUpdater updater;
    private BRdbmsNetwork network;
    private BOrd jobOrd;
    static BImage image = BImage.make((String)"module://icons/x16/close.png");
    static BBorder headerBorder = BBorder.make((String)"bottom(solid 1 black)");
    static BInsets headerInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
    static BBorder border = BBorder.make((String)"bottom(solid 1 #ccc)");
    static BInsets insets = BInsets.make((double)2.0, (double)5.0, (double)2.0, (double)5.0);
    BGridPane list = new BGridPane(1);
    HashMap barByJob = new HashMap();
    BJobService filterService;
    static /* synthetic */ Class class$com$tridium$rdb$util$BJobMonitorPane;

    public Type getType() {
        return TYPE;
    }

    public BJobMonitorPane(BRdbmsUpdater bRdbmsUpdater, BRdbmsNetwork bRdbmsNetwork) {
        this.updater = bRdbmsUpdater;
        this.network = bRdbmsNetwork;
        this.list.setRowGap(0.0);
        this.list.setStretchColumn(0);
        this.list.setColumnAlign(BHalign.fill);
        this.list.setValign(BValign.top);
        this.setCenter((BWidget)new BScrollPane((BWidget)this.list));
    }

    public void started() throws Exception {
        this.network.add("updater", (BValue)this.updater);
        this.updater = (BRdbmsUpdater)this.network.get("updater");
        this.jobOrd = this.updater.submitUpdateJob();
        this.network.remove((BComplex)this.updater);
        super.started();
        JobMonitor.get().addListener((JobListener)this);
        this.reload();
    }

    public void stopped() throws Exception {
        super.stopped();
        JobMonitor.get().removeListener((JobListener)this);
    }

    public void jobEvent(JobEvent jobEvent) {
        if (jobEvent.getId() == 5) {
            BJobBar bJobBar = (BJobBar)this.barByJob.get(jobEvent.getJob());
            if (bJobBar != null) {
                bJobBar.handleComponentEvent(jobEvent.getComponentEvent());
            }
        } else {
            this.reload();
        }
    }

    public void reload() {
        this.list.removeAll();
        this.barByJob.clear();
        BJobService[] bJobServiceArray = JobMonitor.get().list();
        int n = 0;
        for (int i = 0; i < bJobServiceArray.length; ++i) {
            String string;
            BFoxSession bFoxSession;
            BHost bHost;
            BJobService bJobService = bJobServiceArray[i];
            BJob[] bJobArray = bJobServiceArray[i].getJobs();
            if (bJobArray.length == 0 || this.filterService != null && this.filterService != bJobService) continue;
            try {
                bHost = bJobService.getHost();
                bFoxSession = (BFoxSession)bJobService.getSession();
                string = bFoxSession.getStationName() + " on " + bHost.getNavDisplayName(null);
            }
            catch (Exception exception) {
                string = bJobService.getNavOrd().toString();
            }
            bHost = new BLabel(string);
            bHost.setFont(Theme.widget().getBoldText());
            bFoxSession = new BButton((Command)new CloseAll((BWidget)this, bJobService));
            bFoxSession.setButtonStyle(BButtonStyle.toolBar);
            BEdgePane bEdgePane = new BEdgePane();
            bEdgePane.setLeft((BWidget)bHost);
            bEdgePane.setRight((BWidget)bFoxSession);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, headerBorder, headerInsets);
            bBorderPane.setFill(Theme.widget().getControlBackground());
            this.list.add("label" + i, (BValue)bBorderPane);
            for (int j = 0; j < bJobArray.length; ++j) {
                BJob bJob = bJobArray[j];
                if (!bJob.getSlotPathOrd().equals((Object)this.jobOrd)) continue;
                BJobBar bJobBar = BJobBar.makeFor((BJob)bJob);
                bJobBar.load(bJob);
                this.barByJob.put(bJob, bJobBar);
                this.list.add("bar" + n, (BValue)new BBorderPane((BWidget)bJobBar, border, insets));
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CloseAll
    extends Command {
        BJobService service;

        public CloseAll(BWidget bWidget, BJobService bJobService) {
            super(bWidget, "");
            this.service = bJobService;
        }

        public BImage getIcon() {
            return image;
        }

        public CommandArtifact doInvoke() {
            BJob[] bJobArray = this.service.getJobs();
            for (int i = 0; i < bJobArray.length; ++i) {
                if (bJobArray[i].getJobState().isRunning()) continue;
                bJobArray[i].dispose();
            }
            return null;
        }
    }
}

