/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.ui;

import com.tridium.rdb.BRdbmsDiscoveredTable;
import com.tridium.rdb.BRdbmsOptionalColumnSelection;
import com.tridium.workbench.job.BJobBar;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.ImportModel;
import javax.baja.gx.BImage;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryId;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsColumnSelection;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryImport;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderState;

public class BRdbmsHistoryImportManager
extends BHistoryImportManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$ui$BRdbmsHistoryImportManager == null ? (class$com$tridium$rdb$ui$BRdbmsHistoryImportManager = BRdbmsHistoryImportManager.class$("com.tridium.rdb.ui.BRdbmsHistoryImportManager")) : class$com$tridium$rdb$ui$BRdbmsHistoryImportManager));
    static final Lexicon lex = Lexicon.make((String)"driver");
    private BRdbmsHistoryDeviceExt deviceExt;
    MgrColumn tableNameCol = new MgrColumn.Prop(BRdbmsHistoryImport.rdbTableName, 1);
    MgrColumn tableCatalogCol = new MgrColumn.Prop(BRdbmsHistoryImport.rdbCatalogName, 1);
    MgrColumn tableSchemaCol = new MgrColumn.Prop(BRdbmsHistoryImport.rdbSchemaName, 1);
    MgrColumn timestampCol = new RdbmsImportProp(BRdbmsHistoryImport.timestampColumn, 3);
    MgrColumn valueCol = new RdbmsImportProp(BRdbmsHistoryImport.valueColumn, 3);
    MgrColumn statusCol = new RdbmsImportProp(BRdbmsHistoryImport.statusColumn, 3);
    MgrColumn predicateCol = new MgrColumn.Prop(BRdbmsHistoryImport.queryPredicate, 3);
    MgrColumn fullImportCol = new MgrColumn.Prop(BRdbmsHistoryImport.fullImportOnExecute, 3);
    MgrColumn[] mcols = new MgrColumn[]{this.tableNameCol, this.tableCatalogCol, this.tableSchemaCol, this.timestampCol, this.valueCol, this.statusCol, this.predicateCol, this.fullImportCol};
    static BImage logIcon = BImage.make((BIcon)BIcon.std((String)"widgets/table.png"));
    MgrColumn dTableName = new MgrColumn.Prop(BRdbmsDiscoveredTable.tableName, 0);
    MgrColumn dCatalogName = new MgrColumn.Prop(BRdbmsDiscoveredTable.catalogName, 0);
    MgrColumn dSchemaName = new MgrColumn.Prop(BRdbmsDiscoveredTable.schemaName, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dTableName, this.dCatalogName, this.dSchemaName};
    static /* synthetic */ Class class$com$tridium$rdb$ui$BRdbmsHistoryImportManager;
    static /* synthetic */ Class class$com$tridium$rdb$BRdbmsDiscoveredTable;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        super.doLoadValue(bObject, context);
    }

    protected ImportModel makeImportModel() {
        return new RdbmsImportModel(this);
    }

    protected MgrLearn makeLearn() {
        return new RdbmsImportLearn(this);
    }

    public MgrController makeController() {
        return new RdbmsImportController(this);
    }

    protected MgrState makeState() {
        return new RdbmsImportState();
    }

    private BRdbmsHistoryDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        this.deviceExt = (BRdbmsHistoryDeviceExt)((BIArchiveFolder)this.getCurrentValue()).getDeviceExt();
        return this.deviceExt;
    }

    private BRdbms getDevice() {
        BRdbmsHistoryDeviceExt bRdbmsHistoryDeviceExt = this.getDeviceExt();
        if (bRdbmsHistoryDeviceExt == null) {
            return null;
        }
        return (BRdbms)bRdbmsHistoryDeviceExt.getDevice();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TimeZoneConfigColumn
    extends ImportModel.ConfigColumn {
        public TimeZoneConfigColumn(String string, String string2, int n, BValue bValue) {
            super(string, string2, n, bValue);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BValue bValue = mgrEditRowArray[0].getCell(n);
            BFacets bFacets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE"));
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, (Context)bFacets);
            if (bWbEditor != null && bWbEditor.getClass() == bWbFieldEditor.getClass()) {
                bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            }
            bWbFieldEditor.loadValue((BObject)bValue, (Context)bFacets);
            return bWbFieldEditor;
        }
    }

    private static class RdbmsImportProp
    extends MgrColumn.Prop {
        Property prop;

        public RdbmsImportProp(Property property, int n) {
            super(property, n);
            this.prop = property;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            BValue bValue2 = bComponent.get(this.prop);
            bComponent.set(this.prop, bValue.newCopy(), context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            if (mgrEditRowArray != null && mgrEditRowArray.length > 1) {
                BValue bValue = mgrEditRowArray[0].getCell(n);
                for (int i = 0; i < mgrEditRowArray.length; ++i) {
                    if (bValue.equivalent((Object)mgrEditRowArray[i].getCell(n))) continue;
                    return null;
                }
            }
            return super.toEditor(mgrEditRowArray, n, bWbEditor);
        }
    }

    private class RdbmsImportState
    extends FolderState {
        Object[] lastLearn;
        BRdbms lastDevice;

        private RdbmsImportState() {
        }

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BRdbmsHistoryImportManager bRdbmsHistoryImportManager = (BRdbmsHistoryImportManager)bAbstractManager;
            RdbmsImportLearn rdbmsImportLearn = (RdbmsImportLearn)bRdbmsHistoryImportManager.getLearn();
            this.lastLearn = rdbmsImportLearn.lastLearn;
            this.lastDevice = bRdbmsHistoryImportManager.getDevice();
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BRdbmsHistoryImportManager bRdbmsHistoryImportManager = (BRdbmsHistoryImportManager)bAbstractManager;
            RdbmsImportLearn rdbmsImportLearn = (RdbmsImportLearn)bRdbmsHistoryImportManager.getLearn();
            if (this.lastLearn != null && this.lastDevice != null && this.lastDevice.equals((Object)bRdbmsHistoryImportManager.getDevice())) {
                rdbmsImportLearn.updateRoots(this.lastLearn);
            }
        }
    }

    private class RdbmsImportController
    extends ArchiveManagerController {
        public RdbmsImportController(BHistoryImportManager bHistoryImportManager) {
            super((BArchiveManager)bHistoryImportManager);
            this.cancel.setFlags(7);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            BOrd bOrd = BRdbmsHistoryImportManager.this.getDeviceExt().submitRdbTableDiscoveryJob();
            if (bOrd != null && !bOrd.equals((Object)BOrd.DEFAULT)) {
                BRdbmsHistoryImportManager.this.getLearn().setJob(bOrd);
            }
            return null;
        }
    }

    private class RdbmsImportLearn
    extends MgrLearn {
        BRdbmsDiscoveredTable[] lastLearn;

        public RdbmsImportLearn(BHistoryImportManager bHistoryImportManager) {
            super((BAbstractManager)bHistoryImportManager);
        }

        public BWidget makeJobBar() {
            return new BJobBar();
        }

        protected MgrColumn[] makeColumns() {
            return BRdbmsHistoryImportManager.this.dcols;
        }

        public BImage getIcon(Object object) {
            return logIcon;
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            return bComponent instanceof BRdbmsHistoryImport && ((BRdbmsHistoryImport)bComponent).getRdbTableName().equals(((BRdbmsDiscoveredTable)((Object)object)).getTableName()) && ((BRdbmsHistoryImport)bComponent).getRdbCatalogName().equals(((BRdbmsDiscoveredTable)((Object)object)).getCatalogName()) && ((BRdbmsHistoryImport)bComponent).getRdbSchemaName().equals(((BRdbmsDiscoveredTable)((Object)object)).getSchemaName());
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            return bComponent instanceof BRdbmsHistoryImport;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            return MgrTypeInfo.makeArray((Type)BRdbmsHistoryImport.TYPE);
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            String string = SlotPath.escape((String)((BRdbmsDiscoveredTable)((Object)object)).getTableName());
            mgrEditRow.setDefaultName(string);
            mgrEditRow.setCell(BRdbmsHistoryImportManager.this.tableNameCol, (BValue)BString.make((String)((BRdbmsDiscoveredTable)((Object)object)).getTableName()));
            mgrEditRow.setCell(BRdbmsHistoryImportManager.this.tableCatalogCol, (BValue)BString.make((String)((BRdbmsDiscoveredTable)((Object)object)).getCatalogName()));
            mgrEditRow.setCell(BRdbmsHistoryImportManager.this.tableSchemaCol, (BValue)BString.make((String)((BRdbmsDiscoveredTable)((Object)object)).getSchemaName()));
            BRdbmsColumnSelection bRdbmsColumnSelection = new BRdbmsColumnSelection();
            bRdbmsColumnSelection.setColumn(((BRdbmsDiscoveredTable)((Object)object)).getTimestampColumn());
            mgrEditRow.setCell(BRdbmsHistoryImportManager.this.timestampCol, (BValue)bRdbmsColumnSelection);
            BRdbmsColumnSelection bRdbmsColumnSelection2 = new BRdbmsColumnSelection();
            bRdbmsColumnSelection2.setColumn(((BRdbmsDiscoveredTable)((Object)object)).getValueColumn());
            mgrEditRow.setCell(BRdbmsHistoryImportManager.this.valueCol, (BValue)bRdbmsColumnSelection2);
            BRdbmsOptionalColumnSelection bRdbmsOptionalColumnSelection = new BRdbmsOptionalColumnSelection();
            bRdbmsOptionalColumnSelection.setUnspecified(true);
            bRdbmsOptionalColumnSelection.setColumn(((BRdbmsDiscoveredTable)((Object)object)).getStatusColumn());
            mgrEditRow.setCell(BRdbmsHistoryImportManager.this.statusCol, (BValue)bRdbmsOptionalColumnSelection);
            mgrEditRow.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)BHistoryId.make((String)BRdbmsHistoryImportManager.this.getDevice().getName(), (String)string));
        }

        public void jobComplete(BJob bJob) {
            super.jobComplete(bJob);
            this.updateDiscoveryRows((BComponent)bJob);
        }

        private void updateDiscoveryRows(BComponent bComponent) {
            BRdbmsDiscoveredTable[] bRdbmsDiscoveredTableArray = (BRdbmsDiscoveredTable[])bComponent.getChildren(class$com$tridium$rdb$BRdbmsDiscoveredTable == null ? (class$com$tridium$rdb$BRdbmsDiscoveredTable = BRdbmsHistoryImportManager.class$("com.tridium.rdb.BRdbmsDiscoveredTable")) : class$com$tridium$rdb$BRdbmsDiscoveredTable);
            this.lastLearn = bRdbmsDiscoveredTableArray;
            this.updateRoots((Object[])bRdbmsDiscoveredTableArray);
        }
    }

    private class RdbmsImportModel
    extends ImportModel {
        public RdbmsImportModel(BHistoryImportManager bHistoryImportManager) {
            super(bHistoryImportManager);
        }

        public Type[] getIncludeTypes() {
            BObject bObject = this.getManager().getCurrentValue();
            if (bObject instanceof BIArchiveFolder) {
                BIArchiveFolder bIArchiveFolder = (BIArchiveFolder)bObject;
                Type type = bIArchiveFolder.getArchiveFolderType();
                return new Type[]{BRdbmsHistoryImport.TYPE, type};
            }
            return new Type[]{BRdbmsHistoryImport.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BRdbmsHistoryImport.TYPE);
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BRdbmsHistoryImport bRdbmsHistoryImport = (BRdbmsHistoryImport)super.newInstance(mgrTypeInfo);
            BComponent bComponent = bRdbmsHistoryImport.getConfigOverrides();
            bComponent.add("interval", (BValue)BCollectionInterval.IRREGULAR, 0);
            bComponent.add("valueFacets", (BValue)BFacets.make((String)"units", (BIDataValue)BUnit.NULL), 0);
            BTimeZone bTimeZone = BTimeZone.getLocal();
            bComponent.add("timeZone", (BValue)bTimeZone, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
            return bRdbmsHistoryImport;
        }

        protected MgrColumn[] makeColumns() {
            int n;
            MgrColumn[] mgrColumnArray = super.makeColumns();
            int n2 = mgrColumnArray.length + BRdbmsHistoryImportManager.this.mcols.length + 3;
            MgrColumn[] mgrColumnArray2 = new MgrColumn[n2];
            int n3 = 0;
            for (n = 0; n < mgrColumnArray.length; ++n) {
                mgrColumnArray2[n3] = mgrColumnArray[n];
                ++n3;
            }
            mgrColumnArray2[n3] = new ImportModel.ConfigColumn("interval", lex.getText("HistoryConfig.interval"), 3, (BValue)BCollectionInterval.IRREGULAR);
            mgrColumnArray2[++n3] = new ImportModel.ConfigColumn("valueFacets", lex.getText("HistoryConfig.valueFacets"), 3, (BValue)BFacets.DEFAULT);
            mgrColumnArray2[++n3] = new TimeZoneConfigColumn("timeZone", lex.getText("HistoryConfig.timeZone"), 3, (BValue)BTimeZone.DEFAULT);
            ++n3;
            for (n = 0; n < BRdbmsHistoryImportManager.this.mcols.length; ++n) {
                mgrColumnArray2[n3] = BRdbmsHistoryImportManager.this.mcols[n];
                ++n3;
            }
            return mgrColumnArray2;
        }
    }
}

