/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStringTranslator
extends BColumnTranslator {
    private static final String CLOB = "clob";
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$jdbc$trans$BStringTranslator == null ? (class$com$tridium$rdb$jdbc$trans$BStringTranslator = BStringTranslator.class$("com.tridium.rdb.jdbc.trans.BStringTranslator")) : class$com$tridium$rdb$jdbc$trans$BStringTranslator));
    static /* synthetic */ Class class$com$tridium$rdb$jdbc$trans$BStringTranslator;

    public BStringTranslator(RdbmsDialect rdbmsDialect, BValue bValue) {
        super(rdbmsDialect, bValue);
    }

    public BSqlType getSqlType() {
        return BSqlType.sqlVarchar;
    }

    public void setPreparedStatementValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, BValue bValue, Context context) {
        String string = ((BString)bValue).getString();
        if (context != null && context.getFacets().getb(CLOB, false)) {
            if (this.getDialect().usesDefaultClobTranslator()) {
                rdbmsPreparedStatement.setCharacterStream(n, new StringReader(string), string.length());
            } else {
                this.getDialect().setClobValue(rdbmsPreparedStatement, n, string);
            }
        } else {
            rdbmsPreparedStatement.setString(n, string);
        }
    }

    public BValue getResultSetValue(RdbmsResultSet rdbmsResultSet, int n, Context context) {
        if (context != null && context.getFacets().getb(CLOB, false)) {
            try {
                int n2;
                Reader reader = rdbmsResultSet.getCharacterStream(n);
                if (reader == null) {
                    return BString.DEFAULT;
                }
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[1024];
                while ((n2 = reader.read(cArray, 0, 1024)) >= 0) {
                    stringBuffer.append(cArray, 0, n2);
                }
                return BString.make((String)stringBuffer.toString());
            }
            catch (IOException iOException) {
                throw new BajaRuntimeException((Throwable)iOException);
            }
        }
        String string = rdbmsResultSet.getString(n);
        if (string == null) {
            string = "";
        }
        return BString.make((String)string);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

