/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.trans;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAbsTimeTranslator
extends BColumnTranslator {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator == null ? (class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator = BAbsTimeTranslator.class$("com.tridium.rdb.jdbc.trans.BAbsTimeTranslator")) : class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator));
    private static Calendar utcCalendar;
    static /* synthetic */ Class class$com$tridium$rdb$jdbc$trans$BAbsTimeTranslator;

    public BAbsTimeTranslator(RdbmsDialect rdbmsDialect, BValue bValue) {
        super(rdbmsDialect, bValue);
    }

    public BSqlType getSqlType() {
        return BSqlType.sqlTimestamp;
    }

    public void setPreparedStatementValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, BValue bValue, Context context) {
        long l = ((BAbsTime)bValue).getMillis();
        if (this.getDialect().supportsMillisecondTimestamp()) {
            if (this.getDialect().useUtcTimestamps()) {
                rdbmsPreparedStatement.setTimestamp(n, new Timestamp(l), BAbsTimeTranslator.getUtcCalendar());
            } else {
                rdbmsPreparedStatement.setTimestamp(n, new Timestamp(l));
            }
        } else {
            rdbmsPreparedStatement.setLong(n, l);
        }
    }

    public static Calendar getUtcCalendar() {
        if (utcCalendar == null) {
            utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        return utcCalendar;
    }

    public BValue getResultSetValue(RdbmsResultSet rdbmsResultSet, int n, Context context) {
        if (this.getDialect().supportsMillisecondTimestamp()) {
            if (this.getDialect().useUtcTimestamps()) {
                return BAbsTime.make((long)rdbmsResultSet.getTimestamp(n, BAbsTimeTranslator.getUtcCalendar()).getTime());
            }
            return BAbsTime.make((long)rdbmsResultSet.getTimestamp(n).getTime());
        }
        return BAbsTime.make((long)rdbmsResultSet.getLong(n));
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

