/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.orm;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.orm.OrmColumn;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.security.BPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.BTypeSpec;

public class OrmSession {
    private static Log LOG = Log.getLog((String)"rdb.jdbc");
    private final BRdbms rdbms;
    private final RdbmsDialect dialect;
    private final boolean defaultUser;
    private final String userName;
    private final BPassword password;
    private Connection conn;
    static /* synthetic */ Class class$java$lang$String;

    public OrmSession(BRdbms bRdbms) {
        this.rdbms = bRdbms;
        this.dialect = (RdbmsDialect)bRdbms.getRdbmsContext();
        this.defaultUser = true;
        this.userName = null;
        this.password = null;
    }

    public OrmSession(BRdbms bRdbms, String string, BPassword bPassword) {
        this.rdbms = bRdbms;
        this.dialect = (RdbmsDialect)bRdbms.getRdbmsContext();
        this.defaultUser = false;
        this.userName = string;
        this.password = bPassword;
    }

    public void open() {
        try {
            this.conn = this.defaultUser ? this.rdbms.getConnection() : this.rdbms.getConnection(this.userName, this.password);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void close() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setAutoCommit(boolean bl) {
        try {
            this.conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public boolean tableExists(String string) {
        try {
            BTypeSpec bTypeSpec;
            if (LOG.isTraceOn()) {
                LOG.trace("tableExists: " + string);
            }
            if ((bTypeSpec = this.rdbms.getType().getTypeSpec()).equals((Object)BTypeSpec.make((String)"rdbHsqlDb:HsqlDatabase")) || bTypeSpec.equals((Object)BTypeSpec.make((String)"rdbOracle:OracleDatabase")) || bTypeSpec.equals((Object)BTypeSpec.make((String)"rdbDb2:Db2Database"))) {
                string = string.toUpperCase();
            }
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, string, null);
            boolean bl = resultSet.next();
            resultSet.close();
            return bl;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public static String makeExistsSql(String string, OrmColumn[] ormColumnArray) {
        return "SELECT * FROM " + string + " WHERE " + OrmSession.paramNames(ormColumnArray);
    }

    public static String makeReadSql(String string, OrmColumn[] ormColumnArray, OrmColumn[] ormColumnArray2) {
        return "SELECT " + OrmSession.commaNames(ormColumnArray2) + " FROM " + string + " WHERE " + OrmSession.paramNames(ormColumnArray);
    }

    public static String makeScanSql(String string, OrmColumn[] ormColumnArray) {
        return "SELECT " + OrmSession.commaNames(ormColumnArray) + " FROM " + string;
    }

    public static String makeQuerySql(String string, OrmColumn[] ormColumnArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(OrmSession.commaNames(ormColumnArray));
        stringBuffer.append(" FROM ");
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(" ").append(string2);
        }
        return stringBuffer.toString();
    }

    public static String makeInsertSql(String string, OrmColumn[] ormColumnArray) {
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = OrmSession.class$("java.lang.String")) : class$java$lang$String);
        for (int i = 0; i < ormColumnArray.length; ++i) {
            array.add((Object)"?");
        }
        return "INSERT INTO " + string + " " + "(" + OrmSession.commaNames(ormColumnArray) + ") " + "VALUES " + "(" + TextUtil.join((String[])((String[])array.trim()), (char)',') + ")";
    }

    public static String makeUpdateSql(String string, OrmColumn[] ormColumnArray, OrmColumn[] ormColumnArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(string).append(" SET ");
        for (int i = 0; i < ormColumnArray2.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ormColumnArray2[i].getName()).append(" = ?");
        }
        stringBuffer.append(" WHERE ").append(OrmSession.paramNames(ormColumnArray));
        return stringBuffer.toString();
    }

    public static String makeDeleteSql(String string, OrmColumn[] ormColumnArray) {
        return "DELETE FROM " + string + " WHERE " + OrmSession.paramNames(ormColumnArray);
    }

    public boolean exists(String string, OrmColumn[] ormColumnArray) {
        return this.exists(new RdbmsPreparedStatement(this.conn, OrmSession.makeExistsSql(string, ormColumnArray)), ormColumnArray);
    }

    public boolean read(String string, OrmColumn[] ormColumnArray, OrmColumn[] ormColumnArray2) {
        return this.read(new RdbmsPreparedStatement(this.conn, OrmSession.makeReadSql(string, ormColumnArray, ormColumnArray2)), ormColumnArray, ormColumnArray2);
    }

    public RdbmsResultSet scan(String string, OrmColumn[] ormColumnArray) {
        return this.scan(new RdbmsPreparedStatement(this.conn, OrmSession.makeScanSql(string, ormColumnArray)));
    }

    public RdbmsResultSet query(String string, OrmColumn[] ormColumnArray, String string2, OrmColumn[] ormColumnArray2) {
        return this.query(new RdbmsPreparedStatement(this.conn, OrmSession.makeQuerySql(string, ormColumnArray, string2)), ormColumnArray2);
    }

    public void insert(String string, OrmColumn[] ormColumnArray) {
        this.insert(new RdbmsPreparedStatement(this.conn, OrmSession.makeInsertSql(string, ormColumnArray)), ormColumnArray);
    }

    public void insertIdentity(String string, OrmColumn ormColumn, OrmColumn[] ormColumnArray) {
        this.insertIdentity(this.makeInsertIdentityStatement(string, ormColumn, ormColumnArray), ormColumn, ormColumnArray);
    }

    public RdbmsPreparedStatement makeInsertIdentityStatement(String string, OrmColumn ormColumn, OrmColumn[] ormColumnArray) {
        switch (this.dialect.getInsertionMode()) {
            case 1: {
                return new RdbmsPreparedStatement(this.conn, OrmSession.makeInsertSql(string, ormColumnArray), 1);
            }
        }
        throw new IllegalStateException();
    }

    public void update(String string, OrmColumn[] ormColumnArray, OrmColumn[] ormColumnArray2) {
        this.update(new RdbmsPreparedStatement(this.conn, OrmSession.makeUpdateSql(string, ormColumnArray, ormColumnArray2)), ormColumnArray, ormColumnArray2);
    }

    public void delete(String string, OrmColumn[] ormColumnArray) {
        this.delete(new RdbmsPreparedStatement(this.conn, OrmSession.makeDeleteSql(string, ormColumnArray)), ormColumnArray);
    }

    public void invokeDdl(DdlCommand ddlCommand) {
        String string = ddlCommand.getDdl(this.dialect);
        RdbmsPreparedStatement rdbmsPreparedStatement = new RdbmsPreparedStatement(this.conn, string);
        rdbmsPreparedStatement.executeUpdate();
    }

    public boolean exists(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray) {
        try {
            for (int i = 0; i < ormColumnArray.length; ++i) {
                ormColumnArray[i].setPreparedValue(rdbmsPreparedStatement, i + 1, ormColumnArray[i].getValue(), null);
            }
            ResultSet resultSet = rdbmsPreparedStatement.executeQuery();
            return resultSet.next();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public boolean read(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray, OrmColumn[] ormColumnArray2) {
        for (int i = 0; i < ormColumnArray.length; ++i) {
            ormColumnArray[i].setPreparedValue(rdbmsPreparedStatement, i + 1, ormColumnArray[i].getValue(), null);
        }
        RdbmsResultSet rdbmsResultSet = new RdbmsResultSet(rdbmsPreparedStatement.executeQuery());
        if (rdbmsResultSet.next()) {
            for (int i = 0; i < ormColumnArray2.length; ++i) {
                OrmColumn ormColumn = ormColumnArray2[i];
                ormColumn.setValue(ormColumn.getResultValue(rdbmsResultSet, i + 1, null));
            }
            return true;
        }
        return false;
    }

    public RdbmsResultSet scan(RdbmsPreparedStatement rdbmsPreparedStatement) {
        return new RdbmsResultSet(rdbmsPreparedStatement.executeQuery());
    }

    public RdbmsResultSet query(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray) {
        if (ormColumnArray != null) {
            for (int i = 0; i < ormColumnArray.length; ++i) {
                ormColumnArray[i].setPreparedValue(rdbmsPreparedStatement, i + 1, ormColumnArray[i].getValue(), null);
            }
        }
        return new RdbmsResultSet(rdbmsPreparedStatement.executeQuery());
    }

    public void insert(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray) {
        OrmSession.loadPrepStatement(rdbmsPreparedStatement, ormColumnArray);
        rdbmsPreparedStatement.executeUpdate();
    }

    public void insertIdentity(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn ormColumn, OrmColumn[] ormColumnArray) {
        switch (this.dialect.getInsertionMode()) {
            case 1: {
                this.insertViaIdentity(rdbmsPreparedStatement, ormColumn, ormColumnArray);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void update(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray, OrmColumn[] ormColumnArray2) {
        int n;
        int n2 = 1;
        for (n = 0; n < ormColumnArray2.length; ++n) {
            OrmColumn ormColumn = ormColumnArray2[n];
            ormColumn.setPreparedValue(rdbmsPreparedStatement, n2++, ormColumn.getValue(), null);
        }
        for (n = 0; n < ormColumnArray.length; ++n) {
            ormColumnArray[n].setPreparedValue(rdbmsPreparedStatement, n2++, ormColumnArray[n].getValue(), null);
        }
        rdbmsPreparedStatement.executeUpdate();
    }

    public void delete(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray) {
        for (int i = 0; i < ormColumnArray.length; ++i) {
            ormColumnArray[i].setPreparedValue(rdbmsPreparedStatement, i + 1, ormColumnArray[i].getValue(), null);
        }
        rdbmsPreparedStatement.executeUpdate();
    }

    private void insertViaIdentity(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn ormColumn, OrmColumn[] ormColumnArray) {
        OrmSession.loadPrepStatement(rdbmsPreparedStatement, ormColumnArray);
        rdbmsPreparedStatement.executeUpdate();
        OrmSession.retrieveIdentityKey(rdbmsPreparedStatement, ormColumn);
    }

    private static void retrieveIdentityKey(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn ormColumn) {
        RdbmsResultSet rdbmsResultSet = new RdbmsResultSet(rdbmsPreparedStatement.getGeneratedKeys());
        rdbmsResultSet.next();
        ormColumn.setValue(ormColumn.getResultValue(rdbmsResultSet, 1));
    }

    private static String commaNames(OrmColumn[] ormColumnArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ormColumnArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ormColumnArray[i].getName());
        }
        return stringBuffer.toString();
    }

    private static String paramNames(OrmColumn[] ormColumnArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ormColumnArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("(").append(ormColumnArray[i].getName()).append(" = ?)");
        }
        return stringBuffer.toString();
    }

    private static void loadPrepStatement(RdbmsPreparedStatement rdbmsPreparedStatement, OrmColumn[] ormColumnArray) {
        for (int i = 0; i < ormColumnArray.length; ++i) {
            OrmColumn ormColumn = ormColumnArray[i];
            ormColumn.setPreparedValue(rdbmsPreparedStatement, i + 1, ormColumn.getValue(), null);
        }
    }

    public BRdbms getRdbms() {
        return this.rdbms;
    }

    public RdbmsDialect getDialect() {
        return this.dialect;
    }

    public Connection getConnection() {
        return this.conn;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

