/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc.orm;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.RdbmsResultSet;
import com.tridium.rdb.jdbc.orm.OrmTranslatorFactory;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class OrmColumn {
    private final String name;
    private BValue value;
    private final BColumnTranslator translator;

    public OrmColumn(RdbmsDialect rdbmsDialect, String string, BValue bValue) {
        if (rdbmsDialect == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (bValue == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.value = bValue;
        this.translator = OrmTranslatorFactory.get(rdbmsDialect, bValue);
    }

    public OrmColumn(RdbmsDialect rdbmsDialect, String string, Type type) {
        if (rdbmsDialect == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.value = null;
        this.translator = OrmTranslatorFactory.get(rdbmsDialect, (BValue)type.getInstance());
    }

    public String toString() {
        return "[OrmColumn name:" + this.name + ", " + "translator:" + this.translator.getType() + ", " + "value:" + this.value + "]";
    }

    public void setPreparedValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, BValue bValue) {
        this.translator.setPreparedStatementValue(rdbmsPreparedStatement, n, bValue, null);
    }

    public void setPreparedValue(RdbmsPreparedStatement rdbmsPreparedStatement, int n, BValue bValue, Context context) {
        this.translator.setPreparedStatementValue(rdbmsPreparedStatement, n, bValue, context);
    }

    public BValue getResultValue(RdbmsResultSet rdbmsResultSet, int n) {
        return this.translator.getResultSetValue(rdbmsResultSet, n, null);
    }

    public BValue getResultValue(RdbmsResultSet rdbmsResultSet, int n, Context context) {
        return this.translator.getResultSetValue(rdbmsResultSet, n, context);
    }

    public String getName() {
        return this.name;
    }

    public BValue getValue() {
        return this.value;
    }

    public BColumnTranslator getTranslator() {
        return this.translator;
    }

    public void setValue(BValue bValue) {
        this.value = bValue;
    }
}

