/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.baja.sys.BajaRuntimeException;

public class RdbmsResultSet {
    private static final byte[] NO_BYTES = new byte[0];
    private ResultSet rs;

    public RdbmsResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    public boolean isNull(int n) {
        try {
            return this.rs.getObject(n) == null;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public int getInt(int n) {
        try {
            return this.rs.getInt(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public long getLong(int n) {
        try {
            return this.rs.getLong(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public float getFloat(int n) {
        try {
            float f = this.rs.getFloat(n);
            return this.rs.wasNull() ? Float.NaN : f;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public double getDouble(int n) {
        try {
            double d = this.rs.getDouble(n);
            return this.rs.wasNull() ? Double.NaN : d;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public boolean getBoolean(int n) {
        try {
            return this.rs.getBoolean(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public Timestamp getTimestamp(int n) {
        try {
            return this.rs.getTimestamp(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) {
        try {
            return this.rs.getTimestamp(n, calendar);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public Date getDate(int n) {
        try {
            return this.rs.getDate(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public String getString(int n) {
        try {
            return this.rs.getString(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public byte[] getBytes(int n) {
        try {
            return this.rs.getBytes(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public InputStream getBinaryStream(int n) {
        try {
            return this.rs.getBinaryStream(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public Reader getCharacterStream(int n) {
        try {
            return this.rs.getCharacterStream(n);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }
}

