/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BajaRuntimeException;

public class RdbmsPreparedStatement {
    private static Log LOG = Log.getLog((String)"rdb.jdbc");
    private Array fieldValues = new Array(class$java$lang$String == null ? (class$java$lang$String = RdbmsPreparedStatement.class$("java.lang.String")) : class$java$lang$String);
    private final Connection conn;
    private final String sql;
    private final PreparedStatement prep;
    static /* synthetic */ Class class$java$lang$String;

    public RdbmsPreparedStatement(Connection connection, String string) {
        try {
            this.conn = connection;
            this.prep = connection.prepareStatement(string);
            this.sql = string;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public RdbmsPreparedStatement(Connection connection, String string, int n) {
        try {
            this.conn = connection;
            this.prep = connection.prepareStatement(string, n);
            this.sql = string;
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setInt(int n, int n2) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)Integer.toString(n2));
            this.prep.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setLong(int n, long l) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)Long.toString(l));
            this.prep.setLong(n, l);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setFloat(int n, float f) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)Float.toString(f));
            if (Float.isNaN(f)) {
                this.prep.setNull(n, 7);
            } else {
                this.prep.setFloat(n, f);
            }
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setDouble(int n, double d) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)Double.toString(d));
            if (Double.isNaN(d)) {
                this.prep.setNull(n, 6);
            } else {
                this.prep.setDouble(n, d);
            }
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setBoolean(int n, boolean bl) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)Boolean.toString(bl));
            this.prep.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)timestamp.toString());
            this.prep.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)timestamp.toString());
            this.prep.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setDate(int n, Date date) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)date.toString());
            this.prep.setDate(n, date);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setString(int n, String string) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)string);
            this.prep.setString(n, string);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setBytes(int n, byte[] byArray) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)"<bytes>");
            this.prep.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setNull(int n, int n2) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)"<null>");
            this.prep.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)"<BinaryStream>");
            this.prep.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) {
        try {
            RdbmsPreparedStatement.grow(this.fieldValues, n);
            this.fieldValues.set(n - 1, (Object)"<CharacterStream>");
            this.prep.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void setFieldDebugString(int n, String string) {
        this.fieldValues.set(n - 1, (Object)string);
    }

    public int executeUpdate() {
        try {
            if (LOG.isTraceOn()) {
                LOG.trace(this.sql + ": " + this.fieldValues);
            }
            return this.prep.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public ResultSet executeQuery() {
        try {
            if (LOG.isTraceOn()) {
                LOG.trace(this.sql + ": " + this.fieldValues);
            }
            return this.prep.executeQuery();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public ResultSet getGeneratedKeys() {
        try {
            return this.prep.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void addBatch() {
        try {
            this.prep.addBatch();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    public void executeBatch() {
        try {
            if (LOG.isTraceOn()) {
                LOG.trace("executeBatch: " + this.sql);
            }
            this.prep.executeBatch();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    private static void grow(Array array, int n) {
        while (array.size() < n) {
            array.add(null);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement getStatement() {
        return this.prep;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

