/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.collection.BGenericTable;
import com.tridium.rdb.RdbmsUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BAbsTimeTranslator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.util.Array;
import javax.baja.rdb.RdbmsContext;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BResultSetTable
extends BGenericTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BResultSetTable == null ? (class$com$tridium$rdb$BResultSetTable = BResultSetTable.class$("com.tridium.rdb.BResultSetTable")) : class$com$tridium$rdb$BResultSetTable));
    static /* synthetic */ Class class$com$tridium$rdb$BResultSetTable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BResultSetTable(Connection connection, String string, RdbmsContext rdbmsContext) {
        super(BResultSetTable.load(connection, string, rdbmsContext));
    }

    private static BComponent[] load(Connection connection, String string, RdbmsContext rdbmsContext) {
        try {
            ResultSet resultSet = connection.createStatement().executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            BResultSetTable.checkFieldTypes(resultSetMetaData);
            Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BResultSetTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
            while (resultSet.next()) {
                array.add((Object)BResultSetTable.makeComponent(resultSetMetaData, resultSet, rdbmsContext));
            }
            resultSet.close();
            return (BComponent[])array.trim();
        }
        catch (SQLException sQLException) {
            throw new BajaRuntimeException((Throwable)sQLException);
        }
    }

    private static void checkFieldTypes(ResultSetMetaData resultSetMetaData) throws SQLException {
        block3: for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            Object var2_2 = null;
            switch (resultSetMetaData.getColumnType(i)) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 93: {
                    continue block3;
                }
                default: {
                    System.out.println("WARNING: Column " + resultSetMetaData.getColumnName(i) + ": " + "Converting unknown SQL Type '" + resultSetMetaData.getColumnTypeName(i) + "' (" + resultSetMetaData.getColumnType(i) + ") to String.");
                }
            }
        }
    }

    private static BComponent makeComponent(ResultSetMetaData resultSetMetaData, ResultSet resultSet, RdbmsContext rdbmsContext) throws SQLException {
        BComponent bComponent = new BComponent();
        block11: for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String string = resultSetMetaData.getColumnName(i);
            if (string.equals("")) {
                string = "column" + i;
            }
            if (RdbmsUtil.isBlacklistProperty(string.toLowerCase())) continue;
            switch (resultSetMetaData.getColumnType(i)) {
                case -1: 
                case 1: 
                case 12: {
                    String string2 = resultSet.getString(i);
                    bComponent.add(string, (BValue)BString.make((String)(string2 == null ? "" : string2)));
                    continue block11;
                }
                case -7: {
                    bComponent.add(string, (BValue)BBoolean.make((boolean)resultSet.getBoolean(i)));
                    continue block11;
                }
                case 2: {
                    if (string.equals("TRENDFLAGS")) {
                        bComponent.add(string, (BValue)BTrendFlags.make((int)resultSet.getInt(i)));
                        continue block11;
                    }
                    if (string.equals("STATUS")) {
                        bComponent.add(string, (BValue)BStatus.make((int)resultSet.getInt(i)));
                        continue block11;
                    }
                    bComponent.add(string, (BValue)BDouble.make((double)resultSet.getDouble(i)));
                    continue block11;
                }
                case 3: 
                case 6: 
                case 8: {
                    bComponent.add(string, (BValue)BDouble.make((double)resultSet.getDouble(i)));
                    continue block11;
                }
                case 7: {
                    bComponent.add(string, (BValue)BFloat.make((float)resultSet.getFloat(i)));
                    continue block11;
                }
                case -5: {
                    bComponent.add(string, (BValue)BLong.make((long)resultSet.getLong(i)));
                    continue block11;
                }
                case -6: 
                case 4: 
                case 5: {
                    if (string.equals("TRENDFLAGS")) {
                        bComponent.add(string, (BValue)BTrendFlags.make((int)resultSet.getInt(i)));
                        continue block11;
                    }
                    if (string.equals("STATUS")) {
                        bComponent.add(string, (BValue)BStatus.make((int)resultSet.getInt(i)));
                        continue block11;
                    }
                    bComponent.add(string, (BValue)BInteger.make((int)resultSet.getInt(i)));
                    continue block11;
                }
                case 91: 
                case 93: {
                    Object object;
                    boolean bl = true;
                    Timestamp timestamp = null;
                    if (rdbmsContext instanceof RdbmsDialect && resultSetMetaData.getColumnType(i) == 93 && (object = (Object)((RdbmsDialect)rdbmsContext)).useUtcTimestamps()) {
                        bl = false;
                        timestamp = resultSet.getTimestamp(i, BAbsTimeTranslator.getUtcCalendar());
                    }
                    if (bl) {
                        timestamp = resultSet.getTimestamp(i);
                    }
                    bComponent.add(string, (BValue)(timestamp == null ? BAbsTime.NULL : BAbsTime.make((long)timestamp.getTime())));
                    continue block11;
                }
                case -4: 
                case -3: 
                case -2: {
                    Object object = resultSet.getBytes(i);
                    bComponent.add(string, (BValue)BBlob.make((byte[])((byte[])(object == null ? new byte[]{} : object))));
                    continue block11;
                }
                default: {
                    String string2 = resultSet.getString(i);
                    bComponent.add(string, (BValue)BString.make((String)(string2 == null ? "" : string2)));
                }
            }
        }
        return bComponent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

