/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.BRdbmsDiscoveredTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BRdbmsDiscoverTablesJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BRdbmsDiscoverTablesJob == null ? (class$com$tridium$rdb$BRdbmsDiscoverTablesJob = BRdbmsDiscoverTablesJob.class$("com.tridium.rdb.BRdbmsDiscoverTablesJob")) : class$com$tridium$rdb$BRdbmsDiscoverTablesJob));
    private static BIcon icon = BIcon.std((String)"find.png");
    private static String[] typeFilter = new String[]{"TABLE"};
    BRdbmsHistoryDeviceExt histDevExt;
    boolean discoverCanceled = false;
    static /* synthetic */ Class class$com$tridium$rdb$BRdbmsDiscoverTablesJob;

    public Type getType() {
        return TYPE;
    }

    public BRdbmsDiscoverTablesJob(BRdbmsHistoryDeviceExt bRdbmsHistoryDeviceExt) {
        this.histDevExt = bRdbmsHistoryDeviceExt;
    }

    public BRdbmsDiscoverTablesJob() {
    }

    public void doCancel(Context context) {
        this.discoverCanceled = true;
        super.doCancel(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context context) throws Exception {
        if (this.histDevExt == null) {
            throw new IllegalStateException("Must submit through RdbmsHistoryDeviceExt.submitRdbTableDiscoveryJob()");
        }
        if (this.discoverCanceled) {
            throw new JobCancelException();
        }
        this.progress(0);
        this.log().start("Rdb Table Discovery");
        this.removeAll();
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            String string;
            int n;
            BPassword bPassword;
            BRdbms bRdbms = (BRdbms)this.histDevExt.getDevice();
            String string2 = bRdbms.getUserName();
            if (string2 == null) {
                string2 = "";
            }
            if ((bPassword = bRdbms.getPassword()) == null) {
                bPassword = BPassword.DEFAULT;
            }
            connection = bRdbms.getConnection(string2, bPassword);
            this.log().message("  Finding catalogs...");
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getCatalogs();
            Vector<String> vector = new Vector<String>();
            vector.addElement("");
            while (resultSet.next()) {
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                String string3 = resultSet.getString("TABLE_CAT");
                this.log().message("    Found catalog: " + string3);
                if (string3 == null) continue;
                vector.addElement(string3);
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.progress(10);
            int n2 = vector.size();
            this.log().message("  Found " + (n2 - 1) + " total catalogs.");
            this.log().message("  Finding tables in each catalog...");
            Vector<String> vector2 = new Vector<String>();
            Vector<Object> vector3 = new Vector<Object>();
            Vector<Object> vector4 = new Vector<Object>();
            for (n = 0; n < n2; ++n) {
                this.progress((int)((float)n / (float)n2 * 20.0f) + 10);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                try {
                    resultSet = databaseMetaData.getTables((String)vector.elementAt(n), null, null, typeFilter);
                }
                catch (SQLException sQLException) {
                    this.log().failed("    Encountered problem finding tables for catalog " + vector.elementAt(n), (Throwable)sQLException);
                    if (resultSet == null) continue;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                while (resultSet.next()) {
                    if (this.discoverCanceled) {
                        throw new JobCancelException();
                    }
                    vector2.addElement(resultSet.getString("TABLE_NAME"));
                    String string4 = resultSet.getString("TABLE_CAT");
                    vector3.addElement(string4 != null ? string4 : new Object());
                    string = resultSet.getString("TABLE_SCHEM");
                    vector4.addElement(string != null ? string : new Object());
                }
                if (resultSet == null) continue;
                try {
                    resultSet.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.progress(30);
            n = vector2.size();
            this.log().message("  Found " + n + " total tables.");
            this.log().message("  Finding columns for each table...");
            for (int i = 0; i < n; ++i) {
                this.progress((int)((float)i / (float)n * 70.0f) + 30);
                if (this.discoverCanceled) {
                    throw new JobCancelException();
                }
                string = (String)vector2.elementAt(i);
                if (string == null) continue;
                BRdbmsDiscoveredTable bRdbmsDiscoveredTable = new BRdbmsDiscoveredTable(string);
                Object e = vector3.elementAt(i);
                boolean bl = e instanceof String;
                bRdbmsDiscoveredTable.setCatalogName(bl ? (String)e : "");
                Object e2 = vector4.elementAt(i);
                boolean bl2 = e2 instanceof String;
                bRdbmsDiscoveredTable.setSchemaName(bl2 ? (String)e2 : "");
                try {
                    resultSet = databaseMetaData.getColumns(bl ? (String)e : null, bl2 ? (String)e2 : null, string, null);
                }
                catch (SQLException sQLException) {
                    this.log().failed("    Encountered problem finding columns for table " + string + " (catalog=" + (bl ? (String)e : "null") + ", schema=" + (bl2 ? (String)e2 : "null") + ")", (Throwable)sQLException);
                    if (resultSet == null) continue;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Vector<String> vector5 = new Vector<String>();
                while (resultSet.next()) {
                    if (this.discoverCanceled) {
                        throw new JobCancelException();
                    }
                    vector5.addElement(resultSet.getString("COLUMN_NAME"));
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int n3 = vector5.size();
                String[] stringArray = null;
                BEnumRange bEnumRange = null;
                if (n3 > 0) {
                    stringArray = new String[n3];
                    for (int j = 0; j < n3; ++j) {
                        stringArray[j] = SlotPath.escape((String)((String)vector5.elementAt(j)));
                    }
                    bEnumRange = BEnumRange.make((String[])stringArray);
                    bRdbmsDiscoveredTable.setTimestampColumn(BDynamicEnum.make((int)0, (BEnumRange)bEnumRange));
                    bRdbmsDiscoveredTable.setValueColumn(BDynamicEnum.make((int)0, (BEnumRange)bEnumRange));
                    bRdbmsDiscoveredTable.setStatusColumn(BDynamicEnum.make((int)0, (BEnumRange)bEnumRange));
                }
                this.add("s" + i, (BValue)bRdbmsDiscoveredTable, 1);
            }
            this.progress(100);
            this.log().message("  Finished finding columns for each table.");
            this.log().success("Rdb Table Discovery complete (" + n + " tables found).");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

