/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.BIAgent;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public abstract class BRdbmsDeprecatedDialect
extends BObject
implements BIAgent {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BRdbmsDeprecatedDialect == null ? (class$com$tridium$rdb$BRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.class$("com.tridium.rdb.BRdbmsDeprecatedDialect")) : class$com$tridium$rdb$BRdbmsDeprecatedDialect));
    private static final int VARCHAR_SIZE = 500;
    public static final String WIDTH = "width";
    private BTimeZone timeZone = null;
    private Calendar historyConfigCalendar = null;
    private static final Calendar utcCalender = Calendar.getInstance(BTimeZone.UTC.getJavaTimeZone());
    private static final Calendar localCalender = Calendar.getInstance(BTimeZone.getLocal().getJavaTimeZone());
    protected BRdbms database;
    static /* synthetic */ Class class$com$tridium$rdb$BRdbmsDeprecatedDialect;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public static BRdbmsDeprecatedDialect make(Type type) {
        AgentInfo agentInfo = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)TYPE)).getDefault();
        return (BRdbmsDeprecatedDialect)agentInfo.getAgentType().getTypeSpec().getInstance();
    }

    public static BRdbmsDeprecatedDialect make(BRdbms bRdbms) {
        BRdbmsDeprecatedDialect bRdbmsDeprecatedDialect = BRdbmsDeprecatedDialect.make(bRdbms.getType());
        bRdbmsDeprecatedDialect.database = bRdbms;
        return bRdbmsDeprecatedDialect;
    }

    public abstract boolean tableExists(BRdbms var1, Connection var2, String var3) throws SQLException;

    public String getSqlType(Property property) {
        return this.getSqlType(property.getType(), property.getFacets());
    }

    public abstract String getSqlType(Type var1, BFacets var2);

    public abstract long getTimestampAccuracy();

    public abstract String getPrimaryKeySql();

    public abstract int getMaxTableName();

    public abstract int getMaxIndexName();

    public abstract int getMaxColumnName();

    public abstract int getMaxSequenceName();

    public abstract boolean hasSequences();

    public abstract boolean allowsUnicode();

    protected String makeColumnName(String string) {
        return "\"" + string + "\"";
    }

    public boolean supportsTimestamp() {
        return true;
    }

    public int getVarcharSize(BFacets bFacets) {
        if (bFacets != null && !bFacets.isNull()) {
            return bFacets.geti(WIDTH, 500);
        }
        return 500;
    }

    public String makeCreateTableSql(String string, Property[] propertyArray, String[] stringArray, Type[] typeArray, BFacets[] bFacetsArray) {
        return this.makeCreateTableSql(string, true, propertyArray, stringArray, typeArray, bFacetsArray);
    }

    public String makeCreateTableSql(String string, boolean bl, Property[] propertyArray, String[] stringArray, Type[] typeArray, BFacets[] bFacetsArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        if (bl) {
            stringBuffer.append("ID ").append(this.getPrimaryKeySql());
        }
        String[] stringArray2 = this.getTemplateColumnNames(propertyArray, stringArray);
        for (n = 0; n < propertyArray.length; ++n) {
            if (n > 0 || bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.makeColumnName(stringArray2[n]));
            stringBuffer.append(" ").append(this.getSqlType(propertyArray[n]));
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(", ").append(this.makeColumnName(stringArray[n]));
            stringBuffer.append(" ").append(this.getSqlType(typeArray[n], bFacetsArray[n]));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String makeInsertSql(String string, Property[] propertyArray, String[] stringArray) {
        return this.makeInsertSql(string, true, propertyArray, stringArray);
    }

    public String makeInsertSql(String string, boolean bl, Property[] propertyArray, String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(string);
        int n2 = 0;
        stringBuffer.append(" (");
        if (this.hasSequences() && bl) {
            stringBuffer.append("ID");
            ++n2;
        }
        String[] stringArray2 = this.getTemplateColumnNames(propertyArray, stringArray);
        for (n = 0; n < propertyArray.length; ++n) {
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.makeColumnName(stringArray2[n]));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.makeColumnName(stringArray[n]));
        }
        stringBuffer.append(")");
        n2 = 0;
        stringBuffer.append(" VALUES (");
        if (this.hasSequences() && bl) {
            stringBuffer.append(string + "_Q.NEXTVAL");
            ++n2;
        }
        for (n = 0; n < propertyArray.length; ++n) {
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("?");
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String makeUpdateSql(String string, Property[] propertyArray, String[] stringArray, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(string);
        int n2 = 0;
        stringBuffer.append(" SET ");
        String[] stringArray2 = this.getTemplateColumnNames(propertyArray, stringArray);
        for (n = 0; n < propertyArray.length; ++n) {
            if (stringArray2[n].equals(string2)) continue;
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.makeColumnName(stringArray2[n]));
            stringBuffer.append(" = ?");
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals(string2)) continue;
            if (n2++ > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.makeColumnName(stringArray[n]));
            stringBuffer.append(" = ?");
        }
        stringBuffer.append(" WHERE ");
        stringBuffer.append(string2);
        stringBuffer.append(" = ?");
        return stringBuffer.toString();
    }

    public String makeAddColumnSql(String string, String string2, BSqlType bSqlType, int n, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLE ").append(string).append(" ");
        stringBuffer.append("ADD ").append(string2).append(" ").append(this.getDataType(bSqlType));
        if (n > -1) {
            stringBuffer.append("(" + n + ") ");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append("NOT NULL DEFAULT ");
        if (bSqlType.equals((Object)BSqlType.sqlVarchar) || bSqlType.equals((Object)BSqlType.sqlNVarchar)) {
            string3 = "'" + string3 + "'";
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public abstract String makeAlterColumnTypeSql(String var1, String var2, BSqlType var3, int var4);

    public abstract String makeDropIndexSql(String var1, String var2);

    public String getDataType(BSqlType bSqlType) {
        switch (bSqlType.getOrdinal()) {
            case 0: {
                return this.getSqlType(BInteger.TYPE, null);
            }
            case 1: {
                return this.getSqlType(BLong.TYPE, null);
            }
            case 2: {
                return this.getSqlType(BFloat.TYPE, null);
            }
            case 3: {
                return this.getSqlType(BDouble.TYPE, null);
            }
            case 5: {
                return this.getSqlType(BAbsTime.TYPE, null);
            }
        }
        String string = this.getSqlType(BString.TYPE, null);
        return string.substring(0, string.indexOf("("));
    }

    public void loadField(PreparedStatement preparedStatement, int n, BObject bObject, BFacets bFacets) throws SQLException {
        Type type = bObject.getType();
        if (bObject instanceof BString) {
            preparedStatement.setString(n, TextUtil.truncate((String)((BString)bObject).getString(), (int)this.getVarcharSize(bFacets)));
        } else if (bObject instanceof BInteger) {
            preparedStatement.setInt(n, ((BInteger)bObject).getInt());
        } else if (bObject instanceof BLong) {
            preparedStatement.setLong(n, ((BLong)bObject).getLong());
        } else if (bObject instanceof BFloat) {
            float f = ((BFloat)bObject).getFloat();
            if (Float.isNaN(f)) {
                preparedStatement.setNull(n, 7);
            } else {
                preparedStatement.setFloat(n, f);
            }
        } else if (bObject instanceof BDouble) {
            double d = ((BDouble)bObject).getDouble();
            if (Double.isNaN(d)) {
                preparedStatement.setNull(n, 6);
            } else {
                preparedStatement.setDouble(n, d);
            }
        } else if (bObject instanceof BAbsTime) {
            if (this.supportsTimestamp()) {
                Timestamp timestamp = new Timestamp(((BAbsTime)bObject).getMillis());
                RdbmsDialect rdbmsDialect = (RdbmsDialect)this.database.getRdbmsContext();
                Calendar calendar = rdbmsDialect.useUtcTimestamps() ? utcCalender : (this.timeZone != null ? this.historyConfigCalendar : localCalender);
                preparedStatement.setTimestamp(n, timestamp, calendar);
            } else {
                BAbsTime bAbsTime = (BAbsTime)bObject;
                long l = bAbsTime.getMillis();
                preparedStatement.setLong(n, l);
            }
        } else if (bObject instanceof BRelTime) {
            preparedStatement.setLong(n, ((BRelTime)bObject).getMillis());
        } else if (bObject instanceof BBoolean) {
            preparedStatement.setBoolean(n, ((BBoolean)bObject).getBoolean());
        } else if (bObject instanceof BStatus) {
            preparedStatement.setInt(n, ((BStatus)bObject).getBits());
        } else if (bObject instanceof BTrendFlags) {
            preparedStatement.setInt(n, ((BTrendFlags)bObject).getBits());
        } else if (bObject instanceof BTimeZone) {
            preparedStatement.setString(n, TextUtil.truncate((String)bObject.toString(), (int)this.getVarcharSize(bFacets)));
        } else if (bObject instanceof BSimple) {
            try {
                preparedStatement.setString(n, ((BSimple)bObject).encodeToString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            preparedStatement.setString(n, TextUtil.truncate((String)bObject.toString(), (int)this.getVarcharSize(bFacets)));
        }
    }

    public void insertRecord(PreparedStatement preparedStatement, BComplex bComplex, Property[] propertyArray, BObject[] bObjectArray, BFacets[] bFacetsArray) throws SQLException {
        int n;
        int n2 = 1;
        if (bComplex != null) {
            for (n = 0; n < propertyArray.length; ++n) {
                this.loadField(preparedStatement, n2++, (BObject)bComplex.get(propertyArray[n]), propertyArray[n].getFacets());
            }
        }
        for (n = 0; n < bObjectArray.length; ++n) {
            this.loadField(preparedStatement, n2++, bObjectArray[n], bFacetsArray[n]);
        }
        preparedStatement.addBatch();
    }

    public void updateRecord(PreparedStatement preparedStatement, BComplex bComplex, Property[] propertyArray, BObject[] bObjectArray, BFacets[] bFacetsArray, String string, BObject bObject) throws SQLException {
        int n;
        int n2 = 1;
        String[] stringArray = this.getTemplateColumnNames(propertyArray, new String[0]);
        for (n = 0; n < propertyArray.length; ++n) {
            if (stringArray[n].equals(string)) continue;
            this.loadField(preparedStatement, n2++, (BObject)bComplex.get(propertyArray[n]), propertyArray[n].getFacets());
        }
        for (n = 0; n < bObjectArray.length; ++n) {
            this.loadField(preparedStatement, n2++, bObjectArray[n], bFacetsArray[n]);
        }
        this.loadField(preparedStatement, n2++, bObject, BFacets.NULL);
        preparedStatement.addBatch();
    }

    public String[] getTemplateColumnNames(Property[] propertyArray, String[] stringArray) {
        int n = this.getMaxColumnName();
        Array array = new Array(class$java$lang$String == null ? (class$java$lang$String = BRdbmsDeprecatedDialect.class$("java.lang.String")) : class$java$lang$String, propertyArray.length);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(new Array((Object[])stringArray).list());
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = this.mangleIdentifier(propertyArray[i].getName());
            String string2 = TextUtil.truncate((String)string, (int)n);
            if (hashSet.contains(string2)) {
                String string3;
                int n2 = 1;
                while (hashSet.contains(string2 = TextUtil.truncate((String)string, (int)(n - (string3 = Integer.toString(n2++)).length())) + string3)) {
                }
            }
            hashSet.add(string2);
            array.add((Object)string2);
        }
        return (String[])array.trim();
    }

    public String mangleIdentifier(String string) {
        if ((string = string.toUpperCase()).equals("ID")) {
            return "ID_";
        }
        if (string.equals("SCHEMA")) {
            return "SCHEMA_";
        }
        if (string.equals("INTERVAL")) {
            return "INTERVAL_";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        if (this.allowsUnicode() && Character.isLetter(c) || BRdbmsDeprecatedDialect.isAsciiLetter(c) || c == '_') {
            stringBuffer.append(c);
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if ((!this.allowsUnicode() || !Character.isLetterOrDigit(c)) && !BRdbmsDeprecatedDialect.isAsciiLetterOrDigit(c) && c != '_') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static boolean isAsciiLetter(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isAsciiLetterOrDigit(char c) {
        return 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    public void setTimeZone(BTimeZone bTimeZone) {
        this.timeZone = bTimeZone;
        this.historyConfigCalendar = new GregorianCalendar(bTimeZone.getJavaTimeZone());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

