/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractConnectionPool
extends BComponent {
    public static final Property maxActive = BAbstractConnectionPool.newProperty((int)0, (int)30, null);
    public static final Property maxIdle = BAbstractConnectionPool.newProperty((int)0, (int)10, null);
    public static final Property maxWait = BAbstractConnectionPool.newProperty((int)0, (int)5000, null);
    public static final Property loginTimeout = BAbstractConnectionPool.newProperty((int)0, (int)0, null);
    public static final Property updatePeriod = BAbstractConnectionPool.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Property numActive = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    public static final Property peakNumActive = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    public static final Property numIdle = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    public static final Action updateConnectionStats = BAbstractConnectionPool.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$rdb$BAbstractConnectionPool == null ? (class$com$tridium$rdb$BAbstractConnectionPool = BAbstractConnectionPool.class$("com.tridium.rdb.BAbstractConnectionPool")) : class$com$tridium$rdb$BAbstractConnectionPool));
    private static final Log LOG = Log.getLog((String)"rdb");
    private Clock.Ticket updateTicket;
    private Object lock = new Object();
    static /* synthetic */ Class class$com$tridium$rdb$BAbstractConnectionPool;

    public int getMaxActive() {
        return this.getInt(maxActive);
    }

    public void setMaxActive(int n) {
        this.setInt(maxActive, n, null);
    }

    public int getMaxIdle() {
        return this.getInt(maxIdle);
    }

    public void setMaxIdle(int n) {
        this.setInt(maxIdle, n, null);
    }

    public int getMaxWait() {
        return this.getInt(maxWait);
    }

    public void setMaxWait(int n) {
        this.setInt(maxWait, n, null);
    }

    public int getLoginTimeout() {
        return this.getInt(loginTimeout);
    }

    public void setLoginTimeout(int n) {
        this.setInt(loginTimeout, n, null);
    }

    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    public void setUpdatePeriod(BRelTime bRelTime) {
        this.set(updatePeriod, (BValue)bRelTime, null);
    }

    public int getNumActive() {
        return this.getInt(numActive);
    }

    public void setNumActive(int n) {
        this.setInt(numActive, n, null);
    }

    public int getPeakNumActive() {
        return this.getInt(peakNumActive);
    }

    public void setPeakNumActive(int n) {
        this.setInt(peakNumActive, n, null);
    }

    public int getNumIdle() {
        return this.getInt(numIdle);
    }

    public void setNumIdle(int n) {
        this.setInt(numIdle, n, null);
    }

    public void updateConnectionStats() {
        this.invoke(updateConnectionStats, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == updatePeriod) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
            }
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateConnectionStats, null);
        }
    }

    public void subscribed() {
        this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateConnectionStats, null);
    }

    public void unsubscribed() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
    }

    public abstract void doUpdateConnectionStats();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getConnection(String string, String string2) throws SQLException {
        int n = this.getLoginTimeout();
        LOG.trace("pool.getConnection, timeout: " + n);
        if (n < 0) {
            throw new BajaRuntimeException("loginTimeout cannot be less than zero.");
        }
        if (n == 0) {
            Object object = this.lock;
            synchronized (object) {
                return this.obtainConnection(string, string2);
            }
        }
        Producer producer = new Producer(this, string, string2);
        new Thread(producer).start();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!producer.isFinished()) {
            LOG.trace("pool.getConnection, timed out, timeout: " + n);
            throw new BajaRuntimeException("pool.getConnection, timed out, timeout: " + n);
        }
        if (producer.getException() == null) {
            return producer.getConnection();
        }
        throw producer.getException();
    }

    protected abstract Connection obtainConnection(String var1, String var2) throws SQLException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Producer
    extends Thread {
        private final BAbstractConnectionPool pool;
        private final String userName;
        private final String password;
        private boolean finished;
        private Connection connection;
        private SQLException exception;

        private Producer(BAbstractConnectionPool bAbstractConnectionPool, String string, String string2) {
            this.pool = bAbstractConnectionPool;
            this.userName = string;
            this.password = string2;
            this.finished = false;
            this.connection = null;
            this.exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.pool.lock;
                synchronized (object) {
                    this.connection = this.pool.obtainConnection(this.userName, this.password);
                    this.finished = true;
                    this.pool.lock.notifyAll();
                }
            }
            catch (SQLException sQLException) {
                Producer producer = this;
                synchronized (producer) {
                    this.exception = sQLException;
                }
            }
        }

        private synchronized boolean isFinished() {
            return this.finished;
        }

        private synchronized SQLException getException() {
            return this.exception;
        }

        private synchronized Connection getConnection() {
            return this.connection;
        }
    }
}

