/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.baja.io.net.IClientSocketFactory;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.net.BInternetAddress;
import javax.baja.net.HttpConnection;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpsConnection
extends HttpConnection {
    private IClientSocketFactory socketFactory;

    private final void initSocketFactory(IClientSocketFactory iClientSocketFactory) {
        try {
            if (iClientSocketFactory == null) {
                iClientSocketFactory = HttpsConnection.getDefaultSocketFactory();
            }
        }
        catch (IOException iOException) {}
        this.socketFactory = iClientSocketFactory;
    }

    public static int post(BHost bHost, int n, String string, String string2, byte[] byArray) throws IOException {
        HttpsConnection httpsConnection = new HttpsConnection(bHost, n, string);
        httpsConnection.setRequestMethod("POST");
        if (string2 != null) {
            httpsConnection.setRequestHeader("content-type", string2);
        }
        httpsConnection.setRequestHeader("content-length", byArray.length);
        int n2 = ((HttpConnection)httpsConnection).connect(byArray.length, new ByteArrayInputStream(byArray));
        try {
            httpsConnection.readContent();
        }
        catch (Exception exception) {}
        return n2;
    }

    public synchronized int connect(long l, InputStream inputStream) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress bInternetAddress = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = bInternetAddress.getAuthority();
            bInternetAddress = null;
        }
        this.s = this.socketFactory.createSocket(((BIpHost)this.host).getInetAddress(), this.port);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (this.timeout > 0) {
            this.s.setSoTimeout(this.timeout);
        }
        return this.newRequest(this.startUri, l, inputStream);
    }

    public synchronized int connect(int n) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress bInternetAddress = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = bInternetAddress.getAuthority();
            bInternetAddress = null;
        }
        this.s = this.socketFactory.createSocket(((BIpHost)this.host).getInetAddress(), this.port);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (n > 0) {
            this.s.setSoTimeout(n);
        }
        return this.newRequest(this.startUri);
    }

    public synchronized int newRequest(String string, long l, InputStream inputStream) throws IOException {
        if (!this.allowMultipleRequests) {
            throw new IOException("This connection doesn't allow multiple requests.");
        }
        if (!this.isOpen()) {
            this.startUri = string;
            return this.connect(l, inputStream);
        }
        this.writeRequest(this.pw, string, l, inputStream);
        return this.readResponse(this.in);
    }

    public static IClientSocketFactory getDefaultSocketFactory() throws IOException {
        IClientSocketFactory iClientSocketFactory;
        try {
            ICryptoManager iCryptoManager = CertManagerFactory.getInstance();
            iClientSocketFactory = iCryptoManager.getClientSocketFactory(BSslTlsEnum.sslv3andtlsv1);
        }
        catch (Exception exception) {
            try {
                iClientSocketFactory = (IClientSocketFactory)BOrd.make((String)"service:crypto:CryptoService|slot:ssl").get();
            }
            catch (Exception exception2) {
                throw new IOException(exception2.getMessage());
            }
        }
        return iClientSocketFactory;
    }

    private final /* synthetic */ void this() {
        this.socketFactory = null;
    }

    public HttpsConnection(BHost bHost, int n, String string, IClientSocketFactory iClientSocketFactory) {
        super(bHost, n, string);
        this.this();
        this.initSocketFactory(iClientSocketFactory);
    }

    public HttpsConnection(BHost bHost, int n, String string) {
        super(bHost, n, string);
        this.this();
        this.initSocketFactory(null);
    }

    private HttpsConnection(BHost bHost, int n) {
        super(bHost, n);
        this.this();
        this.initSocketFactory(null);
    }
}

