/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.net;

import com.tridium.net.BProxyAuthenticationType;
import com.tridium.net.ChunkedOutputStream;
import com.tridium.net.HttpDateFormat;
import com.tridium.net.HttpInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.file.FileUtil;
import javax.baja.naming.BHost;
import javax.baja.net.BHttpProxyService;
import javax.baja.net.BInternetAddress;
import javax.baja.net.HttpException;
import javax.baja.status.BStatus;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpConnection {
    public static final String HTTP_VERSION = "HTTP/1.1";
    static String defUserAgent = "Niagara";
    String startUri;
    String requestMethod;
    String hostHeader;
    StatusLine statusLine;
    boolean allowMultipleRequests;
    boolean requestComplete;
    boolean transferChunked;
    String userAgent;
    Socket s;
    BufferedOutputStream out;
    PrintWriter pw;
    InputStream in;
    int timeout;
    int port;
    BHost host;
    BHttpProxyService proxy;
    Vector requestHeaderFields;
    Hashtable responseHeaderFields;
    static /* synthetic */ Class class$javax$baja$net$HttpConnection;

    public static int post(BHost bHost, int n, String string, String string2, byte[] byArray) throws IOException {
        HttpConnection httpConnection = new HttpConnection(bHost, n, string);
        httpConnection.setRequestMethod("POST");
        if (string2 != null) {
            httpConnection.setRequestHeader("content-type", string2);
        }
        httpConnection.setRequestHeader("content-length", byArray.length);
        int n2 = httpConnection.connect(byArray.length, new ByteArrayInputStream(byArray));
        try {
            httpConnection.readContent();
        }
        catch (Exception exception) {}
        return n2;
    }

    public static void setDefaultUserAgent(String string) {
        defUserAgent = string;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void setTimeout(int n) throws SocketException {
        this.timeout = n;
        if (this.s != null) {
            this.s.setSoTimeout(n);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUri() {
        return this.startUri;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String string) {
        this.requestMethod = string;
    }

    public void setRequestHeader(String string, String string2) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, string2));
    }

    public void setRequestHeader(String string, int n) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, n));
    }

    public void setRequestHeader(String string, long l) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, l));
    }

    public void setRequestHeader(String string, boolean bl) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, bl));
    }

    void checkHeaderReset() {
        if (this.requestComplete) {
            this.requestHeaderFields.removeAllElements();
            this.requestComplete = false;
        }
    }

    public void removeRequestHeader(String string) {
        int n = 0;
        while (n < this.requestHeaderFields.size()) {
            NameValue nameValue = (NameValue)this.requestHeaderFields.elementAt(n);
            if (nameValue.name.equalsIgnoreCase(string)) {
                this.requestHeaderFields.removeElementAt(n);
                return;
            }
            ++n;
        }
    }

    public void setFollowRedirects(boolean bl) {
    }

    public boolean isRedirected() {
        return false;
    }

    public synchronized int connect() throws IOException {
        return this.connect(0L, null);
    }

    public synchronized int connect(long l, InputStream inputStream) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress bInternetAddress = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = bInternetAddress.getAuthority();
            bInternetAddress = null;
        }
        this.proxy = BHttpProxyService.get(this.host);
        this.s = this.proxy != null ? this.proxy.openSocket() : this.host.openSocket(this.port);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (this.timeout > 0) {
            this.s.setSoTimeout(this.timeout);
        }
        return this.newRequest(this.startUri, l, inputStream);
    }

    public synchronized int connect(int n) throws IOException {
        if (this.hostHeader == null) {
            BInternetAddress bInternetAddress = new BInternetAddress(this.host.getHostname(), this.port != 80 ? this.port : -1);
            this.hostHeader = bInternetAddress.getAuthority();
            bInternetAddress = null;
        }
        this.proxy = BHttpProxyService.get(this.host);
        this.s = this.proxy != null ? this.proxy.openSocket(n) : this.host.openSocket(this.port, n);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (n > 0) {
            this.s.setSoTimeout(n);
        }
        return this.newRequest(this.startUri);
    }

    public synchronized int newRequest(String string) throws IOException {
        return this.newRequest(string, 0L, null);
    }

    public synchronized int newRequest(String string, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return this.newRequest(string);
        }
        return this.newRequest(string, byArray.length, new ByteArrayInputStream(byArray));
    }

    public synchronized int newRequest(String string, long l, InputStream inputStream) throws IOException {
        if (!this.allowMultipleRequests) {
            throw new IOException("This connection doesn't allow multiple requests.");
        }
        if (!this.isOpen()) {
            this.startUri = string;
            return this.connect(l, inputStream);
        }
        this.writeRequest(this.pw, string, l, inputStream);
        return this.readResponse(this.in);
    }

    public synchronized int post(String string, String string2, long l, InputStream inputStream) throws IOException {
        this.setRequestMethod("POST");
        this.setRequestHeader("content-type", string2);
        this.setRequestHeader("content-length", l);
        this.removeRequestHeader("expect");
        return this.newRequest(string, l, inputStream);
    }

    public synchronized int post(String string, String string2, byte[] byArray) throws IOException {
        this.setRequestMethod("POST");
        this.setRequestHeader("content-type", string2);
        this.setRequestHeader("content-length", byArray.length);
        this.removeRequestHeader("expect");
        return this.newRequest(string, byArray.length, new ByteArrayInputStream(byArray));
    }

    public synchronized int put(String string, String string2, byte[] byArray) throws IOException {
        this.setRequestMethod("PUT");
        this.setRequestHeader("content-type", string2);
        this.setRequestHeader("content-length", byArray.length);
        this.removeRequestHeader("expect");
        return this.newRequest(string, byArray.length, new ByteArrayInputStream(byArray));
    }

    public synchronized int put(String string, String string2, long l, InputStream inputStream) throws IOException {
        this.setRequestMethod("PUT");
        this.setRequestHeader("content-type", string2);
        this.setRequestHeader("content-length", l);
        this.removeRequestHeader("expect");
        return this.newRequest(string, l, inputStream);
    }

    public int postComplete() throws IOException {
        if (!this.requestMethod.equals("POST")) {
            throw new IllegalStateException("Request was not a post.");
        }
        this.out.flush();
        this.responseHeaderFields.clear();
        int n = this.readResponse(this.in);
        return n;
    }

    public int putComplete() throws IOException {
        if (!this.requestMethod.equals("PUT")) {
            throw new IllegalStateException("Request was not a put.");
        }
        this.out.flush();
        this.responseHeaderFields.clear();
        int n = this.readResponse(this.in);
        return n;
    }

    void writeRequest(PrintWriter printWriter, String string, long l, InputStream inputStream) throws IOException {
        String string2;
        printWriter.print(this.requestMethod);
        printWriter.print(' ');
        if (this.proxy != null) {
            printWriter.print("http://" + this.hostHeader + string);
        } else {
            printWriter.print(string);
        }
        printWriter.print(' ');
        printWriter.print(HTTP_VERSION);
        printWriter.print("\r\n");
        if (this.proxy != null && !this.proxy.getAuthenticationScheme().equals((Object)BProxyAuthenticationType.none)) {
            printWriter.print("Proxy-Authorization: ");
            printWriter.print(this.proxy.getAuthentication());
            printWriter.print("\r\n");
        }
        String string3 = string2 = this.userAgent != null ? this.userAgent : defUserAgent;
        if (string2 != null) {
            printWriter.print("user-agent: ");
            printWriter.print(string2);
            printWriter.print("\r\n");
        }
        printWriter.print("host: ");
        printWriter.print(this.hostHeader.toString());
        printWriter.print("\r\n");
        int n = 0;
        while (n < this.requestHeaderFields.size()) {
            NameValue nameValue = (NameValue)this.requestHeaderFields.elementAt(n);
            printWriter.print(nameValue.name);
            printWriter.print(": ");
            printWriter.print(nameValue.value);
            printWriter.print("\r\n");
            ++n;
        }
        printWriter.print("\r\n");
        printWriter.flush();
        if (inputStream != null) {
            FileUtil.pipe((InputStream)inputStream, (OutputStream)this.out);
            this.out.flush();
        }
        this.requestComplete = true;
        this.responseHeaderFields.clear();
    }

    /*
     * Unable to fully structure code
     */
    protected int readResponse(InputStream var1_1) throws IOException {
        this.statusLine = new StatusLine(var1_1);
        var2_2 = new StringBuffer(30);
        while (true) {
            var3_3 = null;
            var4_4 = null;
            var2_2.setLength(0);
            var5_5 = var1_1.read();
            if (var5_5 == 13) {
                var5_5 = var1_1.read();
                break;
            }
            if (var5_5 == 10) break;
            if (var5_5 != -1) ** GOTO lbl18
            this.close();
            throw new EOFException("End of input while reading response.");
lbl-1000:
            // 1 sources

            {
                var2_2.append((char)var5_5);
                var5_5 = var1_1.read();
lbl18:
                // 2 sources

                ** while (var5_5 != -1 && var5_5 != 58)
            }
lbl19:
            // 1 sources

            if (var5_5 == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            var3_3 = var2_2.toString();
            var5_5 = var1_1.read();
            while (var5_5 != -1 && var5_5 == 32) {
                var5_5 = var1_1.read();
            }
            if (var5_5 == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            var2_2.setLength(0);
            while (var5_5 != -1 && var5_5 != 13 && var5_5 != 10) {
                var2_2.append((char)var5_5);
                var5_5 = var1_1.read();
            }
            if (var5_5 == -1) {
                this.close();
                throw new EOFException("End of input while reading response.");
            }
            if (var5_5 == 13) {
                var5_5 = var1_1.read();
            }
            var4_4 = var2_2.toString();
            if (var3_3 == null || var4_4 == null) continue;
            this.responseHeaderFields.put(var3_3.toLowerCase(), var4_4);
        }
        var3_3 = this.getResponseHeader("Connection");
        if (var3_3 != null && var3_3.equalsIgnoreCase("close") && this.statusLine.getStatusCode() != 302) {
            this.allowMultipleRequests = false;
        }
        if (this.proxy != null) {
            switch (this.statusLine.getStatusCode()) {
                case 407: 
                case 502: 
                case 504: {
                    this.proxy.setStatus(BStatus.makeFault((BStatus)this.proxy.getStatus(), (boolean)true));
                    this.proxy.setFaultCause(this.statusLine.getMessage());
                    BHttpProxyService.log.error(this.statusLine.getMessage() + " (HTTP " + this.statusLine.getStatusCode() + ')');
                    break;
                }
                default: {
                    this.proxy.setStatus(BStatus.makeFault((BStatus)this.proxy.getStatus(), (boolean)false));
                    this.proxy.setFaultCause("");
                }
            }
        }
        return this.statusLine.getStatusCode();
    }

    public String getResponseVersion() {
        return this.statusLine.getVersion();
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public String getStatusMessage() {
        return this.statusLine.getMessage();
    }

    public String getContentType() {
        return this.getResponseHeader("Content-Type");
    }

    public int getContentLength() {
        return this.getResponseHeaderInt("Content-Length");
    }

    public byte[] readContent() throws IOException {
        InputStream inputStream = this.getInputStream();
        byte[] byArray = null;
        int n = this.getContentLength();
        if (n != -1) {
            byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
        } else {
            byte[] byArray2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            int n2 = 0;
            while ((n2 = inputStream.read(byArray2, 0, 1024)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public String getRequestHeader(String string) {
        if (this.requestHeaderFields == null) {
            return null;
        }
        int n = 0;
        while (n < this.requestHeaderFields.size()) {
            NameValue nameValue = (NameValue)this.requestHeaderFields.elementAt(n);
            if (nameValue.name.equalsIgnoreCase(string)) {
                return nameValue.value;
            }
            ++n;
        }
        return null;
    }

    public String getResponseHeader(String string) {
        return (String)this.responseHeaderFields.get(string.toLowerCase());
    }

    public Enumeration getResponseHeaderNames() {
        return this.responseHeaderFields.keys();
    }

    public int getResponseHeaderInt(String string) {
        String string2 = (String)this.responseHeaderFields.get(string.toLowerCase());
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public long getResponseHeaderDate(String string) {
        String string2 = (String)this.responseHeaderFields.get(string.toLowerCase());
        if (string2 != null) {
            try {
                return HttpDateFormat.parse(string2);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is not open");
        }
        int n = this.getResponseHeaderInt("Content-Length");
        String string = this.getResponseHeader("Transfer-Encoding");
        if (string != null && string.equalsIgnoreCase("chunked")) {
            return new HttpInputStream(this.in, true);
        }
        return new HttpInputStream(this.in, n);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is not open");
        }
        String string = this.getRequestHeader("Transfer-Encoding");
        if (string != null && string.equalsIgnoreCase("chunked")) {
            this.transferChunked = true;
            return new ChunkedOutputStream(this.out, 2048);
        }
        this.transferChunked = false;
        return this.out;
    }

    public boolean isTransferChunked() {
        return this.transferChunked;
    }

    public boolean isOpen() {
        boolean bl = false;
        if (this.s != null) {
            bl = true;
        }
        return bl;
    }

    public boolean shouldClose() {
        return this.allowMultipleRequests ^ true;
    }

    public void close() {
        if (this.s != null) {
            try {
                this.pw.flush();
            }
            catch (Exception exception) {}
            try {
                this.in.close();
            }
            catch (Exception exception) {}
            try {
                this.out.flush();
            }
            catch (Exception exception) {}
            try {
                this.out.close();
            }
            catch (Exception exception) {}
            try {
                this.s.close();
            }
            catch (Exception exception) {}
            this.pw = null;
            this.in = null;
            this.out = null;
            this.s = null;
            this.allowMultipleRequests = true;
            this.transferChunked = false;
            this.requestHeaderFields.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String dumpResponseHeader() {
        var1_1 = new StringBuffer(100);
        var1_1.append(this.statusLine).append('\n');
        var2_2 = this.responseHeaderFields.keys();
        if (var2_2.hasMoreElements()) ** GOTO lbl10
        return var1_1.toString();
lbl-1000:
        // 1 sources

        {
            var3_3 = (String)var2_2.nextElement();
            var1_1.append("   ").append(var3_3).append(": ").append(this.responseHeaderFields.get(var3_3)).append('\n');
lbl10:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl11:
        // 1 sources

        return var1_1.toString();
    }

    public void checkOk() throws HttpException {
        this.checkStatus(200);
    }

    public void checkStatus(int n) throws HttpException {
        int n2 = this.getStatusCode();
        if (n2 != n) {
            this.close();
            throw new HttpException(n, n2);
        }
    }

    protected Hashtable getResponseHeaderFields() {
        return this.responseHeaderFields;
    }

    protected StatusLine getStatusLine() {
        return this.statusLine;
    }

    protected void setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
    }

    public Socket getSocket() {
        return this.s;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.requestMethod = "GET";
        this.allowMultipleRequests = true;
        this.requestComplete = true;
        this.transferChunked = false;
        this.timeout = 0;
        this.port = 80;
    }

    public HttpConnection(BHost bHost, int n, String string) {
        this(bHost, n);
        this.startUri = string;
    }

    public HttpConnection(BHost bHost, int n) {
        this.this();
        this.host = bHost;
        this.port = n;
        this.requestHeaderFields = new Vector(5);
        this.responseHeaderFields = new Hashtable(5);
        this.timeout = 0;
    }

    static {
        try {
            StringBuffer stringBuffer = new StringBuffer().append(defUserAgent).append('/');
            Class clazz = class$javax$baja$net$HttpConnection;
            if (clazz == null) {
                clazz = class$javax$baja$net$HttpConnection = HttpConnection.class("[Ljavax.baja.net.HttpConnection;", false);
            }
            defUserAgent = stringBuffer.append(Sys.getModuleForClass((Class)clazz).getVendorVersion()).toString();
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class NameValue {
        public String name;
        public String value;

        public NameValue(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public NameValue(String string, int n) {
            this.name = string;
            this.value = Integer.toString(n);
        }

        public NameValue(String string, long l) {
            this.name = string;
            this.value = String.valueOf(l);
        }

        public NameValue(String string, boolean bl) {
            this.name = string;
            this.value = "" + bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class StatusLine {
        InputStream in;
        String version;
        int statusCode;
        String message;

        protected void readVersion() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(8);
            int n = this.in.read();
            while (n != -1 && n != 32) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            if (n == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading version.");
            }
            this.version = stringBuffer.toString();
        }

        public String getVersion() {
            return this.version;
        }

        protected void readStatusCode() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(3);
            int n = this.in.read();
            while (n != -1 && n != 32) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            if (n == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading status code.");
            }
            this.statusCode = Integer.parseInt(stringBuffer.toString());
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        protected void readMessage() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(25);
            int n = this.in.read();
            while (n != -1 && n != 13) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            if (n == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading reason phrase.");
            }
            n = this.in.read();
            this.message = stringBuffer.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.version + ' ' + this.statusCode + ' ' + this.message;
        }

        public StatusLine(InputStream inputStream) throws IOException {
            this.in = inputStream;
            this.readVersion();
            this.readStatusCode();
            this.readMessage();
        }
    }
}

