/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class HttpDateFormat {
    private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);

    public static String format(long l, char c) {
        return HttpDateFormat.formatDate(new Date(l), c);
    }

    public static String format(long l) {
        return HttpDateFormat.formatDate(new Date(l), ' ');
    }

    public static String formatDate(Date date) {
        return HttpDateFormat.formatDate(date, ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String formatDate(Date date, char c) {
        DateTimeInfo dateTimeInfo = new DateTimeInfo();
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.setTime(date);
            dateTimeInfo.dayOfWeek = cal.get(7);
            dateTimeInfo.dayOfMonth = cal.get(5);
            dateTimeInfo.month = cal.get(2);
            dateTimeInfo.year = cal.get(1);
            dateTimeInfo.hour = cal.get(11);
            dateTimeInfo.minute = cal.get(12);
            dateTimeInfo.second = cal.get(13);
            return HttpDateFormat.formatDateTimeInfo(dateTimeInfo, c);
        }
    }

    private static final String formatDateTimeInfo(DateTimeInfo dateTimeInfo, char c) {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(HttpDateFormat.getDayOfWeekString(dateTimeInfo.dayOfWeek));
        stringBuffer.append(", ");
        if (dateTimeInfo.dayOfMonth < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(dateTimeInfo.dayOfMonth);
        stringBuffer.append(c);
        stringBuffer.append(HttpDateFormat.getMonthString(dateTimeInfo.month));
        stringBuffer.append(c);
        stringBuffer.append(dateTimeInfo.year).append(' ');
        if (dateTimeInfo.hour < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(dateTimeInfo.hour).append(':');
        if (dateTimeInfo.minute < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(dateTimeInfo.minute).append(':');
        if (dateTimeInfo.second < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(dateTimeInfo.second);
        stringBuffer.append(" GMT");
        return stringBuffer.toString();
    }

    public static String getDayOfWeekString(int n) {
        switch (n) {
            case 1: {
                return "Sun";
            }
            case 2: {
                return "Mon";
            }
            case 3: {
                return "Tue";
            }
            case 4: {
                return "Wed";
            }
            case 5: {
                return "Thu";
            }
            case 6: {
                return "Fri";
            }
            case 7: {
                return "Sat";
            }
        }
        throw new IllegalArgumentException("Invalid weekday index: " + n);
    }

    public static String getMonthString(int n) {
        switch (n) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        throw new IllegalArgumentException("Invalid month index: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long parse(String string) throws IllegalArgumentException {
        try {
            DateTimeInfo dateTimeInfo = new DateTimeInfo();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            String string2 = stringTokenizer.nextToken();
            dateTimeInfo.dayOfWeek = HttpDateFormat.getWeekday(string2);
            if (dateTimeInfo.dayOfWeek != -1) {
                string2 = stringTokenizer.nextToken(" ,-");
            }
            dateTimeInfo.dayOfMonth = HttpDateFormat.getDayOfMonth(string2);
            boolean bl = false;
            if (dateTimeInfo.dayOfMonth != -1) {
                HttpDateFormat.parseDate1OrDate2(dateTimeInfo, stringTokenizer);
            } else {
                bl = true;
                dateTimeInfo.month = HttpDateFormat.getMonth(string2);
                if (dateTimeInfo.month == -1) {
                    throw new IllegalArgumentException("Invalid date string: " + string);
                }
                HttpDateFormat.parseAsctimeDate(dateTimeInfo, stringTokenizer);
            }
            HttpDateFormat.parseTime(dateTimeInfo, stringTokenizer);
            if (bl) {
                dateTimeInfo.year = Integer.parseInt(stringTokenizer.nextToken());
            }
            Calendar calendar = cal;
            synchronized (calendar) {
                cal.set(dateTimeInfo.year, dateTimeInfo.month, dateTimeInfo.dayOfMonth, dateTimeInfo.hour, dateTimeInfo.minute, dateTimeInfo.second);
                return cal.getTime().getTime();
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid date string: " + string);
        }
    }

    public static int getWeekday(String string) {
        char c = string.charAt(0);
        switch (c) {
            case 'M': 
            case 'm': {
                return 2;
            }
            case 'T': 
            case 't': {
                char c2 = string.charAt(1);
                if (c2 == 'u' || c2 == 'U') {
                    return 3;
                }
                return 5;
            }
            case 'W': 
            case 'w': {
                return 4;
            }
            case 'F': 
            case 'f': {
                return 6;
            }
            case 'S': 
            case 's': {
                char c3 = string.charAt(1);
                if (c3 == 'u' || c3 == 'U') {
                    return 1;
                }
                return 7;
            }
        }
        return -1;
    }

    public static int getDayOfMonth(String string) {
        if (Character.isDigit(string.charAt(0))) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static int getMonth(String string) {
        char c = string.charAt(0);
        switch (c) {
            case 'J': 
            case 'j': {
                char c2 = string.charAt(1);
                if (c2 == 'a' || c2 == 'A') {
                    return 0;
                }
                char c3 = string.charAt(2);
                if (c3 == 'n' || c3 == 'N') {
                    return 5;
                }
                return 6;
            }
            case 'F': 
            case 'f': {
                return 1;
            }
            case 'M': 
            case 'm': {
                char c4 = string.charAt(2);
                if (c4 == 'r' || c4 == 'R') {
                    return 2;
                }
                return 4;
            }
            case 'A': 
            case 'a': {
                char c5 = string.charAt(1);
                if (c5 == 'p' || c5 == 'P') {
                    return 3;
                }
                return 7;
            }
            case 'S': 
            case 's': {
                return 8;
            }
            case 'O': 
            case 'o': {
                return 9;
            }
            case 'N': 
            case 'n': {
                return 10;
            }
            case 'D': 
            case 'd': {
                return 11;
            }
        }
        return -1;
    }

    private static final void parseDate1OrDate2(DateTimeInfo dateTimeInfo, StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken(" -");
        dateTimeInfo.month = HttpDateFormat.getMonth(string);
        if (dateTimeInfo.month == -1) {
            throw new IllegalArgumentException("Invalid month string: " + string);
        }
        string = stringTokenizer.nextToken();
        dateTimeInfo.year = Integer.parseInt(string);
        if (dateTimeInfo.year < 100) {
            dateTimeInfo.year = dateTimeInfo.year < 60 ? (dateTimeInfo.year += 2000) : (dateTimeInfo.year += 1900);
        }
    }

    private static final void parseAsctimeDate(DateTimeInfo dateTimeInfo, StringTokenizer stringTokenizer) {
        dateTimeInfo.dayOfMonth = Integer.parseInt(stringTokenizer.nextToken());
    }

    private static final void parseTime(DateTimeInfo dateTimeInfo, StringTokenizer stringTokenizer) {
        dateTimeInfo.hour = Integer.parseInt(stringTokenizer.nextToken(" :"));
        dateTimeInfo.minute = Integer.parseInt(stringTokenizer.nextToken());
        dateTimeInfo.second = Integer.parseInt(stringTokenizer.nextToken());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class DateTimeInfo {
        public int dayOfWeek;
        public int dayOfMonth;
        public int month;
        public int year;
        public int hour;
        public int minute;
        public int second;

        public void printAttributes() {
            System.out.println("DateTimeInfo:");
            System.out.println("  dayOfWeek : " + this.dayOfWeek);
            System.out.println("  dayOfMonth: " + this.dayOfMonth);
            System.out.println("  month     : " + this.month);
            System.out.println("  year      : " + this.year);
            System.out.println("  hour      : " + this.hour);
            System.out.println("  minute    : " + this.minute);
            System.out.println("  second    : " + this.second);
        }

        private final /* synthetic */ void this() {
            this.dayOfWeek = -1;
            this.dayOfMonth = -1;
            this.month = -1;
            this.year = -1;
            this.hour = -1;
            this.minute = -1;
            this.second = -1;
        }

        private DateTimeInfo() {
            this.this();
        }
    }
}

