/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.serial;

import com.tridium.basicdriver.BBasicNetwork;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BSerialNetwork
extends BBasicNetwork
implements BISerialHelperParent {
    public static final Property interMessageDelay = BSerialNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property serialPortConfig = BSerialNetwork.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Type TYPE;
    private Log log;
    private Subscriber subscriber;
    private String serialInitError;
    static /* synthetic */ Class class$com$tridium$basicdriver$serial$BSerialNetwork;

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serviceStarted() throws Exception {
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
        this.subscriber.subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log = this.log;
        synchronized (log) {
            this.log = this.getLog();
        }
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startComm() throws Exception {
        String string;
        block6: {
            try {
                try {
                    super.startComm();
                    this.serialInitError = null;
                }
                catch (Exception exception) {
                    this.serialInitError = "Could not enable serial communication (" + exception + ')';
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                String string2 = this.checkSerialConfig();
                if (string2 == null) {
                    this.configOk();
                    throw throwable;
                }
                this.configFail(string2);
                throw throwable;
            }
            {
                Object var2_4 = null;
                string = this.checkSerialConfig();
                if (string != null) break block6;
            }
            this.configOk();
            return;
        }
        this.configFail(string);
    }

    protected String checkSerialConfig() {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            return "No port selected for serial communication.";
        }
        return this.serialInitError;
    }

    public final Log getLog() {
        String string = this.getName() + '_' + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        return Log.getLog((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateLog() {
        String string = this.getName() + '_' + this.getSerialPortConfig().getPortName();
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        Log log = Log.getLog((String)string);
        if (this.log == null) {
            this.log = this.getLog();
        }
        Log log2 = this.log;
        synchronized (log2) {
            if (this.log != null) {
                log.setSeverity(this.log.getSeverity());
                if (!log.getLogName().equals(this.log.getLogName())) {
                    Log.deleteLog((String)this.log.getLogName());
                }
            }
            this.log = log;
            return;
        }
    }

    public final void reopenPort() {
        try {
            String string = this.getSerialPortConfig().getPortName();
            if (string.equals("none")) {
                this.configFail("No port selected for serial communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception exception) {
            this.getLog().error("BSerialNetwork caught exception in reopenPort(): ", (Throwable)exception);
        }
    }

    private final void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log.isTraceOn()) {
                this.log.trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    protected final void serialServiceStarted() throws Exception {
    }

    protected final void serialServiceStopped() throws Exception {
    }

    protected final void serialNetworkStarted() {
    }

    protected final void serialNetworkStopped() {
    }

    protected final void serialNetworkChanged(Property property, Context context) {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.log = null;
        this.serialInitError = null;
    }

    public BSerialNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$basicdriver$serial$BSerialNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$basicdriver$serial$BSerialNetwork = BSerialNetwork.class("[Lcom.tridium.basicdriver.serial.BSerialNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NameSubscriber
    extends Subscriber {
        private BSerialNetwork net;

        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getId() == 3) {
                if (bComponentEvent.getSlot().equals((Object)this.net.getPropertyInParent())) {
                    this.net.updateLog();
                }
            } else if (bComponentEvent.getId() == 0 && bComponentEvent.getSlot().equals((Object)BSerialHelper.portName)) {
                this.net.updateLog();
            }
        }

        public NameSubscriber(BSerialNetwork bSerialNetwork2) {
            this.net = bSerialNetwork2;
        }
    }
}

