/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class CommTransmitter
extends Comm.CommSupport {
    private OutputStream out;

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeMessage(Message message) {
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                if (this.getComm().getNetwork() != null && this.getComm().getNetwork().getLog().isTraceOn()) {
                    this.getComm().getNetwork().getLog().trace("**** Sending Message [" + this.getComm().getNetwork().getName() + "]: " + message.toDebugString());
                }
                this.getComm().getCommReceiver().initReceiveState(message);
                this.writeBytesStart(this.out);
                message.write(this.out);
                this.writeBytesEnd(this.out);
                return;
            }
        }
        catch (Exception exception) {
            this.getComm().handleFailedTransmit(message, exception);
        }
    }

    public void writeBytesStart(OutputStream outputStream) throws Exception {
    }

    public void writeBytesEnd(OutputStream outputStream) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBytes(byte[] byArray) throws Exception {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            if (this.getComm().getNetwork() != null && this.getComm().getNetwork().getLog().isTraceOn()) {
                System.out.println("****** Sending Bytes [" + this.getComm().getNetwork().getName() + "]: *******");
                ByteArrayUtil.hexDump((byte[])byArray);
                System.out.println("****************************************");
            }
            this.getComm().getCommReceiver().initReceiveState(byArray);
            this.writeBytesStart(this.out);
            if (byArray.length > 0) {
                this.out.write(byArray);
            }
            this.writeBytesEnd(this.out);
            return;
        }
    }

    public void writeByte(int n) throws Exception {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }
}

