/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransaction;
import com.tridium.basicdriver.comm.CommTransactionManager;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Comm {
    private BBasicNetwork basicNetwork;
    private CommReceiver rDriver;
    private CommTransmitter tDriver;
    private CommTransactionManager transactionManager;
    private boolean commStarted;
    private Hashtable listeners;

    public final void setCommTransactionManager(CommTransactionManager commTransactionManager) {
        try {
            boolean bl = this.installSupport(this.transactionManager, commTransactionManager);
            this.transactionManager = commTransactionManager;
            if (bl) {
                this.start();
            }
        }
        catch (Exception exception) {
            this.basicNetwork.getLog().error("Error in Comm.setCommTransactionManager()", (Throwable)exception);
        }
    }

    public final void setCommTransmitter(CommTransmitter commTransmitter) {
        try {
            boolean bl = this.installSupport(this.tDriver, commTransmitter);
            this.tDriver = commTransmitter;
            if (bl) {
                this.start();
            }
        }
        catch (Exception exception) {
            this.basicNetwork.getLog().error("Error in Comm.setCommTransmitter()", (Throwable)exception);
        }
    }

    public final void setCommReceiver(CommReceiver commReceiver) {
        try {
            boolean bl = this.installSupport(this.rDriver, commReceiver);
            this.rDriver = commReceiver;
            if (bl) {
                this.start();
            }
        }
        catch (Exception exception) {
            this.basicNetwork.getLog().error("Error in Comm.setCommReceiver()", (Throwable)exception);
        }
    }

    public BBasicNetwork getNetwork() {
        return this.basicNetwork;
    }

    public CommTransactionManager getCommTransactionManager() {
        return this.transactionManager;
    }

    public CommTransmitter getCommTransmitter() {
        return this.tDriver;
    }

    public CommReceiver getCommReceiver() {
        return this.rDriver;
    }

    private final boolean installSupport(CommSupport commSupport, CommSupport commSupport2) throws Exception {
        if (commSupport2 == null) {
            throw new NullPointerException();
        }
        if (commSupport == commSupport2) {
            return false;
        }
        if (commSupport2.comm != null) {
            throw new IllegalArgumentException("Already installed on another Comm");
        }
        boolean bl = this.isCommStarted();
        if (bl) {
            this.stop();
        }
        if (commSupport != null) {
            commSupport.setComm(null);
        }
        commSupport2.setComm(this);
        return bl;
    }

    public boolean isCommStarted() {
        return this.commStarted;
    }

    public final void start() throws Exception {
        if (!this.isCommStarted() && this.tDriver != null && this.started()) {
            this.commStarted = true;
        }
    }

    public final void stop() throws Exception {
        if (this.isCommStarted()) {
            this.commStarted = false;
            if (this.basicNetwork.getDispatcher().isRunning()) {
                StopRequest stopRequest = new StopRequest();
                this.basicNetwork.dispatch(stopRequest);
                stopRequest.stop();
            }
            this.stopped();
        }
    }

    protected abstract boolean started() throws Exception;

    protected abstract void stopped() throws Exception;

    public final Message transmit(Message message) throws BasicException {
        return this.transmit(message, this.basicNetwork.getResponseTimeout(), this.basicNetwork.getRetryCount());
    }

    public Message transmit(Message message, BRelTime bRelTime, int n) throws BasicException {
        if (message == null) {
            return null;
        }
        if (!message.getResponseExpected()) {
            this.transmitNoResponse(message);
            return null;
        }
        BasicException basicException = null;
        Message message2 = null;
        try {
            int n2 = 0;
            while (n2 < n + 1) {
                message2 = this.processTransmit(message, bRelTime);
                if (message2 != null && message2.getSuccessfulResponse()) break;
                ++n2;
            }
            if (message2 != null && !message2.getSuccessfulResponse()) {
                String string = "Unsuccessful response for request message sent.";
                basicException = new BasicException(string);
            }
        }
        catch (BasicException basicException2) {
            basicException = basicException2;
        }
        if (basicException != null) {
            if (basicException instanceof BasicException) {
                if (this.basicNetwork.getLog().isTraceOn()) {
                    this.basicNetwork.getLog().trace("Comm sendRequest exception: ", (Throwable)((Object)basicException));
                }
            } else {
                throw basicException;
            }
        }
        return message2;
    }

    public void transmitNoResponse(Message message) throws BasicException {
        if (message == null) {
            return;
        }
        if (!this.commStarted) {
            throw new BasicException("Communication handler service not started.");
        }
        this.tDriver.writeMessage(message);
        this.getNetwork().incrementSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Message processTransmit(Message message, BRelTime bRelTime) throws BasicException {
        if (!this.commStarted) {
            throw new BasicException("Communication handler service not started.");
        }
        CommTransaction commTransaction = this.transactionManager.getCommTransaction(message);
        CommTransaction commTransaction2 = commTransaction;
        synchronized (commTransaction2) {
            Object object;
            block12: {
                this.tDriver.writeMessage(message);
                this.getNetwork().incrementSent();
                try {
                    if (commTransaction.isComplete()) break block12;
                    commTransaction.wait(bRelTime.getMillis());
                    if (!commTransaction.isComplete()) {
                        if (this.basicNetwork.getLog().isTraceOn()) {
                            object = commTransaction.getRequestMessage().getTag();
                            this.basicNetwork.getLog().trace("CommTransaction timed out (tag: " + object + ')');
                            if (object != Message.DEFAULT_TAG) {
                                try {
                                    Message message2 = commTransaction.getRequestMessage();
                                    if (message2 != null) {
                                        this.basicNetwork.getLog().trace("Failure to get response for sent message: " + message2.toDebugString());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                        commTransaction.setResponseMessage(null);
                        this.basicNetwork.incrementTimeouts();
                    }
                    commTransaction.setComplete(true);
                }
                catch (InterruptedException interruptedException) {}
            }
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl29 : MonitorExitStatement: MONITOREXIT : var4_4
            object = commTransaction.getResponseMessage();
            this.transactionManager.freeCommTransaction(commTransaction);
            return object;
        }
    }

    public void receive(ReceivedMessage receivedMessage) {
        if (receivedMessage == null) {
            return;
        }
        this.getNetwork().incrementReceived();
        if (this.basicNetwork.getLog().isTraceOn()) {
            this.basicNetwork.getLog().trace("**** Received message: " + receivedMessage.toDebugString());
        }
        if (receivedMessage.getUnsolicited()) {
            this.routeToListeners(receivedMessage);
        } else if (!this.handleReceivedMessage(receivedMessage)) {
            this.routeToListeners(receivedMessage);
        }
    }

    public synchronized void receiveFinal() {
        this.getCommTransactionManager().cancelAllOutstandingCommTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleFailedTransmit(Message message, Exception exception) {
        this.basicNetwork.getLog().message("Failure to transmit in CommTransmitter.", (Throwable)exception);
        if (!message.getResponseExpected()) {
            return;
        }
        Object object = message.getTag();
        CommTransaction commTransaction = this.getCommTransactionManager().getCommTransactionMatch(object);
        CommTransaction commTransaction2 = commTransaction;
        synchronized (commTransaction2) {
            commTransaction.setResponseMessage(null);
            commTransaction.setComplete(true);
            commTransaction.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleReceivedMessage(ReceivedMessage receivedMessage) {
        Object object = receivedMessage.getTag();
        CommTransaction commTransaction = this.getCommTransactionManager().getCommTransactionMatch(object);
        if (commTransaction == null) {
            return false;
        }
        CommTransaction commTransaction2 = commTransaction;
        synchronized (commTransaction2) {
            if (commTransaction.isUsed()) {
                commTransaction.setResponseMessage(commTransaction.getRequestMessage().toResponse(receivedMessage));
                commTransaction.setComplete(true);
                commTransaction.notify();
                return true;
            }
            if (this.basicNetwork.getLog().isTraceOn()) {
                this.basicNetwork.getLog().trace("Unmatched response received - assuming unsolicited");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerListener(UnsolicitedMessageListener unsolicitedMessageListener) {
        Object object = unsolicitedMessageListener.getUnsolicitedListenerCode();
        if (object == null) {
            return;
        }
        Hashtable hashtable = this.listeners;
        synchronized (hashtable) {
            ArrayList<UnsolicitedMessageListener> arrayList = (ArrayList<UnsolicitedMessageListener>)this.listeners.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<UnsolicitedMessageListener>(4);
                this.listeners.put(object, arrayList);
            }
            int n = 0;
            while (true) {
                if (n >= arrayList.size()) {
                    arrayList.add(unsolicitedMessageListener);
                    return;
                }
                UnsolicitedMessageListener unsolicitedMessageListener2 = (UnsolicitedMessageListener)arrayList.get(n);
                if (unsolicitedMessageListener == unsolicitedMessageListener2) {
                    return;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterListener(UnsolicitedMessageListener unsolicitedMessageListener) {
        Object object = unsolicitedMessageListener.getUnsolicitedListenerCode();
        if (object == null) {
            return;
        }
        Hashtable hashtable = this.listeners;
        synchronized (hashtable) {
            ArrayList arrayList = (ArrayList)this.listeners.get(object);
            if (arrayList == null) {
                return;
            }
            this.unregister(arrayList, unsolicitedMessageListener);
            return;
        }
    }

    private final void unregister(ArrayList arrayList, UnsolicitedMessageListener unsolicitedMessageListener) {
        int n = arrayList.size() - 1;
        while (n >= 0) {
            UnsolicitedMessageListener unsolicitedMessageListener2 = (UnsolicitedMessageListener)arrayList.get(n);
            if (unsolicitedMessageListener == unsolicitedMessageListener2) {
                arrayList.remove(n);
            }
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void routeToListeners(ReceivedMessage receivedMessage) {
        Object object = receivedMessage.getUnsolicitedListenerCode();
        if (object == null) {
            return;
        }
        Hashtable hashtable = this.listeners;
        synchronized (hashtable) {
            block5: {
                ArrayList arrayList = (ArrayList)this.listeners.get(object);
                if (arrayList == null) break block5;
                int n = 0;
                while (n < arrayList.size()) {
                    UnsolicitedMessageListener unsolicitedMessageListener = (UnsolicitedMessageListener)arrayList.get(n);
                    unsolicitedMessageListener.receiveMessage(receivedMessage);
                    ++n;
                }
            }
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.rDriver = null;
        this.tDriver = null;
        this.transactionManager = null;
        this.commStarted = false;
        this.listeners = new Hashtable(32);
    }

    public Comm(BBasicNetwork bBasicNetwork, CommReceiver commReceiver) {
        this.this();
        this.basicNetwork = bBasicNetwork;
        this.setCommReceiver(commReceiver);
        this.setCommTransmitter(new CommTransmitter());
        this.setCommTransactionManager(new CommTransactionManager());
    }

    public Comm(BBasicNetwork bBasicNetwork, CommReceiver commReceiver, CommTransmitter commTransmitter) {
        this.this();
        this.basicNetwork = bBasicNetwork;
        this.setCommReceiver(commReceiver);
        this.setCommTransmitter(commTransmitter);
        this.setCommTransactionManager(new CommTransactionManager());
    }

    public Comm(BBasicNetwork bBasicNetwork, CommReceiver commReceiver, CommTransmitter commTransmitter, CommTransactionManager commTransactionManager) {
        this.this();
        this.basicNetwork = bBasicNetwork;
        this.setCommReceiver(commReceiver);
        this.setCommTransmitter(commTransmitter);
        this.setCommTransactionManager(commTransactionManager);
    }

    public static abstract class CommSupport {
        Comm comm;

        public final Comm getComm() {
            return this.comm;
        }

        void setComm(Comm comm) {
            this.comm = comm;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StopRequest
    implements Runnable {
        private boolean complete;

        public synchronized void run() {
            this.complete = true;
            this.notify();
        }

        public synchronized void stop() {
            if (!this.complete) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    Comm.this.basicNetwork.getLog().error("Error in Comm.StopRequest.stop()", (Throwable)exception);
                }
            }
        }

        private final /* synthetic */ void this() {
            this.complete = false;
        }

        public StopRequest() {
            this.this();
        }
    }
}

