/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.util.BBasicCoalescingWorker;
import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.basicdriver.util.BBasicWorker;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BBasicNetwork
extends BLoadableNetwork
implements BIService {
    public static final Property tuningPolicies = BBasicNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property dispatcher = BBasicNetwork.newProperty((int)4, (BValue)new BBasicWorker(), null);
    public static final Property worker = BBasicNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property writeWorker = BBasicNetwork.newProperty((int)4, (BValue)new BBasicCoalescingWorker(), null);
    public static final Property pollScheduler = BBasicNetwork.newProperty((int)0, (BValue)new BBasicPollScheduler(), null);
    public static final Property retryCount = BBasicNetwork.newProperty((int)0, (int)1, null);
    public static final Property responseTimeout = BBasicNetwork.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE;
    private Comm comm;
    private long totalSentMessages;
    private long totalReceivedMessages;
    private long lastSentMessages;
    private long lastReceivedMessages;
    private long lastRateTicks;
    private long totalTimeoutMessages;
    static /* synthetic */ Class class$com$tridium$basicdriver$BBasicNetwork;

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BBasicWorker getDispatcher() {
        return (BBasicWorker)this.get(dispatcher);
    }

    public void setDispatcher(BBasicWorker bBasicWorker) {
        this.set(dispatcher, (BValue)bBasicWorker, null);
    }

    public BBasicWorker getWorker() {
        return (BBasicWorker)this.get(worker);
    }

    public void setWorker(BBasicWorker bBasicWorker) {
        this.set(worker, (BValue)bBasicWorker, null);
    }

    public BBasicCoalescingWorker getWriteWorker() {
        return (BBasicCoalescingWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BBasicCoalescingWorker bBasicCoalescingWorker) {
        this.set(writeWorker, (BValue)bBasicCoalescingWorker, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler bPollScheduler) {
        this.set(pollScheduler, (BValue)bPollScheduler, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int n) {
        this.setInt(retryCount, n, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void serviceStarted() throws Exception {
        this.buildComm();
    }

    public void serviceStopped() throws Exception {
    }

    private final void buildComm() throws Exception {
        this.comm = this.makeComm();
        this.initComm(this.comm);
    }

    protected void initComm(Comm comm) throws Exception {
    }

    public void startComm() throws Exception {
        if (!this.isDisabled() && !this.isFatalFault() && this.comm != null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Starting Communication Handler ***");
            }
            this.comm.start();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Started Communication Handler ***");
            }
        }
    }

    public void stopComm() throws Exception {
        if (this.comm != null && this.comm.isCommStarted()) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Stopping Communication Handler ***");
            }
            this.comm.stop();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Stopped Communication Handler ***");
            }
        }
    }

    public void started() throws Exception {
        super.started();
        try {
            this.startComm();
        }
        catch (Exception exception) {
            this.getLog().error("Could not start communication handler", (Throwable)exception);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        try {
            this.stopComm();
        }
        catch (Exception exception) {
            this.getLog().error("Could not stop communication handler", (Throwable)exception);
        }
    }

    public boolean isCommActive() {
        boolean bl = true;
        if (this.comm != null) {
            bl = this.comm.isCommStarted();
        }
        boolean bl2 = false;
        if (bl && !this.isDisabled() && !this.isFault()) {
            bl2 = true;
        }
        return bl2;
    }

    public Comm getComm() {
        return this.comm;
    }

    protected abstract Comm makeComm();

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        try {
            if (property == status) {
                if (!(this.isCommActive() || this.isDisabled() || this.isFatalFault())) {
                    this.startComm();
                } else if (this.isDisabled()) {
                    this.stopComm();
                }
            }
        }
        catch (Exception exception) {
            this.getLog().error("BBasicNetwork caught exception in changed(): ", (Throwable)exception);
        }
    }

    public Log getLog() {
        return Log.getLog((String)this.getName());
    }

    public final IFuture postAsync(Runnable runnable) {
        return this.post(runnable);
    }

    public final IFuture dispatch(Runnable runnable) {
        return this.getDispatcher().post(runnable);
    }

    public final IFuture post(Runnable runnable) {
        return this.getWorker().post(runnable);
    }

    public final IFuture postWrite(Runnable runnable) {
        return this.getWriteWorker().post(runnable);
    }

    public final Message sendSync(Message message) {
        return this.sendSync(message, this.getResponseTimeout(), this.getRetryCount());
    }

    public Message sendSync(Message message, BRelTime bRelTime, int n) {
        return this.processSend(message, bRelTime, n);
    }

    public final void sendAsync(Message message, MessageListener messageListener) {
        this.sendAsync(message, messageListener, this.getResponseTimeout(), this.getRetryCount());
    }

    public void sendAsync(Message message, MessageListener messageListener, BRelTime bRelTime, int n) {
        this.post(new AsyncMessageRequest(this, message, messageListener, bRelTime, n));
    }

    public final void sendAsyncWrite(Message message, MessageListener messageListener) {
        this.sendAsyncWrite(message, messageListener, this.getResponseTimeout(), this.getRetryCount());
    }

    public void sendAsyncWrite(Message message, MessageListener messageListener, BRelTime bRelTime, int n) {
        this.postWrite(new AsyncWriteMessageRequest(this, message, messageListener, bRelTime, n));
    }

    private final Message processSend(Message message, BRelTime bRelTime, int n) {
        if (!this.isCommActive() || message == null) {
            return null;
        }
        boolean bl = message.getResponseExpected();
        DispatchRequest dispatchRequest = new DispatchRequest(this, message, bRelTime, n);
        if (bl) {
            this.dispatch(dispatchRequest);
            return dispatchRequest.getResponse(0);
        }
        this.dispatch(dispatchRequest);
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BasicNetwork", 2);
        long l = Clock.ticks() - this.lastRateTicks;
        double d = (double)(this.totalSentMessages - this.lastSentMessages) / ((double)l / 1000.0);
        double d2 = (double)(this.totalReceivedMessages - this.lastReceivedMessages) / ((double)l / 1000.0);
        this.lastSentMessages = this.totalSentMessages;
        this.lastReceivedMessages = this.totalReceivedMessages;
        this.lastRateTicks = Clock.ticks();
        spyWriter.prop((Object)"Comm", (Object)this.comm);
        spyWriter.prop((Object)"Total Sent Messages", (Object)new Long(this.totalSentMessages));
        spyWriter.prop((Object)"Sent Messages per Second", (Object)new Double(d));
        spyWriter.prop((Object)"Total Received Messages", (Object)new Long(this.totalReceivedMessages));
        spyWriter.prop((Object)"Received Messages per Second", (Object)new Double(d2));
        spyWriter.prop((Object)"Total Failed Messages (timeouts)", (Object)new Long(this.totalTimeoutMessages));
        spyWriter.endProps();
    }

    public final void incrementSent() {
        ++this.totalSentMessages;
    }

    public final void incrementReceived() {
        ++this.totalReceivedMessages;
    }

    public final void incrementTimeouts() {
        ++this.totalTimeoutMessages;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.comm = null;
        this.totalSentMessages = 0L;
        this.totalReceivedMessages = 0L;
        this.lastSentMessages = 0L;
        this.lastReceivedMessages = 0L;
        this.lastRateTicks = Clock.ticks();
        this.totalTimeoutMessages = 0L;
    }

    public BBasicNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$basicdriver$BBasicNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$basicdriver$BBasicNetwork = BBasicNetwork.class("[Lcom.tridium.basicdriver.BBasicNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AsyncMessageRequest
    implements Runnable {
        MessageListener source;
        Message msg;
        BBasicNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public void run() {
            Message message = this.basicNet.sendSync(this.msg, this.responseTimeout, this.retryCount);
            if (this.source != null && this.msg.getResponseExpected()) {
                this.source.processMessage(message);
            }
        }

        public AsyncMessageRequest(BBasicNetwork bBasicNetwork2, Message message, MessageListener messageListener, BRelTime bRelTime, int n) {
            this.basicNet = bBasicNetwork2;
            this.msg = message;
            this.source = messageListener;
            this.responseTimeout = bRelTime;
            this.retryCount = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AsyncWriteMessageRequest
    extends AsyncMessageRequest
    implements ICoalesceable {
        int hashCode;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof AsyncWriteMessageRequest) {
                AsyncWriteMessageRequest asyncWriteMessageRequest = (AsyncWriteMessageRequest)object;
                boolean bl = false;
                if (this.source == asyncWriteMessageRequest.source) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
            return iCoalesceable;
        }

        public AsyncWriteMessageRequest(BBasicNetwork bBasicNetwork2, Message message, MessageListener messageListener, BRelTime bRelTime, int n) {
            super(bBasicNetwork2, message, messageListener, bRelTime, n);
            this.hashCode = messageListener.hashCode();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DispatchRequest
    implements Runnable {
        Message msg;
        Message response;
        boolean complete;
        BBasicNetwork basicNet;
        BRelTime responseTimeout;
        int retryCount;

        public void run() {
            this.execute();
        }

        synchronized void execute() {
            this.response = null;
            try {
                if (this.msg == null) {
                    return;
                }
                if (!this.msg.getResponseExpected()) {
                    this.basicNet.getComm().transmitNoResponse(this.msg);
                } else {
                    this.response = this.basicNet.getComm().transmit(this.msg, this.responseTimeout, this.retryCount);
                }
            }
            catch (Exception exception) {
                this.basicNet.getLog().error("DispatchRequest caught exception in execute(): ", (Throwable)exception);
            }
            this.complete = true;
            this.notify();
        }

        synchronized Message getResponse(int n) {
            if (!this.complete) {
                try {
                    this.wait(n);
                }
                catch (Exception exception) {
                    this.basicNet.getLog().error("DispatchRequest caught exception in getResponse(): ", (Throwable)exception);
                }
            }
            return this.response;
        }

        private final /* synthetic */ void this() {
            this.response = null;
            this.complete = false;
        }

        public DispatchRequest(BBasicNetwork bBasicNetwork2, Message message, BRelTime bRelTime, int n) {
            this.this();
            this.basicNet = bBasicNetwork2;
            this.msg = message;
            this.responseTimeout = bRelTime;
            this.retryCount = n;
        }
    }
}

