/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfIp.tcp.comm;

import com.tridium.ddf.comm.singleTransaction.BIDdfSingleTransactionMgr;
import com.tridium.ddfIp.comm.BDdfIpAddressPort;
import com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator;
import com.tridium.platform.tcpip.BPingArgs;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TcpSocketManager
implements Runnable {
    public static final int STATE_IDLE = 0;
    public static final int STATE_NO_SOCKET = 1;
    public static final int STATE_GOT_SOCKET = 2;
    protected Object idleMonitor;
    protected Object connectMonitor;
    protected Socket commSocket;
    protected InputStream inStream;
    protected OutputStream outStream;
    protected int numOutstandingRequests;
    protected int numConnectionFailures;
    protected int state;
    protected BDdfTcpCommunicator ddfTcpCommunicator;
    protected boolean running;
    protected PipedOutputStream bos;
    protected PipedInputStream bin;
    protected Object readMonitor;
    protected Object ioMonitor;
    protected boolean messageSent;
    protected long timeTxEnd;
    protected long timeRxEnd;
    protected BFacets SHOW_SECONDS_AND_MILLIS;

    protected boolean isTraceOn() {
        return this.getLog().isTraceOn();
    }

    public void startSocketManager() {
        this.running = true;
        if (this.isTraceOn()) {
            this.trace("entered method startSocketManager");
        }
        this.switchState(1);
    }

    protected boolean isConnected() {
        boolean bl = false;
        if (this.state == 2) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void switchState(int n) {
        if (this.isTraceOn()) {
            this.trace("entered method switchState");
            this.trace("old state = " + this.state);
            this.trace("new state = " + n);
        }
        if (this.state == n) {
            return;
        }
        this.state = n;
        if (n == 1) {
            this.numConnectionFailures = 0;
        }
        Object object = this.idleMonitor;
        synchronized (object) {
            this.idleMonitor.notifyAll();
            return;
        }
    }

    public void stopSocketManager() {
        if (this.isTraceOn()) {
            this.trace("entered method stopSocketManager");
        }
        this.switchState(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doIdle() {
        this.closeSocket();
        this.nullStreams();
        Object object = this.idleMonitor;
        synchronized (object) {
            try {
                this.idleMonitor.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    protected void finiteStateMachine() {
        if (this.isTraceOn()) {
            this.trace("entered method finiteStateMachine()");
        }
        switch (this.state) {
            case 0: {
                this.doIdle();
                break;
            }
            case 1: {
                if (this.ddfTcpCommunicator.getDdfTransactionMgr() instanceof BIDdfSingleTransactionMgr) {
                    this.waitForeverForSend();
                }
                this.initSocketConnection();
                break;
            }
            case 2: {
                if (this.ddfTcpCommunicator.getDdfTransactionMgr() instanceof BIDdfSingleTransactionMgr) {
                    this.waitLittleWhileForSend();
                }
                this.readMessage();
                break;
            }
        }
    }

    protected String getPrefix() {
        return "";
    }

    protected void trace(String string) {
        this.getLog().trace(this.getPrefix() + string + "[timestamp=" + Clock.ticks() + ']');
    }

    protected Log getLog() {
        return Log.getLog((String)(this.ddfTcpCommunicator.getLog().getLogName() + "_TcpSocketManager"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readMessageFromStream() {
        Object object = this.ioMonitor;
        synchronized (object) {
            block11: {
                if (this.isTraceOn()) {
                    this.trace("entered method readMessageFromStream");
                }
                byte[] byArray = new byte[261];
                try {
                    if (this.isTraceOn()) {
                        this.trace("Reading from input stream, inStream=" + this.inStream);
                    }
                    int n = this.inStream.read(byArray, 0, 261);
                    if (this.isTraceOn()) {
                        this.trace("finished read from instream, rxSize=" + n);
                    }
                    if (n == -1) {
                        if (this.isTraceOn()) {
                            this.trace("bad read! switching state to force reinitialize socket");
                        }
                        this.switchState(1);
                        break block11;
                    }
                    this.timeRxEnd = System.currentTimeMillis();
                    if (this.isTraceOn()) {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        ByteArrayUtil.hexDump((PrintWriter)printWriter, (byte[])byArray, (int)0, (int)n);
                        printWriter.flush();
                        printWriter.close();
                        String string = stringWriter.toString();
                        this.trace(":" + this.ddfTcpCommunicator.getSlotPath() + ':' + this.getDebugCurTimeSecAndMs() + ":RX:\n" + string + "\nTcp/Ip response time(milliSec) = " + (this.timeRxEnd - this.timeTxEnd));
                    }
                    this.numOutstandingRequests = 0;
                    this.bos.write(byArray, 0, n);
                }
                catch (Exception exception) {
                    this.processReadStreamException(exception);
                }
            }
            this.considerReinitialize();
            return;
        }
    }

    public int readByte() throws Exception {
        return this.bin.read();
    }

    protected void processReadStreamException(Exception exception) {
        if (this.isTraceOn()) {
            this.trace("entered method processReadStreamException");
        }
        if (exception instanceof SocketException) {
            this.trace("Tcp/Ip SOCKET connection lost to " + this.getPrefix() + "!!!");
            this.switchState(1);
        } else if (!(exception instanceof NullPointerException) && !(exception instanceof InterruptedIOException)) {
            this.ddfTcpCommunicator.getLog().error(exception.toString(), (Throwable)exception);
        }
    }

    protected void considerReinitialize() {
        if (this.isTraceOn()) {
            this.trace("entered method considerReinitialize");
        }
        if (this.numOutstandingRequests > 1) {
            this.switchState(1);
        }
    }

    protected void setNextReadTimeout() {
        block3: {
            if (this.isTraceOn()) {
                this.trace("entered method setNextReadTimeout()");
            }
            try {
                this.commSocket.setSoTimeout((int)this.getResponseTimeout());
            }
            catch (Exception exception) {
                if (!this.isTraceOn()) break block3;
                this.trace("exception caught setting so timeout, e=" + exception);
            }
        }
    }

    protected void readMessage() {
        this.setNextReadTimeout();
        this.readMessageFromStream();
    }

    public void run() {
        if (this.isTraceOn()) {
            this.trace("entered method run");
        }
        while (this.running) {
            this.finiteStateMachine();
        }
    }

    protected void closeSocket() {
        block4: {
            if (this.isTraceOn()) {
                this.trace("entered method closeSocket");
            }
            if (this.commSocket != null) {
                try {
                    this.commSocket.close();
                }
                catch (Exception exception) {
                    if (!this.isTraceOn()) break block4;
                    this.trace("exception caught from closeSocket() while closing commSocket" + exception);
                }
            }
        }
    }

    protected void failureSocketConnectionInit(Exception exception) {
        if (this.isTraceOn()) {
            this.trace("entered method failureSocketConnectionInit");
            this.trace(this.getDebugCurTimeSecAndMs() + " Tcp/Ip - Cannot open socket connection to " + this.getPrefix() + '.');
        }
        ++this.numConnectionFailures;
        this.nullStreams();
        this.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyConnectMonitor() {
        Object object = this.connectMonitor;
        synchronized (object) {
            this.connectMonitor.notifyAll();
            return;
        }
    }

    protected void successSocketConnectionInit() {
        if (this.isTraceOn()) {
            this.trace("entered method successSocketConnectionInit");
            this.trace(this.getDebugCurTimeSecAndMs() + " Tcp/Ip - socket connection established to " + this.getPrefix() + '.');
        }
        this.switchState(2);
        this.numOutstandingRequests = 0;
        this.notifyConnectMonitor();
    }

    protected String getDestAddress() {
        return this.ddfTcpCommunicator.getTcpIpComm().getDestinationAddress().getIpAddress();
    }

    protected int getConnectionTimeout() {
        return (int)this.ddfTcpCommunicator.getTcpIpComm().getSocketConnectionTimeout().getMillis();
    }

    protected long getResponseTimeout() {
        long l = this.ddfTcpCommunicator.getReceiver().getResponseTimeout().getMillis();
        if (l < 100L) {
            l = 100L;
        }
        return l;
    }

    protected boolean icmpPing(String string) {
        BTcpIpPlatformService bTcpIpPlatformService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        bTcpIpPlatformService.lease();
        try {
            BInteger bInteger = bTcpIpPlatformService.ping(new BPingArgs(string, 1));
            boolean bl = false;
            if (bInteger.getInt() >= 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void connectSocket() throws Exception {
        if (this.isTraceOn()) {
            this.trace("entered method connectSocket");
        }
        String string = this.getDestAddress();
        if (this.isTraceOn()) {
            this.trace("userIpText=" + string);
        }
        if (string == null || string.length() <= 0 || string.equals("[***DEFAULT***]") || string.equals(BDdfIpAddressPort.ipAddress.getDefaultValue().toString())) {
            if (this.isTraceOn()) {
                this.trace("Could not conclude that the IP address [" + string + "] is valid.");
            }
            throw new SocketException("Could not conclude that the IP address [" + string + "] is valid.");
        }
        if (this.isTraceOn()) {
            this.trace("Pinging  device (same ping as DOS cmd prompt would use) using 500 ms. ping timeout...");
        }
        BTcpIpPlatformService bTcpIpPlatformService = (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
        bTcpIpPlatformService.lease();
        if (!this.icmpPing(string)) {
            if (this.isTraceOn()) {
                this.trace("--- NO RESPONSE to ping (same procedure as DOS cmd prompt would use)!!! ---");
            }
            throw new IOException("Device did not respond to ping (same ping as DOS cmd prompt would use)!");
        }
        if (this.isTraceOn()) {
            this.trace("Device responded to ping (same ping as DOS cmd prompt would use)!");
        }
        if (this.isTraceOn()) {
            this.trace("getting new socket");
        }
        this.commSocket = this.ddfTcpCommunicator.getTcpIpComm().createSocket();
    }

    protected void nullStreams() {
        if (this.isTraceOn()) {
            this.trace("entered method nullStreams");
        }
        this.inStream = null;
        this.outStream = null;
    }

    protected void createStreams() throws IOException {
        if (this.isTraceOn()) {
            this.trace("entered method createStreams");
        }
        if (this.isTraceOn()) {
            this.trace("getting new input stream");
        }
        this.inStream = this.commSocket.getInputStream();
        if (this.isTraceOn()) {
            this.trace("getting new output stream");
        }
        this.outStream = this.commSocket.getOutputStream();
    }

    protected synchronized void initSocketConnection() {
        if (this.isTraceOn()) {
            this.trace("entered method initSocketConnection");
        }
        try {
            this.nullStreams();
            this.closeSocket();
            this.connectSocket();
            this.createStreams();
            this.successSocketConnectionInit();
        }
        catch (Exception exception) {
            this.failureSocketConnectionInit(exception);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyReceiveMonitor() {
        Object object = this.readMonitor;
        synchronized (object) {
            this.readMonitor.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForeverForSend() {
        if (this.isTraceOn()) {
            this.trace("entered method waitForeverForSend");
        }
        if (!this.messageSent) {
            Object object = this.readMonitor;
            synchronized (object) {
                try {
                    this.readMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isTraceOn()) {
            this.trace("exiting method waitForeverForSend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitLittleWhileForSend() {
        if (this.isTraceOn()) {
            this.trace("entered method waitLittleWhileForSend");
        }
        if (!this.messageSent) {
            Object object = this.readMonitor;
            synchronized (object) {
                try {
                    this.readMonitor.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isTraceOn()) {
            this.trace("exiting method waitLittleWhileForSend");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForConnect(long l) {
        Object object = this.connectMonitor;
        synchronized (object) {
            try {
                if (this.isTraceOn()) {
                    this.trace("waitForConnect - waiting for up to " + l + " milliseconds.");
                }
                this.connectMonitor.wait(l);
                if (this.isTraceOn()) {
                    this.trace("waitForConnect - woke up from wait");
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.isTraceOn()) {
                    this.trace("waitForConnect interrupted while waiting");
                }
            }
            return;
        }
    }

    protected void waitAWhileForConnect() {
        long l = this.getConnectionTimeout();
        long l2 = l = l < 13000L ? 13000L : l;
        if (this.isTraceOn()) {
            this.trace("entered method waitLittleWhileForConnect");
        }
        this.waitForConnect(l);
        if (this.isTraceOn()) {
            this.trace("exiting method waitLittleWhileForConnect");
        }
    }

    protected boolean isConnecting() {
        boolean bl = false;
        if (this.state == 1) {
            bl = true;
        }
        return bl;
    }

    protected boolean isConnectingFirstTime() {
        boolean bl = false;
        if (this.isConnecting() && this.numConnectionFailures == 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeOutputStream(byte[] byArray, int n, int n2) throws Exception {
        Object object;
        block9: {
            if (this.isTraceOn()) {
                this.trace("entered method writeOutputStream");
            }
            if (this.isConnecting()) {
                object = this.connectMonitor;
                synchronized (object) {
                    block8: {
                        this.notifyReceiveMonitor();
                        if (!this.isConnectingFirstTime()) break block8;
                        this.waitAWhileForConnect();
                        break block9;
                    }
                    this.waitForConnect(this.getResponseTimeout());
                }
            }
        }
        if (!this.isConnected()) throw new SocketException();
        object = this.ioMonitor;
        synchronized (object) {
            ++this.numOutstandingRequests;
            this.outStream.write(byArray, n, n2);
            this.outStream.flush();
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
            this.notifyReceiveMonitor();
            return;
        }
    }

    protected String getDebugCurTimeSecAndMs() {
        return BAbsTime.now().toString((Context)this.SHOW_SECONDS_AND_MILLIS);
    }

    private final /* synthetic */ void this() {
        this.idleMonitor = new Object();
        this.connectMonitor = new Object();
        this.inStream = null;
        this.outStream = null;
        this.numOutstandingRequests = 0;
        this.numConnectionFailures = 0;
        this.state = 0;
        this.running = true;
        this.readMonitor = new Object();
        this.ioMonitor = new Object();
        this.messageSent = false;
        this.SHOW_SECONDS_AND_MILLIS = BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    }

    public TcpSocketManager(BDdfTcpCommunicator bDdfTcpCommunicator) {
        this.this();
        this.ddfTcpCommunicator = bDdfTcpCommunicator;
        if (this.isTraceOn()) {
            this.trace("entered constructor TcpSocketManager");
        }
        this.switchState(0);
        this.bos = new PipedOutputStream();
        try {
            this.bin = new PipedInputStream(this.bos);
        }
        catch (Exception exception) {
            this.ddfTcpCommunicator.getLog().error(exception.toString(), (Throwable)exception);
        }
    }
}

