/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nhtml;

public class Token {
    public static final int EOF = 1;
    public static final int COMMENT_START = 3;
    public static final int COMMENT_END = 4;
    public static final int TEXT = 5;
    public static final Token eof = new Token(1, "");
    public static final Token commentStart = new Token(3, "<!--");
    public static final Token commentEnd = new Token(4, "-->");
    private int tokenType;
    private String lex;

    public static Token text(String string) {
        return new Token(5, string);
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public String getLex() {
        return this.lex;
    }

    public Token mergeText(Token token) {
        if (this.tokenType != 5) {
            throw new IllegalStateException("Token isn't text.");
        }
        if (token.tokenType != 5) {
            throw new IllegalArgumentException("Parameter token isn't text.");
        }
        this.lex = this.lex + token.lex;
        return this;
    }

    public boolean isEof() {
        boolean bl = false;
        if (this.tokenType == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isText() {
        boolean bl = false;
        if (this.tokenType == 5) {
            bl = true;
        }
        return bl;
    }

    public boolean isCommentStart() {
        boolean bl = false;
        if (this.tokenType == 3) {
            bl = true;
        }
        return bl;
    }

    public boolean isCommentEnd() {
        boolean bl = false;
        if (this.tokenType == 4) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        if (this.tokenType == 1) {
            return "<EOF>";
        }
        String string = this.lex;
        if (string.length() > 32) {
            string = string.substring(0, 32) + "...";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<");
        stringBuffer.append(Token.typeToString(this.tokenType));
        stringBuffer.append(": \"");
        int n = 0;
        while (n < string.length()) {
            char c = this.lex.charAt(n);
            if (c == '\n') {
                stringBuffer.append("\\n");
            } else if (c == '\r') {
                stringBuffer.append("\\r");
            } else if (c == '\t') {
                stringBuffer.append("\\t");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        stringBuffer.append("\">");
        return stringBuffer.toString();
    }

    public static String typeToString(int n) {
        switch (n) {
            case 1: {
                return "EOF";
            }
            case 3: {
                return "COMMENT_START";
            }
            case 4: {
                return "COMMENT_END";
            }
            case 5: {
                return "TEXT";
            }
        }
        return Integer.toString(n);
    }

    public Token(int n, String string) {
        this.tokenType = n;
        this.lex = string;
    }
}

