/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.EmailUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.baja.data.BIDataValue;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailService;
import javax.baja.email.BTransport;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOutgoingAccount
extends BEmailAccount {
    public static final Property port = BOutgoingAccount.newProperty((int)0, (int)25, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    public static final Property transport = BOutgoingAccount.newProperty((int)0, (BValue)BTransport.smtp, null);
    public static final Property connectionTimeout = BOutgoingAccount.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), null);
    public static final Property useAuthentication = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    public static final Property replyTo = BOutgoingAccount.newProperty((int)0, (BValue)BEmailAddress.DEFAULT, null);
    public static final Property persistent = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    public static final Property persistenceDirectory = BOutgoingAccount.newProperty((int)0, (BValue)BOrd.make((String)"file:^email"), null);
    public static final Property allowDisabledQueueing = BOutgoingAccount.newProperty((int)0, (boolean)false, null);
    public static final Property queueSize = BOutgoingAccount.newProperty((int)3, (int)0, null);
    public static final Property maxQueueSize = BOutgoingAccount.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberSent = BOutgoingAccount.newProperty((int)3, (int)0, null);
    public static final Property maxSendablePerDay = BOutgoingAccount.newProperty((int)0, (int)100, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property numberDiscarded = BOutgoingAccount.newProperty((int)3, (int)0, null);
    public static final Property lastDiscard = BOutgoingAccount.newProperty((int)1, (BValue)BAbsTime.DEFAULT, null);
    public static final Property lastDiscardCause = BOutgoingAccount.newProperty((int)1, (String)"", null);
    public static final Action send = BOutgoingAccount.newAction((int)0, (BValue)new BEmail(), null);
    public static final Action clearQueue = BOutgoingAccount.newAction((int)0, null);
    public static final Action resetNumberSent = BOutgoingAccount.newAction((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private BOrd oldPersistenceDirectory;
    private File dirFile;
    private Queue q;
    private Set undeletable;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$javax$baja$email$BOutgoingAccount;

    public BTransport getTransport() {
        return (BTransport)this.get(transport);
    }

    public void setTransport(BTransport bTransport) {
        this.set(transport, (BValue)bTransport, null);
    }

    public BRelTime getConnectionTimeout() {
        return (BRelTime)this.get(connectionTimeout);
    }

    public void setConnectionTimeout(BRelTime bRelTime) {
        this.set(connectionTimeout, (BValue)bRelTime, null);
    }

    public boolean getUseAuthentication() {
        return this.getBoolean(useAuthentication);
    }

    public void setUseAuthentication(boolean bl) {
        this.setBoolean(useAuthentication, bl, null);
    }

    public BEmailAddress getReplyTo() {
        return (BEmailAddress)this.get(replyTo);
    }

    public void setReplyTo(BEmailAddress bEmailAddress) {
        this.set(replyTo, (BValue)bEmailAddress, null);
    }

    public boolean getPersistent() {
        return this.getBoolean(persistent);
    }

    public void setPersistent(boolean bl) {
        this.setBoolean(persistent, bl, null);
    }

    public BOrd getPersistenceDirectory() {
        return (BOrd)this.get(persistenceDirectory);
    }

    public void setPersistenceDirectory(BOrd bOrd) {
        this.set(persistenceDirectory, (BValue)bOrd, null);
    }

    public boolean getAllowDisabledQueueing() {
        return this.getBoolean(allowDisabledQueueing);
    }

    public void setAllowDisabledQueueing(boolean bl) {
        this.setBoolean(allowDisabledQueueing, bl, null);
    }

    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    public void setQueueSize(int n) {
        this.setInt(queueSize, n, null);
    }

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int n) {
        this.setInt(maxQueueSize, n, null);
    }

    public int getNumberSent() {
        return this.getInt(numberSent);
    }

    public void setNumberSent(int n) {
        this.setInt(numberSent, n, null);
    }

    public int getMaxSendablePerDay() {
        return this.getInt(maxSendablePerDay);
    }

    public void setMaxSendablePerDay(int n) {
        this.setInt(maxSendablePerDay, n, null);
    }

    public int getNumberDiscarded() {
        return this.getInt(numberDiscarded);
    }

    public void setNumberDiscarded(int n) {
        this.setInt(numberDiscarded, n, null);
    }

    public BAbsTime getLastDiscard() {
        return (BAbsTime)this.get(lastDiscard);
    }

    public void setLastDiscard(BAbsTime bAbsTime) {
        this.set(lastDiscard, (BValue)bAbsTime, null);
    }

    public String getLastDiscardCause() {
        return this.getString(lastDiscardCause);
    }

    public void setLastDiscardCause(String string) {
        this.setString(lastDiscardCause, string, null);
    }

    public void send(BEmail bEmail) {
        this.invoke(send, (BValue)bEmail, null);
    }

    public void clearQueue() {
        this.invoke(clearQueue, null, null);
    }

    public void resetNumberSent() {
        this.invoke(resetNumberSent, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void started() throws Exception {
        super.started();
        if (this.getPersistent()) {
            BOutgoingAccount bOutgoingAccount = this;
            synchronized (bOutgoingAccount) {
                this.setQueueSize(this.dirFile().listFiles().length);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                this.oldPersistenceDirectory = this.getPersistenceDirectory();
            }
        } else {
            this.setQueueSize(this.q.size());
        }
        this.ticket = this.midnight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property var1_1, Context var2_2) {
        super.changed(var1_1, var2_2);
        if (!this.isRunning()) {
            return;
        }
        if (!var1_1.equals((Object)BOutgoingAccount.persistent)) ** GOTO lbl38
        try {
            block18: {
                if (this.getQueueSize() <= 0) break block17;
                if (!this.getPersistent()) break block18;
                var3_3 = null;
                var4_6 = this;
                synchronized (this) {
                    var3_3 = new File(super.dirFile(), BUuid.make().toString() + ".xml");
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    if (true) ** GOTO lbl36
                }
            }
            var3_3 = this.getService();
            var4_6 = this.dirFile().listFiles();
            var5_9 = 0;
            while (var5_9 < var4_6.length) {
                var6_7 = (BEmail)new ValueDocDecoder(var4_6[var5_9]).decodeDocument();
                this.q.enqueue((Object)var6_7);
                super.deleteFile(var4_6[var5_9], (BEmailService)var3_3);
                ++var5_9;
            }
            break block17;
        }
        catch (Exception var3_4) {
            BEmailService.log.error("BOutgoingAccount unable to set switch Email Directory", (Throwable)var3_4);
            break block17;
        }
        {
            block17: {
                do {
                    var6_7 = (BEmail)this.q.dequeue();
                    new ValueDocEncoder((File)var3_3).encodeDocument((BValue)var6_7);
lbl36:
                    // 2 sources

                } while (!this.q.isEmpty());
                this.oldPersistenceDirectory = this.getPersistenceDirectory();
            }
            if (var1_1.equals((Object)BOutgoingAccount.persistenceDirectory) == false) return;
            try {
                this.setDirFile();
                if (this.getPersistent() == false) return;
                if (this.getQueueSize() <= 0) return;
                var3_3 = super.getDirFile(this.oldPersistenceDirectory);
                var4_6 = var3_3.listFiles();
                var5_10 = this.getService();
                var6_8 = 0;
                while (true) {
                    if (var6_8 >= var4_6.length) {
                        this.oldPersistenceDirectory = this.getPersistenceDirectory();
                        return;
                    }
                    try {
                        var9_12 = var4_6[var6_8].getName();
                        var10_14 = (BEmail)new ValueDocDecoder(var4_6[var6_8]).decodeDocument();
                        var11_15 = new File(super.dirFile(), var9_12);
                        new ValueDocEncoder(var11_15).encodeDocument((BValue)var10_14);
                    }
                    catch (Exception var9_13) {
                        BEmailService.log.error("BOutgoingAccount unable to move email Persistence Location", (Throwable)var9_13);
                    }
                    var8_11 = null;
                    super.deleteFile(var4_6[var6_8], var5_10);
                    ++var6_8;
                    continue;
                    break;
                }
                catch (Throwable var7_16) {
                    var8_11 = null;
                    super.deleteFile(var4_6[var6_8], var5_10);
                    throw var7_16;
                }
            }
            catch (IOException var3_5) {
                BEmailService.log.error("BOutgoingAccount unable to set persistant Email Directory", (Throwable)var3_5);
            }
            return;
        }
    }

    public void poll() throws Exception {
        this.pollQueue();
        this.pollUndeletables();
    }

    public void pollUndeletables() {
        if (this.undeletable.size() > 0) {
            BEmailService bEmailService = this.getService();
            Object[] objectArray = this.undeletable.toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.deleteFile((File)objectArray[n], bEmailService);
                ++n;
            }
        }
    }

    public void pollQueue() throws Exception {
        BEmailService.log.trace("BOutgoingAccount poll start");
        if (this.getPersistent() ? this.getQueueSize() == 0 : this.q.isEmpty()) {
            return;
        }
        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
            BEmailService bEmailService = this.getService();
            if (bEmailService != null) {
                BEmailService.log.error("BOutgoingAccount has already sent too many, ignoring poll request and clearing queue.");
            }
            this.doClearQueue();
            return;
        }
        Session session = this.mailPlatformHandler.getOutgoingSession(this);
        session.setDebug(this.getDebug());
        session.setDebugOut(System.out);
        Transport transport = null;
        transport = session.getTransport("smtp");
        transport.connect();
        if (this.getPersistent()) {
            this.dequeueDisk(transport, session);
        } else {
            this.dequeueMemory(transport, session);
        }
        transport.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSend(BEmail bEmail, Context context) {
        BEmailService bEmailService = this.getService();
        if (!(this.getAllowDisabledQueueing() || this.getEnabled() && this.isOperational())) {
            this.addDiscarded("BOutgoingAccount queue disabled, discarding email.", null, 1, false);
            return;
        }
        if (this.getQueueSize() >= this.getMaxQueueSize()) {
            this.addDiscarded("BOutgoingAccount queue is full, discarding email.");
            return;
        }
        if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
            this.addDiscarded("BOutgoingAccount has already sent too many, discarding email and clearing queue.");
            this.doClearQueue();
            return;
        }
        if (bEmail.getFrom().equals((Object)BEmailAddress.DEFAULT)) {
            bEmail.setFrom(this.getReplyTo());
        }
        try {
            if (this.getPersistent()) {
                File file = null;
                BOutgoingAccount bOutgoingAccount = this;
                synchronized (bOutgoingAccount) {
                    file = new File(this.dirFile(), BUuid.make().toString() + ".xml");
                }
                new ValueDocEncoder(file).encodeDocument((BValue)bEmail);
                bOutgoingAccount = this;
                synchronized (bOutgoingAccount) {
                    this.setQueueSize(this.dirFile().listFiles().length);
                }
            }
            this.q.enqueue((Object)bEmail);
            this.setQueueSize(this.q.size());
            BEmailService.log.trace("BOutgoingAccount has just enqueued an email for delivery.");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.addDiscarded("BOutgoingAccount could not enqueue email", exception);
        }
    }

    public void doClearQueue() {
        BEmailService bEmailService = this.getService();
        int n = this.getQueueSize();
        if (this.getPersistent() && this.getQueueSize() > 0) {
            try {
                File[] fileArray = this.dirFile().listFiles();
                int n2 = 0;
                while (n2 < fileArray.length) {
                    this.deleteFile(fileArray[n2], bEmailService);
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (bEmailService != null) {
                    BEmailService.log.error("BOutgoingAccount could not clear queue: ", (Throwable)exception);
                }
                --n;
            }
        } else {
            this.q.clear();
        }
        if (n > 0) {
            this.addDiscarded("BOutgoingAccount queue cleared.", null, n, false);
        }
        this.setQueueSize(0);
    }

    public void doResetNumberSent() {
        this.ticket.cancel();
        this.ticket = this.midnight();
        this.setNumberSent(0);
        this.setNumberDiscarded(0);
    }

    private final File dirFile() throws IOException {
        if (this.dirFile == null) {
            return this.setDirFile();
        }
        return this.dirFile;
    }

    private final File setDirFile() throws IOException {
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        FilePath filePath = (FilePath)this.getPersistenceDirectory().parse()[0];
        BDirectory bDirectory = bFileSystem.makeDir(filePath);
        this.dirFile = ((BLocalFileStore)bDirectory.getStore()).getLocalFile();
        return this.dirFile;
    }

    private final File getDirFile(BOrd bOrd) throws IOException {
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        FilePath filePath = (FilePath)bOrd.parse()[0];
        BDirectory bDirectory = bFileSystem.makeDir(filePath);
        return ((BLocalFileStore)bDirectory.getStore()).getLocalFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void dequeueDisk(Transport transport, Session session) throws Exception {
        BEmailService bEmailService = this.getService();
        File file = this.dirFile();
        File[] fileArray = file.listFiles();
        Arrays.sort(fileArray, new Comparator(){

            public final int compare(Object object, Object object2) {
                File file = (File)object;
                File file2 = (File)object2;
                return (int)(file.lastModified() - file2.lastModified());
            }
        });
        int n = 0;
        int n2 = 0;
        while (true) {
            Object var9_8;
            if (n2 >= fileArray.length) {
                if (n > 0) {
                    BEmailService.log.trace("BOutgoingAccount has just sent " + n + " email(s).");
                }
                this.setQueueSize(0);
                return;
            }
            if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
                if (bEmailService != null) {
                    BEmailService.log.error("BOutgoingAccount has already sent too many, discarding email and clearing queue.");
                }
                this.doClearQueue();
                return;
            }
            try {
                try {
                    if (!this.undeletable.contains(fileArray[n2])) {
                        BEmail bEmail = (BEmail)new ValueDocDecoder(fileArray[n2]).decodeDocument();
                        MimeMessage mimeMessage = EmailUtil.toMessage(bEmail, session);
                        if (mimeMessage.getAllRecipients() == null || mimeMessage.getAllRecipients().length == 0) {
                            throw new BajaRuntimeException("There must be at least one email address in the To, Cc, or Bcc fields.");
                        }
                        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                        this.setNumberSent(this.getNumberSent() + 1);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.addDiscarded("BOutgoingAccount could not dequeue persistent email", exception);
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                this.deleteFile(fileArray[n2], bEmailService);
                throw throwable;
            }
            {
                var9_8 = null;
                this.deleteFile(fileArray[n2], bEmailService);
                ++n2;
                continue;
            }
            break;
        }
    }

    private final void deleteFile(File file, BEmailService bEmailService) {
        if (file.delete()) {
            if (this.undeletable.contains(file)) {
                this.undeletable.remove(file);
            }
        } else if (!this.undeletable.contains(file)) {
            this.undeletable.add(file);
            BEmailService.log.warning("BOutgoingAccount could not delete file: " + file);
        }
    }

    private final void dequeueMemory(Transport transport, Session session) throws Exception {
        BEmailService bEmailService = this.getService();
        int n = 0;
        while (!this.q.isEmpty()) {
            if (this.getNumberSent() >= this.getMaxSendablePerDay()) {
                this.addDiscarded("BOutgoingAccount has already sent too many, discarding email and clearing queue.", null, this.getQueueSize(), true);
                this.doClearQueue();
                return;
            }
            BEmail bEmail = (BEmail)((Object)this.q.dequeue());
            try {
                MimeMessage mimeMessage = EmailUtil.toMessage(bEmail, session);
                Address[] addressArray = mimeMessage.getAllRecipients();
                if (addressArray == null || addressArray.length == 0) {
                    throw new BajaRuntimeException("There must be at least one email address in the To, Cc, or Bcc fields.");
                }
                transport.sendMessage((Message)mimeMessage, addressArray);
                this.setNumberSent(this.getNumberSent() + 1);
                ++n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.addDiscarded("BOutgoingAccount could not dequeue in-memory email", exception);
            }
        }
        if (n > 0) {
            BEmailService.log.trace("BOutgoingAccount has just sent " + n + " email(s).");
        }
        this.setQueueSize(0);
    }

    private final Clock.Ticket midnight() {
        BAbsTime bAbsTime = BAbsTime.now();
        BAbsTime bAbsTime2 = bAbsTime.nextDay();
        BAbsTime bAbsTime3 = bAbsTime2.timeOfDay(0, 0, 0, 0);
        return Clock.schedule((BComponent)this, (BAbsTime)bAbsTime3, (Action)resetNumberSent, null);
    }

    public void addDiscarded(String string) {
        this.addDiscarded(string, null);
    }

    public void addDiscarded(Exception exception) {
        this.addDiscarded(null, exception);
    }

    public void addDiscarded(String string, Exception exception) {
        this.addDiscarded(string, exception, 1, true);
    }

    public void addDiscarded(String string, Exception exception, int n, boolean bl) {
        this.setNumberDiscarded(this.getNumberDiscarded() + n);
        this.setLastDiscard(BAbsTime.now());
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        if (string != null && string.length() > 0 && exception != null) {
            stringBuffer.append(": ");
        }
        if (exception != null) {
            stringBuffer.append(exception.getMessage());
        }
        if (exception != null && exception.getCause() != null) {
            stringBuffer.append(": ").append(exception.getCause().getMessage());
        }
        this.setLastDiscardCause(stringBuffer.toString());
        if (bl) {
            BEmailService.log.error(stringBuffer.toString(), (Throwable)exception);
        } else {
            BEmailService.log.trace(stringBuffer.toString());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldPersistenceDirectory = null;
        this.dirFile = null;
        this.q = new Queue();
        this.undeletable = new HashSet();
    }

    public BOutgoingAccount() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$email$BOutgoingAccount;
        if (clazz == null) {
            clazz = class$javax$baja$email$BOutgoingAccount = BOutgoingAccount.class("[Ljavax.baja.email.BOutgoingAccount;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"outbox.png");
    }
}

