/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.me;

import com.tridium.email.MailPlatformHandler;
import com.tridium.sys.NreLib;
import java.util.Properties;
import javax.baja.email.BDeliveryPolicy;
import javax.baja.email.BIncomingAccount;
import javax.baja.email.BOutgoingAccount;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class MailPlatformHandlerMe
extends MailPlatformHandler {
    public void checkSslSupport() throws Exception {
        super.checkSslSupport();
        BComponent bComponent = (BComponent)BOrd.make((String)"service:crypto:CryptoService").get();
        if (bComponent != null && ((BStatus)bComponent.get("status")).isOk()) {
            return;
        }
        throw new Exception("Valid CryptoService not found.");
    }

    public Session getIncomingSession(final BIncomingAccount bIncomingAccount, String string) throws Exception {
        Properties properties = new Properties();
        String string2 = String.valueOf(bIncomingAccount.getPort());
        properties.put("mail." + string + ".host", bIncomingAccount.getHostname());
        properties.put("mail." + string + ".socketFactory.fallback", "false");
        properties.put("mail." + string + ".port", string2);
        properties.put("mail." + string + ".socketFactory.port", string2);
        if (bIncomingAccount.getUseSsl()) {
            properties.put("mail." + string + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail." + string + ".ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail." + string + ".ssl", "true");
            properties.put("mail." + string + ".starttls.enable", "true");
            properties.put("mail." + string + ".ssl.socketFactory.port", string2);
        }
        if (string.equals("pop3")) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (bIncomingAccount.getDeliveryPolicy() != BDeliveryPolicy.delete) {
                bl = true;
            }
            properties.put("mail.pop3.rsetbeforequit", stringBuffer.append(bl).toString());
        }
        Session session = Session.getDefaultInstance((Properties)properties, null);
        properties.put("mail." + string + ".auth", "true");
        session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            public final PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(bIncomingAccount.getAccount(), bIncomingAccount.getPassword().getValue());
            }
        });
        session.setDebug(bIncomingAccount.getDebug());
        session.setDebugOut(System.out);
        return session;
    }

    public Session getOutgoingSession(final BOutgoingAccount bOutgoingAccount) throws Exception {
        Session session = null;
        String string = String.valueOf(new Long(bOutgoingAccount.getConnectionTimeout().getMillis()).intValue());
        String string2 = String.valueOf(bOutgoingAccount.getPort());
        Properties properties = new Properties();
        if (bOutgoingAccount.getDebug()) {
            properties.put("mail.debug", "true");
        }
        properties.put("mail.smtp.localhost", System.getProperty("mail.smtp.localhost", NreLib.getLocalHost().getHostName()));
        properties.put("mail.smtp.connectiontimeout", string);
        properties.put("mail.smtp.timeout", string);
        properties.put("mail.smtp.host", bOutgoingAccount.getHostname());
        properties.put("mail.smtp.port", string2);
        properties.put("mail.smtp.socketFactory.port", string2);
        if (bOutgoingAccount.getUseSsl()) {
            properties.put("mail.transport.protocol", "smtps");
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.smtp.socketFactory.fallback", "false");
            properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtp.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtp.ssl.socketFactory.port", string2);
        } else {
            properties.put("mail.smtp.socketFactory.fallback", "true");
            properties.put("mail.transport.protocol", "smtp");
        }
        if (bOutgoingAccount.getUseAuthentication()) {
            properties.put("mail.smtp.auth", "true");
            session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                public final PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(bOutgoingAccount.getAccount(), bOutgoingAccount.getPassword().getValue());
                }
            });
        } else {
            properties.put("mail.smtp.auth", "false");
            session = Session.getInstance((Properties)properties, null);
        }
        return session;
    }
}

