/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.alarm;

import com.tridium.alarm.ack.BAlarmAcknowledger;
import java.io.IOException;
import javax.baja.alarm.BAlarmService;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailHeader;
import javax.baja.email.BTextPart;
import javax.baja.security.BIProtected;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BEmailAlarmAcknowledger
extends BAlarmAcknowledger {
    public static final Action received = BEmailAlarmAcknowledger.newAction((int)24, (BValue)new BEmail(), null);
    public static final Type TYPE;
    private static final String replyToRegExp = "(alarm\\.)([A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12})";
    private static final String uuidRegExp = "()([A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12})";
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$email$alarm$BEmailAlarmAcknowledger;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public final void received(BEmail bEmail) {
        this.invoke(received, (BValue)bEmail, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final IFuture post(Action action, BValue bValue, Context context) {
        if (action == received) {
            this.post((Runnable)new Invocation((BComponent)this, action, bValue, context));
            return null;
        }
        return super.post(action, bValue, context);
    }

    public final void doReceived(BEmail bEmail) {
        BUuid bUuid;
        Pattern pattern;
        Object object;
        if (this.getStatus().isDisabled()) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Processing received email: " + bEmail.getSubject());
        }
        this.incTotalMessagesReceivedToday();
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            object = perl5Compiler.compile(uuidRegExp);
            pattern = perl5Compiler.compile(replyToRegExp);
        }
        catch (MalformedPatternException malformedPatternException) {
            this.doFail(malformedPatternException.getMessage());
            return;
        }
        BEmailHeader[] bEmailHeaderArray = bEmail.getHeaders().getHeader("In-Reply-To");
        if (bEmailHeaderArray.length > 0 && perl5Matcher.contains(new PatternMatcherInput(bEmailHeaderArray[0].getValue()), pattern)) {
            bUuid = BUuid.make((String)perl5Matcher.getMatch().group(2));
        } else if (perl5Matcher.contains(new PatternMatcherInput(bEmail.getSubject()), object)) {
            bUuid = BUuid.make((String)perl5Matcher.getMatch().group(2));
        } else if (bEmail.getBody() instanceof BTextPart && perl5Matcher.contains(new PatternMatcherInput(((BTextPart)bEmail.getBody()).getText()), object)) {
            bUuid = BUuid.make((String)perl5Matcher.getMatch().group(2));
        } else {
            log.trace("Unable to find UUID in message content.");
            this.doFail("Unable to find UUID in message content.");
            return;
        }
        object = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try {
            perl5Compiler = object.getAlarmDb().getRecord(bUuid);
        }
        catch (IOException iOException) {
            log.error("Unable to read alarm record.", (Throwable)iOException);
            this.doFail("Unable to read alarm record.");
            return;
        }
        if (perl5Compiler == null) {
            log.trace("Unable to find specified record in alarm database.");
            this.doFail("Unable to find specified record in alarm database.");
            return;
        }
        perl5Matcher = object.lookupAlarmClass(perl5Compiler.getAlarmClass());
        object = null;
        pattern = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Class clazz = class$javax$baja$user$BUser;
        if (clazz == null) {
            clazz = class$javax$baja$user$BUser = BEmailAlarmAcknowledger.class("[Ljavax.baja.user.BUser;", false);
        }
        bEmailHeaderArray = (BUser[])pattern.getChildren(clazz);
        int n = 0;
        while (n < bEmailHeaderArray.length) {
            if (bEmailHeaderArray[n].getEmail().equalsIgnoreCase(bEmail.getFrom().getAddress())) {
                if (!bEmailHeaderArray[n].getEnabled()) {
                    if (log.isTraceOn()) {
                        log.trace("User '" + bEmailHeaderArray[n].getUsername() + "' is disabled.");
                    }
                    this.doFail("User '" + bEmailHeaderArray[n].getUsername() + "' is disabled.");
                    return;
                }
                if (!bEmailHeaderArray[n].getPermissionsFor((BIProtected)perl5Matcher).hasAdminWrite()) {
                    if (log.isTraceOn()) {
                        log.trace("User '" + bEmailHeaderArray[n].getUsername() + "' does not have permissions for alarm class '" + perl5Matcher.getName() + "'.");
                    }
                    this.doFail("User '" + bEmailHeaderArray[n].getUsername() + "' does not have permissions for alarm class '" + perl5Matcher.getName() + "'.");
                    return;
                }
                object = bEmailHeaderArray[n];
                break;
            }
            ++n;
        }
        if (object == null) {
            log.trace("User not found for '" + bEmail.getFrom().getAddress() + "'.");
            this.doFail("User not found for '" + bEmail.getFrom().getAddress() + "'.");
            return;
        }
        if (log.isTraceOn()) {
            log.trace("Alarm acknowledged by user " + object.getUsername());
        }
        this.ackAlarm(bUuid, object.getUsername());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$email$alarm$BEmailAlarmAcknowledger;
        if (clazz == null) {
            clazz = class$com$tridium$email$alarm$BEmailAlarmAcknowledger = BEmailAlarmAcknowledger.class("[Lcom.tridium.email.alarm.BEmailAlarmAcknowledger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"email.png"), (BIcon)BIcon.std((String)"badges/new.png"));
    }
}

