/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.activation.DataHandler;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailHeader;
import javax.baja.email.BEmailPart;
import javax.baja.email.BTextPart;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BValue;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public abstract class EmailUtil {
    private static final String CHARSET = "utf-8";

    public static BEmail fromMessage(Message message) throws Exception {
        BEmail bEmail = new BEmail();
        InternetAddress[] internetAddressArray = (InternetAddress[])message.getFrom();
        if (internetAddressArray != null) {
            bEmail.setFrom(BEmailAddress.make(EmailUtil.str(internetAddressArray[0].getAddress()), EmailUtil.str(internetAddressArray[0].getPersonal())));
        }
        bEmail.setTo(EmailUtil.makeRecipients(message.getRecipients(Message.RecipientType.TO)));
        Date date = message.getSentDate();
        if (date != null) {
            bEmail.setDate(BAbsTime.make((long)date.getTime()));
        }
        bEmail.setSubject(EmailUtil.str(message.getSubject()));
        ArrayList arrayList = new ArrayList();
        EmailUtil.extractContent(arrayList, message.getContent(), "", message.getContentType());
        BEmailPart[] bEmailPartArray = arrayList.toArray(new BEmailPart[arrayList.size()]);
        if (bEmailPartArray.length > 0) {
            bEmail.setBody(bEmailPartArray[0]);
        }
        if (bEmailPartArray.length > 1) {
            int n = 1;
            while (n < bEmailPartArray.length) {
                bEmail.getAttachments().add(null, (BValue)bEmailPartArray[n]);
                ++n;
            }
        }
        Enumeration enumeration = message.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            bEmail.getHeaders().addHeader(header.getName(), header.getValue());
        }
        return bEmail;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MimeMessage toMessage(BEmail bEmail, Session session) throws Exception {
        BEmailHeader[] bEmailHeaderArray;
        CustomMimeMessage customMimeMessage = new CustomMimeMessage(bEmail, session);
        customMimeMessage.setFrom((Address)new InternetAddress(bEmail.getFrom().getAddress(), bEmail.getFrom().getPersonal()));
        customMimeMessage.addRecipients(Message.RecipientType.TO, (Address[])EmailUtil.addr(bEmail.getTo().getAddresses()));
        customMimeMessage.addRecipients(Message.RecipientType.CC, (Address[])EmailUtil.addr(bEmail.getCc().getAddresses()));
        customMimeMessage.addRecipients(Message.RecipientType.BCC, (Address[])EmailUtil.addr(bEmail.getBcc().getAddresses()));
        customMimeMessage.setSubject(bEmail.getSubject(), CHARSET);
        if (!bEmail.getDate().isNull()) {
            customMimeMessage.setSentDate(new Date(bEmail.getDate().getMillis()));
        } else {
            customMimeMessage.setSentDate(new Date(BAbsTime.now().getMillis()));
        }
        BEmailPart[] bEmailPartArray = bEmail.getAttachments().getParts();
        if (bEmailPartArray.length == 0) {
            bEmailHeaderArray = EmailUtil.getDataHandler(bEmail.getBody());
            if (bEmailHeaderArray != null) {
                if (bEmailHeaderArray instanceof BlobDataHandler) {
                    customMimeMessage.setHeader("Content-Transfer-Encoding", "base64");
                } else {
                    customMimeMessage.setHeader("Content-Transfer-Encoding", "quoted-printable");
                }
                customMimeMessage.setDataHandler((DataHandler)bEmailHeaderArray);
            } else {
                if (!bEmail.getBody().getMimeType().startsWith("text/")) throw new IllegalArgumentException("Unsupported mime type: " + bEmail.getBody().getMimeType());
                customMimeMessage.setHeader("Content-Transfer-Encoding", "quoted-printable");
                customMimeMessage.setText(bEmail.getBody().toString(), CHARSET);
            }
        } else {
            bEmailHeaderArray = new MimeMultipart();
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            DataHandler dataHandler = EmailUtil.getDataHandler(bEmail.getBody());
            if (dataHandler != null) {
                if (dataHandler instanceof BlobDataHandler) {
                    mimeBodyPart.setHeader("Content-Transfer-Encoding", "base64");
                } else {
                    mimeBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                }
                mimeBodyPart.setDataHandler(dataHandler);
            } else {
                if (!bEmail.getBody().getMimeType().startsWith("text/")) throw new IllegalArgumentException("Unsupported mime type: " + bEmail.getBody().getMimeType());
                mimeBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                mimeBodyPart.setText(bEmail.getBody().toString(), CHARSET);
            }
            bEmailHeaderArray.addBodyPart((BodyPart)mimeBodyPart);
            int n = 0;
            while (n < bEmailPartArray.length) {
                mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setFileName(bEmailPartArray[n].getFileName());
                String string = bEmailPartArray[n].getMimeType();
                dataHandler = EmailUtil.getDataHandler(bEmailPartArray[n]);
                if (dataHandler != null) {
                    if (dataHandler instanceof BlobDataHandler) {
                        mimeBodyPart.setHeader("Content-Transfer-Encoding", "base64");
                    } else {
                        mimeBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                    }
                    mimeBodyPart.setDataHandler(dataHandler);
                } else {
                    if (!string.startsWith("text/")) throw new IllegalArgumentException("Unsupported mime type: " + string);
                    mimeBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                    mimeBodyPart.setText(bEmailPartArray[n].toString(), CHARSET);
                }
                bEmailHeaderArray.addBodyPart((BodyPart)mimeBodyPart);
                ++n;
            }
            customMimeMessage.setContent((Multipart)bEmailHeaderArray);
        }
        bEmailHeaderArray = bEmail.getHeaders().getHeaders();
        int n = 0;
        while (n < bEmailHeaderArray.length) {
            customMimeMessage.addHeader(bEmailHeaderArray[n].getHeaderName(), bEmailHeaderArray[n].getValue());
            ++n;
        }
        return customMimeMessage;
    }

    private static final DataHandler getDataHandler(BEmailPart bEmailPart) {
        if (bEmailPart instanceof BTextPart) {
            String string = ((BTextPart)bEmailPart).getText();
            return new TextDataHandler(string, bEmailPart.getMimeType() + ";charset=utf-8");
        }
        if (bEmailPart instanceof BBlobPart) {
            byte[] byArray = ((BBlobPart)bEmailPart).getBlob().copyBytes();
            return new BlobDataHandler(byArray, bEmailPart.getMimeType());
        }
        return null;
    }

    private static final InternetAddress[] addr(BEmailAddress[] bEmailAddressArray) throws Exception {
        InternetAddress[] internetAddressArray = new InternetAddress[bEmailAddressArray.length];
        int n = 0;
        while (n < bEmailAddressArray.length) {
            internetAddressArray[n] = new InternetAddress(bEmailAddressArray[n].getAddress(), bEmailAddressArray[n].getPersonal());
            ++n;
        }
        return internetAddressArray;
    }

    private static final void extractContent(List list, Object object, String string) throws Exception {
        EmailUtil.extractContent(list, object, string, null);
    }

    private static final void extractContent(List list, Object object, String string, String string2) throws Exception {
        if (object instanceof String) {
            if (string2 == null) {
                list.add(new BTextPart(EmailUtil.str(string), (String)object));
            } else {
                list.add(new BTextPart(EmailUtil.str(string), (String)object, string2));
            }
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            list.add(new BBlobPart(EmailUtil.str(string), BBlob.make((byte[])byteArrayOutputStream.toByteArray())));
        } else if (object instanceof MimeMultipart) {
            MimeMultipart mimeMultipart = (MimeMultipart)object;
            int n = 0;
            while (n < mimeMultipart.getCount()) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(n);
                EmailUtil.extractContent(list, mimeBodyPart.getContent(), mimeBodyPart.getFileName());
                ++n;
            }
        } else {
            throw new IllegalStateException("Could not decode message content of type " + object.getClass().getName());
        }
    }

    private static final BEmailAddressList makeRecipients(Address[] addressArray) {
        if (addressArray == null) {
            return BEmailAddressList.DEFAULT;
        }
        InternetAddress[] internetAddressArray = (InternetAddress[])addressArray;
        BEmailAddress[] bEmailAddressArray = new BEmailAddress[internetAddressArray.length];
        int n = 0;
        while (n < internetAddressArray.length) {
            bEmailAddressArray[n] = BEmailAddress.make(EmailUtil.str(internetAddressArray[n].getAddress()), EmailUtil.str(internetAddressArray[n].getPersonal()));
            ++n;
        }
        return BEmailAddressList.make(bEmailAddressArray);
    }

    private static final String str(String string) {
        return string == null ? "" : string;
    }

    static /* synthetic */ String access$0() {
        return CHARSET;
    }

    private static class CustomMimeMessage
    extends MimeMessage {
        BEmail mail;

        protected void updateMessageID() throws MessagingException {
            BEmailHeader[] bEmailHeaderArray = this.mail.getHeaders().getHeader("Message-ID");
            if (bEmailHeaderArray.length > 0) {
                InternetAddress internetAddress = InternetAddress.getLocalAddress((Session)this.session);
                String string = internetAddress != null ? internetAddress.getAddress() : "user@localhost";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<");
                stringBuffer.append(bEmailHeaderArray[0].getValue());
                stringBuffer.append(".");
                stringBuffer.append(string);
                stringBuffer.append("." + System.currentTimeMillis());
                stringBuffer.append(">");
                this.setHeader("Message-ID", stringBuffer.toString());
            } else {
                super.updateMessageID();
            }
        }

        public CustomMimeMessage(BEmail bEmail, Session session) {
            super(session);
            this.mail = bEmail;
        }
    }

    private static class BlobDataHandler
    extends DataHandler {
        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write((byte[])this.getContent());
        }

        public BlobDataHandler(byte[] byArray, String string) {
            super((Object)byArray, string);
        }
    }

    private static class TextDataHandler
    extends DataHandler {
        public void writeTo(OutputStream outputStream) throws IOException {
            byte[] byArray = ((String)this.getContent()).getBytes(EmailUtil.CHARSET);
            outputStream.write(byArray);
        }

        public TextDataHandler(String string, String string2) {
            super((Object)string, string2);
        }
    }
}

