/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.axisVideo.event.enableEvents;

import com.tridium.axisVideo.BAxisVideoCamera;
import com.tridium.axisVideo.comm.req.BAxisVideoReadParameterGroupReq;
import com.tridium.axisVideo.comm.rsp.BAxisVideoReadParameterGroupRsp;
import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import org.apache.oro.text.perl.Perl5Util;

public class AxisParameterUtil {
    public static final Perl5Util REGULAR_EXPRESSION_UTIL = new Perl5Util();

    public static String queryGroup(BAxisVideoCamera bAxisVideoCamera, String string, String string2) throws ReadGroupException, ParameterNotFoundException {
        BAxisVideoReadParameterGroupRsp bAxisVideoReadParameterGroupRsp = AxisParameterUtil.readGroup(bAxisVideoCamera, string);
        String string3 = bAxisVideoReadParameterGroupRsp.inspectRightHtml(string2);
        if (string3 == null) {
            throw new ParameterNotFoundException(string, string2);
        }
        return string3;
    }

    public static BAxisVideoReadParameterGroupRsp readGroup(BAxisVideoCamera bAxisVideoCamera, String string) throws ReadGroupException {
        BAxisVideoReadParameterGroupReq bAxisVideoReadParameterGroupReq = new BAxisVideoReadParameterGroupReq(bAxisVideoCamera, string);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)bAxisVideoCamera.getDdfCommunicator(), (BIDdfRequest)bAxisVideoReadParameterGroupReq);
        BAxisVideoReadParameterGroupRsp bAxisVideoReadParameterGroupRsp = bAxisVideoReadParameterGroupReq.getRsp();
        if (bAxisVideoReadParameterGroupRsp == null) {
            throw new ReadGroupException(string);
        }
        return bAxisVideoReadParameterGroupRsp;
    }

    public static void updateParameter(BAxisVideoCamera bAxisVideoCamera, String string, String string2) throws UnableToUpdateParameterException {
        BAxisVideoReadParameterGroupReq bAxisVideoReadParameterGroupReq = new BAxisVideoReadParameterGroupReq(bAxisVideoCamera, "update", string + '=' + string2, false);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)bAxisVideoCamera.getDdfCommunicator(), (BIDdfRequest)bAxisVideoReadParameterGroupReq);
        BAxisVideoReadParameterGroupRsp bAxisVideoReadParameterGroupRsp = bAxisVideoReadParameterGroupReq.getRsp();
        if (bAxisVideoReadParameterGroupRsp == null) {
            throw new UnableToUpdateParameterException(string + '=' + string2);
        }
    }

    public static String addParameterGroup(BAxisVideoCamera bAxisVideoCamera, String string) throws UnableToAddGroupException {
        string = REGULAR_EXPRESSION_UTIL.substitute("s/\\s+/\\+/g", string);
        BAxisVideoReadParameterGroupReq bAxisVideoReadParameterGroupReq = new BAxisVideoReadParameterGroupReq(bAxisVideoCamera, "add", string);
        DdfRequestUtil.communicateSync((BIDdfCommunicator)bAxisVideoCamera.getDdfCommunicator(), (BIDdfRequest)bAxisVideoReadParameterGroupReq);
        BAxisVideoReadParameterGroupRsp bAxisVideoReadParameterGroupRsp = bAxisVideoReadParameterGroupReq.getRsp();
        if (bAxisVideoReadParameterGroupRsp == null) {
            throw new UnableToAddGroupException(string);
        }
        String[] stringArray = bAxisVideoReadParameterGroupRsp.inspectHtml("(.*) OK", 1);
        if (stringArray == null) {
            throw new UnableToAddGroupException(string);
        }
        return stringArray[1];
    }

    public static class ReadGroupException
    extends Exception {
        private static final long serialVersionUID = 8396045021478203669L;
        public String description;

        public String toString() {
            return "Unable to Read Parameter Group (" + this.description + ')';
        }

        public ReadGroupException(String string) {
            this.description = string;
        }
    }

    public static class ParameterNotFoundException
    extends Exception {
        private static final long serialVersionUID = -7044805487676950461L;
        public String groupPatternWithWildCards;
        public String queryForString;

        public String toString() {
            return "ParameterNotFound (" + this.groupPatternWithWildCards + '=' + this.queryForString + ')';
        }

        public ParameterNotFoundException(String string, String string2) {
            this.groupPatternWithWildCards = string;
            this.queryForString = string2;
        }
    }

    public static class UnableToUpdateParameterException
    extends Exception {
        private static final long serialVersionUID = 5843623516875115467L;
        public String updateParameterCmd;

        public String toString() {
            return "Unable to Update Parameter (" + this.updateParameterCmd + ')';
        }

        public UnableToUpdateParameterException(String string) {
            this.updateParameterCmd = string;
        }
    }

    public static class UnableToAddGroupException
    extends Exception {
        private static final long serialVersionUID = -1552455867965853046L;
        public String addGroupCmd;

        public String toString() {
            return "Unable to Add Parameter Group (" + this.addGroupCmd + ')';
        }

        public UnableToAddGroupException(String string) {
            this.addGroupCmd = string;
        }
    }
}

