/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.axisVideo.comm.req;

import com.tridium.axisVideo.BAxisVideoCamera;
import com.tridium.axisVideo.datatypes.BAxisVideoResolutionSettings;
import com.tridium.axisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.rsp.BDdfResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddfHttp.comm.req.BIDdfHttpStreamRequest;
import com.tridium.ddfVideo.comm.req.BDdfVideoStreamRequest;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.net.UrlConnection;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAxisVideoStreamRequest
extends BDdfVideoStreamRequest
implements BIDdfHttpStreamRequest {
    public static final Type TYPE;
    private UrlConnection videoConnection;
    static /* synthetic */ Class class$com$tridium$axisVideo$comm$req$BAxisVideoStreamRequest;

    public Type getType() {
        return TYPE;
    }

    public boolean processHttpStream(UrlConnection urlConnection) {
        this.videoConnection = urlConnection;
        return false;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        return new BDdfResponse();
    }

    private final StringBuffer initUrlRequest() {
        BAxisVideoCameraDeviceId bAxisVideoCameraDeviceId = (BAxisVideoCameraDeviceId)this.getDeviceId();
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(bAxisVideoCameraDeviceId.getUrlAddress());
        stringBuffer.append("/axis-cgi/mjpg/video.cgi?clock=0&date=0");
        return stringBuffer;
    }

    private final void updateUrlToRequestResolution(StringBuffer stringBuffer, BVideoResolutionEnum bVideoResolutionEnum, BAxisVideoResolutionSettings bAxisVideoResolutionSettings) {
        if (bVideoResolutionEnum == BVideoResolutionEnum.high) {
            String string = bAxisVideoResolutionSettings.getHigh();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else if (bVideoResolutionEnum == BVideoResolutionEnum.medium) {
            String string = bAxisVideoResolutionSettings.getMedium();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else if (bVideoResolutionEnum == BVideoResolutionEnum.low) {
            String string = bAxisVideoResolutionSettings.getLow();
            if (string.length() != 0) {
                stringBuffer.append("&resolution=" + string);
            }
        } else {
            System.out.println(">> Unrecognized Niagara AX video resolution: " + bVideoResolutionEnum);
        }
        stringBuffer.append("&compression=" + this.getAxisVideoCompression());
    }

    private final int getAxisVideoCompression() {
        BVideoCompressionEnum bVideoCompressionEnum = this.getPlaybackParams().getCompression();
        if (bVideoCompressionEnum == BVideoCompressionEnum.none) {
            return 0;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.low) {
            return 10;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.medium) {
            return 30;
        }
        if (bVideoCompressionEnum == BVideoCompressionEnum.high) {
            return 80;
        }
        throw new IllegalArgumentException("Requested compression unrecognized: " + bVideoCompressionEnum);
    }

    private final void updateUrlToRequestFrameRate(StringBuffer stringBuffer, BVideoFrameRateEnum bVideoFrameRateEnum) {
        if (bVideoFrameRateEnum == BVideoFrameRateEnum.high) {
            stringBuffer.append("&fps=30");
        } else if (bVideoFrameRateEnum == BVideoFrameRateEnum.medium) {
            stringBuffer.append("&fps=15");
        } else if (bVideoFrameRateEnum == BVideoFrameRateEnum.low) {
            stringBuffer.append("&fps=4");
        } else {
            System.out.println(">> Unrecognized Niagara AX frame rate: " + bVideoFrameRateEnum);
        }
    }

    public byte[] toByteArray() {
        BAxisVideoCamera bAxisVideoCamera = (BAxisVideoCamera)this.getVideoSource();
        StringBuffer stringBuffer = this.initUrlRequest();
        BPlaybackParams bPlaybackParams = this.getPlaybackParams();
        this.updateUrlToRequestResolution(stringBuffer, bPlaybackParams.getResolution(), bAxisVideoCamera.getResolutionSettings());
        this.updateUrlToRequestFrameRate(stringBuffer, bPlaybackParams.getFrameRate());
        return stringBuffer.toString().getBytes();
    }

    public IVideoStream makeVideoStream() {
        return new IVideoStream(){

            public final void closeVideoStream() throws IOException {
                BAxisVideoStreamRequest.this.videoConnection.close();
            }

            public final InputStream getInputStream() {
                try {
                    return BAxisVideoStreamRequest.this.videoConnection.getInputStream();
                }
                catch (IOException iOException) {
                    throw new BajaRuntimeException((Throwable)iOException);
                }
            }

            public final BPlaybackParams getPlaybackParams() {
                return BAxisVideoStreamRequest.this.getPlaybackParams();
            }
        };
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$axisVideo$comm$req$BAxisVideoStreamRequest;
        if (clazz == null) {
            clazz = class$com$tridium$axisVideo$comm$req$BAxisVideoStreamRequest = BAxisVideoStreamRequest.class("[Lcom.tridium.axisVideo.comm.req.BAxisVideoStreamRequest;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

