/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.router;

import com.tridium.websockets.WebSocket;
import com.tridium.websockets.router.ExactMatchSocketRegistrationFactory;
import com.tridium.websockets.router.SocketRegistration;
import com.tridium.websockets.router.SocketRegistrationFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EventRouter {
    private Map pathToReg;
    private SocketRegistrationFactory socketRegistrationFactory;

    public void register(String string, WebSocket webSocket) {
        this.requirePath(string);
        this.requireSocket(webSocket);
        this.getRegistration(string).register(webSocket);
    }

    public void unregister(String string, WebSocket webSocket) {
        this.requirePath(string);
        this.requireSocket(webSocket);
        Collection collection = this.getRegistrationsMatching(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SocketRegistration socketRegistration = (SocketRegistration)iterator.next();
            socketRegistration.unregister(webSocket);
        }
    }

    public void unregisterAll(WebSocket webSocket) {
        this.requireSocket(webSocket);
        Iterator iterator = this.pathToReg.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SocketRegistration socketRegistration = (SocketRegistration)this.pathToReg.get(string);
            socketRegistration.unregister(webSocket);
        }
    }

    public void fireJSONEvent(String string, JSONObject jSONObject) throws JSONException {
        Iterator iterator = this.getRegistrationsMatching(string).iterator();
        while (iterator.hasNext()) {
            SocketRegistration socketRegistration = (SocketRegistration)iterator.next();
            socketRegistration.fire(jSONObject);
        }
    }

    public Collection getRegistrationsMatching(String string) {
        ArrayList<SocketRegistration> arrayList = new ArrayList<SocketRegistration>();
        Iterator iterator = this.pathToReg.keySet().iterator();
        while (iterator.hasNext()) {
            SocketRegistration socketRegistration = (SocketRegistration)this.pathToReg.get(iterator.next());
            if (!socketRegistration.matches(string)) continue;
            arrayList.add(socketRegistration);
        }
        return arrayList;
    }

    public SocketRegistration getRegistration(String string) {
        SocketRegistration socketRegistration = (SocketRegistration)this.pathToReg.get(string);
        if (socketRegistration == null) {
            socketRegistration = this.socketRegistrationFactory.createSocketRegistration(string);
            this.pathToReg.put(string, socketRegistration);
        }
        return socketRegistration;
    }

    public SocketRegistrationFactory getSocketRegistrationFactory() {
        return this.socketRegistrationFactory;
    }

    public void setSocketRegistrationFactory(SocketRegistrationFactory socketRegistrationFactory) {
        this.socketRegistrationFactory = socketRegistrationFactory;
    }

    private final void requirePath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("path required");
        }
    }

    private final void requireSocket(WebSocket webSocket) {
        if (webSocket == null) {
            throw new IllegalArgumentException("socket required");
        }
    }

    private final /* synthetic */ void this() {
        this.pathToReg = new HashMap();
    }

    public EventRouter() {
        this.this();
        this.setSocketRegistrationFactory(new ExactMatchSocketRegistrationFactory());
    }
}

