/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.rfc6455;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.niagara.WebSocketMessage;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.nre.util.ByteBuffer;

public class RFC6455Frame
implements WebSocketMessage.Frame {
    public static final byte OP_CONTINUATION_FRAME = 0;
    public static final byte OP_TEXT_FRAME = 1;
    public static final byte OP_BINARY_FRAME = 2;
    public static final byte OP_CONNECTION_CLOSE = 8;
    public static final byte OP_PING = 9;
    public static final byte OP_PONG = 10;
    public static final byte FIN = 8;
    public static final int CLOSE_NORMAL = 1000;
    public static final int CLOSE_GOING_AWAY = 1001;
    public static final int CLOSE_PROTOCOL_ERROR = 1002;
    public static final int CLOSE_CANNOT_UNDERSTAND = 1003;
    public static final int CLOSE_INCONSISTENT_ENCODING = 1007;
    public static final int CLOSE_POLICY_VIOLATION = 1008;
    public static final int CLOSE_MESSAGE_TOO_LARGE = 1009;
    public static final int CLOSE_EXPECTED_EXTENSION = 1010;
    public static final int CLOSE_UNEXPECTED_CONDITION = 1011;
    private byte flags;
    private byte opcode;
    private byte[] maskKey;
    private byte[] data;
    private ByteBuffer buffer;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64 + this.data.length);
        boolean bl = this.isFin();
        boolean bl2 = this.getRSV1();
        boolean bl3 = this.getRSV2();
        boolean bl4 = this.getRSV3();
        boolean bl5 = this.isMask();
        if (bl) {
            stringBuffer.append("FIN ");
        }
        if (bl2 || bl3 || bl4) {
            stringBuffer.append("RSV");
            if (bl2) {
                stringBuffer.append("1");
            }
            if (bl3) {
                stringBuffer.append("2");
            }
            if (bl4) {
                stringBuffer.append("3");
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append("OP:").append(this.opcode).append(" ");
        if (bl5) {
            stringBuffer.append("MASK ");
        }
        stringBuffer.append("LEN:").append(this.data.length).append(" ");
        if (bl5) {
            stringBuffer.append("KEY:");
            boolean bl6 = true;
            int n = 0;
            while (n < this.maskKey.length) {
                if (!bl6) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.maskKey[n]);
                bl6 = false;
                ++n;
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append("PAYLOAD:").append(ByteUtil.toUTF8String(this.data));
        return stringBuffer.toString();
    }

    public static RFC6455Frame parse(InputStream inputStream) throws IOException {
        byte by = (byte)inputStream.read();
        if (by == -1) {
            throw new IOException("socket closed!");
        }
        byte by2 = (byte)(by >> 4);
        byte by3 = (byte)(by & 0xF);
        by = (byte)inputStream.read();
        boolean bl = false;
        if ((by & 0x80) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        byte[] byArray = new byte[]{};
        int n = by & 0x7F;
        if (n == 126) {
            n = ByteUtil.readInt(inputStream, 2);
        } else if (n == 127) {
            n = ByteUtil.readInt(inputStream, 8);
        }
        if (bl2) {
            byArray = ByteUtil.readBytes(inputStream, 4);
        }
        byte[] byArray2 = ByteUtil.readBytes(inputStream, n);
        if (bl2) {
            byArray2 = RFC6455Frame.mask(byArray, byArray2);
        }
        return new RFC6455Frame(by2, by3, byArray, byArray2);
    }

    public boolean isFin() {
        boolean bl = false;
        if ((this.flags & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean getRSV1() {
        boolean bl = false;
        if ((this.flags & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean getRSV2() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean getRSV3() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isMask() {
        boolean bl = false;
        if (this.maskKey != null && this.maskKey.length > 0) {
            bl = true;
        }
        return bl;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public int getPayloadLength() {
        return this.data.length;
    }

    public byte[] getPayload() {
        return ByteUtil.cloneBytes(this.data);
    }

    public static byte[] mask(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray2.length];
        int n = 0;
        while (n < byArray2.length) {
            byArray3[n] = (byte)(byArray2[n] ^ byArray[n % 4]);
            ++n;
        }
        return byArray3;
    }

    public static int getLengthFieldLength(int n) {
        if (n < 126) {
            return 1;
        }
        if (n <= (char)-1) {
            return 3;
        }
        return 9;
    }

    public static byte[] getLengthBytes(boolean bl, int n) {
        switch (RFC6455Frame.getLengthFieldLength(n)) {
            case 1: {
                return new byte[]{(byte)(n & 0xFF)};
            }
            case 3: {
                return new byte[]{(byte)(bl ? 254 : 126), (byte)(n >> 8), (byte)(n & 0xFF)};
            }
        }
        byte[] byArray = new byte[9];
        byArray[0] = (byte)(bl ? 255 : 127);
        byArray[5] = (byte)(n >> 24 & 0xFF);
        byArray[6] = (byte)(n >> 16 & 0xFF);
        byArray[7] = (byte)(n >> 8 & 0xFF);
        byArray[8] = (byte)(n & 0xFF);
        return byArray;
    }

    public byte[] getBytes() {
        if (this.buffer == null) {
            this.buffer = new ByteBuffer();
        } else {
            this.buffer.reset();
        }
        int n = this.getPayloadLength();
        byte by = (byte)((this.flags << 4) + this.opcode);
        byte[] byArray = RFC6455Frame.getLengthBytes(this.isMask(), n);
        this.buffer.write((int)by);
        this.buffer.write(byArray);
        this.buffer.write(this.data);
        return this.buffer.toByteArray();
    }

    public RFC6455Frame(String string) {
        this(ByteUtil.getUTF8Bytes(string));
    }

    public RFC6455Frame(byte[] byArray) {
        this(8, 1, byArray);
    }

    public RFC6455Frame(byte by, byte[] byArray) {
        this(8, by, byArray);
    }

    public RFC6455Frame(byte by, byte by2, byte[] byArray) {
        this(by, by2, new byte[0], byArray);
    }

    public RFC6455Frame(byte by, byte by2, byte[] byArray, byte[] byArray2) {
        this.flags = by;
        this.opcode = by2;
        this.maskKey = ByteUtil.cloneBytes(byArray);
        this.data = ByteUtil.cloneBytes(byArray2);
    }
}

