/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.rfc6455;

import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.WebSocketContext;
import com.tridium.websockets.niagara.ClientWebSocketContext;
import com.tridium.websockets.niagara.rfc6455.RFC6455WebSocket;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.Base64;

public class RFC6455ClientWebSocket
extends RFC6455WebSocket {
    private static final SecureRandom RANDOM = new SecureRandom();
    private String key;
    private HttpConnection conn;
    private WebSocketContext ctx;

    public String getKey() {
        return this.key;
    }

    public WebSocketContext getContext() {
        return this.ctx;
    }

    public void doHandshake() throws HandshakeException {
        this.sendHandshake(this.conn);
    }

    public void sendHandshake(HttpConnection httpConnection) throws HandshakeException {
        String string;
        if (httpConnection.isOpen()) {
            throw new HandshakeException("HttpConnection must not already be open");
        }
        this.key = string = RFC6455ClientWebSocket.setRequestHeaders(httpConnection);
        RFC6455ClientWebSocket.openConnection(httpConnection);
        RFC6455ClientWebSocket.verifyResponseHeaders(httpConnection, string);
    }

    public static String setRequestHeaders(HttpConnection httpConnection) {
        String string = RFC6455ClientWebSocket.setRandomKey(httpConnection, "Sec-WebSocket-Key");
        httpConnection.setRequestHeader("Upgrade", "websocket");
        httpConnection.setRequestHeader("Connection", "Upgrade");
        httpConnection.setRequestHeader("Sec-WebSocket-Version", "13");
        return string;
    }

    public static void openConnection(HttpConnection httpConnection) throws HandshakeException {
        int n = 0;
        try {
            n = httpConnection.connect(0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new HandshakeException(iOException);
        }
        if (n != 101) {
            throw new HandshakeException("Server did not switch protocols: " + n);
        }
        if (!httpConnection.isOpen()) {
            throw new HandshakeException("Server closed websocket connection");
        }
    }

    public static void verifyResponseHeaders(HttpConnection httpConnection, String string) throws HandshakeException {
        RFC6455ClientWebSocket.verifyAccept(httpConnection, string);
        if (!"websocket".equals(httpConnection.getResponseHeader("Upgrade"))) {
            throw new HandshakeException("Invalid/missing Upgrade header");
        }
        if (!"Upgrade".equals(httpConnection.getResponseHeader("Connection"))) {
            throw new HandshakeException("Invalid/missing Connection header");
        }
    }

    public static void verifyAccept(HttpConnection httpConnection, String string) throws HandshakeException {
        try {
            String string2 = httpConnection.getResponseHeader("Sec-WebSocket-Accept");
            String string3 = RFC6455ClientWebSocket.getAccept(string);
            if (!string3.equals(string2)) {
                throw new HandshakeException("Sec-WebSocket-Accept response header wrong or missing");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new HandshakeException(noSuchAlgorithmException);
        }
    }

    public static String setRandomKey(HttpConnection httpConnection, String string) {
        String string2 = httpConnection.getRequestHeader(string);
        if (string2 == null) {
            byte[] byArray = new byte[16];
            RANDOM.nextBytes(byArray);
            string2 = Base64.encode((byte[])byArray);
            httpConnection.setRequestHeader(string, string2);
        }
        return string2;
    }

    public RFC6455ClientWebSocket(HttpConnection httpConnection) {
        this.conn = httpConnection;
        this.ctx = new ClientWebSocketContext(httpConnection);
    }
}

