/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara.hybi00;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketContext;
import com.tridium.websockets.niagara.ClientWebSocketContext;
import com.tridium.websockets.niagara.hybi00.Hybi00WebSocket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import javax.baja.net.HttpConnection;
import javax.baja.nre.util.Base64;

public class Hybi00ClientWebSocket
extends Hybi00WebSocket {
    private static final char MIN_CHAR = ':';
    private static final char MAX_CHAR = '~';
    private static final byte RANGE = 69;
    private static final int JUNK = 0;
    private static final int SPACE = 1;
    private static final int DIGIT = 2;
    private static final SecureRandom RANDOM = new SecureRandom();
    private HttpConnection conn;
    private WebSocketContext ctx;
    private String key;

    public WebSocketContext getContext() {
        return this.ctx;
    }

    public String getKey() {
        return this.key;
    }

    public void doClose(WebSocketCloseReason webSocketCloseReason, byte[] byArray) throws IOException {
        super.doClose(webSocketCloseReason, byArray);
        this.conn.close();
    }

    public void doHandshake() throws HandshakeException {
        if (this.conn.isOpen()) {
            throw new HandshakeException("HttpConnection must not already be open");
        }
        try {
            this.sendHandshake(this.conn);
        }
        catch (IOException iOException) {
            throw new HandshakeException(iOException);
        }
    }

    public void sendHandshake(HttpConnection httpConnection) throws HandshakeException, IOException {
        byte[] byArray;
        byte[] byArray2 = Hybi00ClientWebSocket.sendChallengeToServer(httpConnection);
        if (!Hybi00ClientWebSocket.isChallengeResponseValid(byArray2, byArray = Hybi00ClientWebSocket.readChallengeResponse(this.getContext().getInputStream()))) {
            throw new HandshakeException("Server did not send valid handshake proof");
        }
        this.key = Base64.encode((byte[])byArray);
    }

    public static byte[] sendChallengeToServer(HttpConnection httpConnection) throws HandshakeException, IOException {
        long l = Hybi00ClientWebSocket.setRandomKey(httpConnection, "Sec-WebSocket-Key1");
        long l2 = Hybi00ClientWebSocket.setRandomKey(httpConnection, "Sec-WebSocket-Key2");
        httpConnection.setRequestHeader("Connection", "Upgrade");
        httpConnection.setRequestHeader("Upgrade", "WebSocket");
        byte[] byArray = new byte[8];
        RANDOM.nextBytes(byArray);
        byte[] byArray2 = Hybi00ClientWebSocket.handshakeProof(l, l2, byArray);
        Hybi00ClientWebSocket.openConnection(httpConnection, byArray);
        return byArray2;
    }

    public static void openConnection(HttpConnection httpConnection, byte[] byArray) throws HandshakeException, IOException {
        int n = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        n = httpConnection.connect((long)byArray.length, (InputStream)byteArrayInputStream);
        if (n != 101) {
            throw new HandshakeException("Server did not switch protocols: " + n);
        }
        if (!httpConnection.isOpen()) {
            throw new HandshakeException("Server closed websocket connection");
        }
    }

    public static boolean isChallengeResponseValid(byte[] byArray, byte[] byArray2) {
        String string = ByteUtil.toUTF8String(byArray2);
        String string2 = ByteUtil.toUTF8String(byArray);
        return string.equals(string2);
    }

    public static byte[] readChallengeResponse(InputStream inputStream) throws HandshakeException {
        byte[] byArray = new byte[16];
        try {
            int n = inputStream.read(byArray);
            if (n < 16) {
                throw new HandshakeException("Server's challenge response was less than 16 characters: " + ByteUtil.toHexString(byArray));
            }
        }
        catch (IOException iOException) {
            throw new HandshakeException(iOException);
        }
        return byArray;
    }

    public static long setRandomKey(HttpConnection httpConnection, String string) throws HandshakeException {
        String string2 = httpConnection.getRequestHeader(string);
        if (string2 == null) {
            int n = RANDOM.nextInt(15) + 1;
            int n2 = Math.abs(RANDOM.nextInt() / n);
            String string3 = Hybi00ClientWebSocket.generateKey(n2, n);
            httpConnection.setRequestHeader(string, string3);
            return n2;
        }
        return Hybi00ClientWebSocket.keyToNumber(string2);
    }

    public static String generateKey(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("number must be greater than 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("spaces must be greater than 0");
        }
        if (n > Integer.MAX_VALUE / n2) {
            throw new IllegalArgumentException("number * spaces greater than Integer.MAX_VALUE");
        }
        String string = Integer.toString(n * n2, 10);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        while (!bl) {
            int n6 = RANDOM.nextInt(3);
            if (n6 == 0) {
                stringBuffer.append((char)(58 + RANDOM.nextInt(69)));
                if (n4 != n2 || n5 != n3) continue;
                bl = true;
                continue;
            }
            if (n6 == 1 && n4 < n2 && stringBuffer.length() > 0) {
                stringBuffer.append(' ');
                ++n4;
                continue;
            }
            if (n6 != 2 || n5 >= n3) continue;
            stringBuffer.append(string.charAt(n5));
            if (n4 != n2 || ++n5 != n3) continue;
            bl = true;
        }
        return stringBuffer.toString();
    }

    public Hybi00ClientWebSocket(HttpConnection httpConnection) {
        this.conn = httpConnection;
        this.ctx = new ClientWebSocketContext(httpConnection);
    }
}

