/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara;

import com.tridium.websockets.ByteUtil;
import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.NoSocketsAvailableException;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketContext;
import com.tridium.websockets.WebSocketEventHandler;
import com.tridium.websockets.WebSocketFactory;
import com.tridium.websockets.niagara.NWebSocket;
import com.tridium.websockets.niagara.WebSocketCloser;
import com.tridium.websockets.niagara.hybi00.Hybi00ServerWebSocket;
import com.tridium.websockets.niagara.rfc6455.RFC6455ServerWebSocket;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.baja.log.Log;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NWebSocketFactory
implements WebSocketFactory {
    public static final int DEFAULT_MAX_ACTIVE_SOCKETS = 15;
    private static Log LOG = Log.getLog((String)"websockets.niagara");
    private Set sockets;
    private int maxActiveSockets;
    private Object activeSocketsMutex;

    public WebSocket getWebSocket(WebOp webOp) throws NoSocketsAvailableException, HandshakeException, IOException {
        if (this.getActiveSockets() >= this.maxActiveSockets) {
            throw new NoSocketsAvailableException();
        }
        NWebSocket nWebSocket = this.createSocket(webOp);
        nWebSocket.attachHandler(new SocketCounter(nWebSocket));
        return nWebSocket;
    }

    protected NWebSocket createSocket(WebOp webOp) throws HandshakeException, IOException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest = webOp.getRequest();
        if (NWebSocketFactory.isRFC6455(httpServletRequest, httpServletResponse = webOp.getResponse())) {
            return new RFC6455ServerWebSocket(webOp);
        }
        if (NWebSocketFactory.isHybi00(httpServletRequest, httpServletResponse)) {
            return new Hybi00ServerWebSocket(webOp);
        }
        throw new HandshakeException("Could not determine web socket protocol");
    }

    public void shutdown() {
        HashSet hashSet = new HashSet(this.sockets);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            WebSocket webSocket = (WebSocket)iterator.next();
            try {
                WebSocketCloser.cleanupSocket(webSocket);
                webSocket.close(WebSocketCloseReason.GOING_AWAY, ByteUtil.getUTF8Bytes("Station is shutting down"));
            }
            catch (IOException iOException) {
                LOG.error("NWebSocketFactory: IOException during shutdown: ", (Throwable)iOException);
            }
        }
    }

    public static boolean isRFC6455(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getHeader("Connection");
        String string2 = httpServletRequest.getHeader("Upgrade");
        String string3 = httpServletRequest.getHeader("Sec-WebSocket-Version");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string4.equalsIgnoreCase("upgrade")) continue;
            bl = true;
            break;
        }
        bl2 = "websocket".equalsIgnoreCase(string2);
        bl3 = "13".equals(string3);
        boolean bl4 = false;
        if (bl && bl2 && bl3) {
            bl4 = true;
        }
        return bl4;
    }

    public static boolean isHybi00(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getHeader("Connection");
        String string2 = httpServletRequest.getHeader("Upgrade");
        String string3 = httpServletRequest.getHeader("Sec-WebSocket-Key1");
        String string4 = httpServletRequest.getHeader("Sec-WebSocket-Key2");
        boolean bl = false;
        if ("upgrade".equalsIgnoreCase(string) && "websocket".equalsIgnoreCase(string2) && string3 != null && string4 != null) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void incrementActiveSockets(WebSocket webSocket) {
        Object object = this.activeSocketsMutex;
        synchronized (object) {
            this.sockets.add(webSocket);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decrementActiveSockets(WebSocket webSocket) {
        Object object = this.activeSocketsMutex;
        synchronized (object) {
            this.sockets.remove(webSocket);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getActiveSockets() {
        Object object = this.activeSocketsMutex;
        synchronized (object) {
            return this.sockets.size();
        }
    }

    public int getMaxActiveSockets() {
        return this.maxActiveSockets;
    }

    public void setMaxActiveSockets(int n) {
        this.maxActiveSockets = n;
    }

    private final /* synthetic */ void this() {
        this.sockets = new HashSet();
        this.maxActiveSockets = 15;
        this.activeSocketsMutex = new Object();
    }

    public NWebSocketFactory() {
        this.this();
        Spy.ROOT.add("websockets", (Spy)new NWebSocketFactorySpy());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class SocketCounter
    extends WebSocketEventHandler {
        public void onOpen(Context context) {
            NWebSocketFactory.this.incrementActiveSockets(this.getSocket());
            if (LOG.isTraceOn()) {
                LOG.trace("NWebSocketFactory: added socket to pool (activeSockets: " + NWebSocketFactory.this.getActiveSockets() + ')');
            }
        }

        public void onClose(WebSocketCloseReason webSocketCloseReason, Context context) {
            NWebSocketFactory.this.decrementActiveSockets(this.getSocket());
            if (LOG.isTraceOn()) {
                LOG.trace("NWebSocketFactory: removed socket from pool (activeSockets: " + NWebSocketFactory.this.getActiveSockets() + ')');
            }
        }

        public SocketCounter(WebSocket webSocket) {
            super(webSocket);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NWebSocketFactorySpy
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            spyWriter.startTable(true);
            spyWriter.w((Object)"<tr>");
            spyWriter.w((Object)"<th>Request URI</th>");
            spyWriter.w((Object)"<th>Remote Host</th>");
            spyWriter.w((Object)"<th>Scheme</th>");
            spyWriter.w((Object)"<th>User</th>");
            spyWriter.w((Object)"<th>Socket Type</th>");
            spyWriter.w((Object)"</tr>\n");
            Iterator iterator = NWebSocketFactory.this.sockets.iterator();
            while (iterator.hasNext()) {
                WebSocket webSocket = (WebSocket)iterator.next();
                WebSocketContext webSocketContext = webSocket.getContext();
                String string = webSocketContext.getRequestURI();
                String string2 = webSocketContext.getRemoteHost();
                String string3 = webSocketContext.getScheme();
                String string4 = webSocketContext.getUser().getUsername();
                String string5 = webSocket.getClass().getName();
                string5 = string5.substring(string5.lastIndexOf(".") + 1);
                spyWriter.tr((Object)string, (Object)string2, (Object)string3, (Object)string4, (Object)string5);
            }
            spyWriter.endTable();
        }

        private NWebSocketFactorySpy() {
        }
    }
}

