/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.websockets.niagara;

import com.tridium.websockets.HandshakeException;
import com.tridium.websockets.WebSocket;
import com.tridium.websockets.WebSocketCloseReason;
import com.tridium.websockets.WebSocketEventHandler;
import com.tridium.websockets.WebSocketState;
import com.tridium.websockets.niagara.WebSocketMessageReceiver;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.baja.log.Log;
import javax.baja.sys.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class NWebSocket
implements WebSocket {
    private static Log LOG = Log.getLog((String)"websockets.niagara");
    private volatile WebSocketState state;
    private Object stateMutex;
    private EventManager eventManager;
    private WebSocketCloseReason closeReason;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebSocketState getState() {
        Object object = this.stateMutex;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setState(WebSocketState webSocketState) {
        Object object = this.stateMutex;
        synchronized (object) {
            this.state = webSocketState;
            return;
        }
    }

    public void send(byte[] byArray) throws IOException {
        if (this.getState() == WebSocketState.OPEN) {
            this.doWrite(byArray);
        }
    }

    public void close(WebSocketCloseReason webSocketCloseReason, byte[] byArray) throws IOException {
        if (this.getState() != WebSocketState.OPEN) {
            return;
        }
        this.setState(WebSocketState.CLOSING);
        this.eventManager.onClose(webSocketCloseReason, this.getContext());
        this.closeReason = webSocketCloseReason;
        this.doClose(webSocketCloseReason, byArray);
        this.setState(WebSocketState.CLOSED);
    }

    public void handshake() throws HandshakeException {
        if (this.getState() == WebSocketState.CONNECTING) {
            try {
                this.doHandshake();
                this.setState(WebSocketState.OPEN);
                this.eventManager.startListener();
            }
            catch (HandshakeException handshakeException) {
                LOG.error("NWebSocket: handshake failed: ", (Throwable)handshakeException);
                this.close(WebSocketCloseReason.PROTOCOL_ERROR);
                throw handshakeException;
            }
        } else {
            throw new IllegalStateException("cannot handshake when socket is already open");
        }
    }

    public void attachHandler(WebSocketEventHandler webSocketEventHandler) {
        if (webSocketEventHandler == null) {
            throw new IllegalArgumentException("handler required");
        }
        this.eventManager.addHandler(webSocketEventHandler);
    }

    public abstract void doWrite(byte[] var1) throws IOException;

    public abstract void doClose(WebSocketCloseReason var1, byte[] var2) throws IOException;

    public abstract void doHandshake() throws HandshakeException;

    public boolean equals(Object object) {
        if (!(object instanceof WebSocket)) {
            return false;
        }
        WebSocket webSocket = (WebSocket)object;
        return this.getKey().equals(webSocket.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    private final void close(WebSocketCloseReason webSocketCloseReason) {
        this.closeReason = webSocketCloseReason;
        if (this.eventManager != null) {
            this.eventManager.onClose(this.closeReason, this.getContext());
        }
        this.setState(WebSocketState.CLOSED);
    }

    private final /* synthetic */ void this() {
        this.state = WebSocketState.CONNECTING;
        this.stateMutex = new Object();
    }

    public NWebSocket() {
        this.this();
        this.eventManager = new EventManager();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EventManager
    extends WebSocketEventHandler {
        private WebSocketMessageReceiver listener;
        private Set handlers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onOpen(Context context) {
            if (LOG.isTraceOn()) {
                LOG.trace("EventManager: opening socket " + this.getSocket().getKey());
            }
            Set set = this.handlers;
            synchronized (set) {
                Iterator iterator = this.handlers.iterator();
                while (iterator.hasNext()) {
                    WebSocketEventHandler webSocketEventHandler = (WebSocketEventHandler)iterator.next();
                    webSocketEventHandler.onOpen(context);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onClose(WebSocketCloseReason webSocketCloseReason, Context context) {
            if (LOG.isTraceOn()) {
                LOG.trace("EventManager: closing socket " + this.getSocket().getKey());
            }
            Set set = this.handlers;
            synchronized (set) {
                Iterator iterator = this.handlers.iterator();
                while (iterator.hasNext()) {
                    WebSocketEventHandler webSocketEventHandler = (WebSocketEventHandler)iterator.next();
                    webSocketEventHandler.onClose(webSocketCloseReason, context);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onMessage(byte[] byArray, Context context) {
            Set set = this.handlers;
            synchronized (set) {
                Iterator iterator = this.handlers.iterator();
                while (iterator.hasNext()) {
                    WebSocketEventHandler webSocketEventHandler = (WebSocketEventHandler)iterator.next();
                    webSocketEventHandler.onMessage(byArray, context);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addHandler(WebSocketEventHandler webSocketEventHandler) {
            if (webSocketEventHandler == null) {
                throw new IllegalArgumentException("handler required");
            }
            this.respondToState(webSocketEventHandler);
            Set set = this.handlers;
            synchronized (set) {
                this.handlers.add(webSocketEventHandler);
                return;
            }
        }

        private final void respondToState(WebSocketEventHandler webSocketEventHandler) {
            if (NWebSocket.this.getState() == WebSocketState.OPEN) {
                webSocketEventHandler.onOpen(NWebSocket.this.getContext());
            } else if (NWebSocket.this.getState() == WebSocketState.CLOSED) {
                webSocketEventHandler.onClose(NWebSocket.this.closeReason, NWebSocket.this.getContext());
            }
        }

        public void startListener() {
            if (this.listener == null) {
                this.listener = new WebSocketMessageReceiver(NWebSocket.this, this);
                this.listener.start();
                this.respondToState(this);
            }
        }

        public Set getHandlers() {
            return this.handlers;
        }

        private final /* synthetic */ void this() {
            this.handlers = new HashSet();
        }

        public EventManager() {
            super(NWebSocket.this);
            this.this();
        }
    }
}

