/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarmOrion;

import com.tridium.alarmOrion.schema.Upgrade_1_0_to_1_1;
import com.tridium.alarmOrion.schema.Upgrade_1_2_to_1_3;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionAppSchemaManager;
import com.tridium.orion.OrionType;
import java.io.IOException;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmFacetName;
import javax.baja.alarmOrion.BOrionAlarmFacetValue;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

public class BOrionAlarmService
extends BAlarmService
implements BIOrionApp {
    public static final Property capacity = BOrionAlarmService.newProperty((int)5, (int)0, (BFacets)BFacets.makeInt((BUnit)BUnit.make((String)"records", (BDimension)BDimension.DEFAULT), (int)0, (int)0));
    public static final Property status = BOrionAlarmService.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BOrionAlarmService.newProperty((int)3, (String)"", null);
    public static final Property database = BOrionAlarmService.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"rdb:Rdbms")));
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$alarmOrion$BOrionAlarmService == null ? (class$javax$baja$alarmOrion$BOrionAlarmService = BOrionAlarmService.class$("javax.baja.alarmOrion.BOrionAlarmService")) : class$javax$baja$alarmOrion$BOrionAlarmService));
    private static Type[] serviceTypes = new Type[]{TYPE, BAlarmService.TYPE};
    private static final BSchemaVersion VERSION = BSchemaVersion.make((String)"1.3");
    private OrionAppSchemaManager schemaManager = new OrionAppSchemaManager((BIOrionApp)this, new ISchemaUpgrader[]{new Upgrade_1_0_to_1_1(), new Upgrade_1_2_to_1_3()});
    private static final OrionType[] ORION_TYPES = new OrionType[]{BOrionAlarmRecord.ORION_TYPE, BOrionAlarmClass.ORION_TYPE, BOrionAlarmFacetValue.ORION_TYPE, BOrionAlarmFacetName.ORION_TYPE, BOrionAlarmSource.ORION_TYPE, BOrionAlarmSourceOrder.ORION_TYPE};
    static /* synthetic */ Class class$javax$baja$alarmOrion$BOrionAlarmService;

    public int getCapacity() {
        return this.getInt(capacity);
    }

    public void setCapacity(int n) {
        this.setInt(capacity, n, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BOrd getDatabase() {
        return (BOrd)this.get(database);
    }

    public void setDatabase(BOrd bOrd) {
        this.set(database, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BAlarmDatabase createAlarmDb() {
        try {
            return new BOrionAlarmDatabase();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void changed(Property property, Context context) {
        if (!Sys.isStationStarted()) {
            super.changed(property, context);
            return;
        }
        if (property.equals(database)) {
            try {
                this.serviceStopped();
                this.serviceStarted();
            }
            catch (Exception exception) {
                logger.error("Cannot change database driver to " + this.getDatabase() + ".", (Throwable)exception);
            }
        } else {
            super.changed(property, context);
        }
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        if (this.getDatabase().isNull()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Database ORD not configured.");
            return;
        }
        try {
            Object object;
            BRdbms bRdbms = (BRdbms)this.getDatabase().resolve((BObject)this).get();
            if (bRdbms.getType().toString().equals("rdbSqlServer:SqlServerDatabase") && !((String)(object = bRdbms.get("extraConnectionProperties").toString())).contains("prepareSQL=1") && !((String)object).contains("prepareSQL=0")) {
                BOrionAlarmDatabase.log.warning("Database connection misconfigured.  Reference issue 15402.");
            }
            object = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            ((BLocalOrionDatabase)object.getOrionDatabase(bRdbms)).registerApp((BIOrionApp)this);
            this.setStatus(BStatus.ok);
        }
        catch (UnresolvedException unresolvedException) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to resolve Orion database");
            logger.error("Unable to resolve Orion database", (Throwable)unresolvedException);
            super.serviceStarted();
            return;
        }
        catch (Exception exception) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("Unable to register Orion database");
            logger.error("Unable to register Orion database", (Throwable)exception);
            super.serviceStarted();
            return;
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
    }

    public void orionReady(BOrionDatabase bOrionDatabase) {
        try {
            if (!this.getStatus().isFault()) {
                this.getAlarmDb().open();
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException("Unable to open alarm database", (Throwable)iOException);
        }
    }

    public OrionType[] getOrionTypes() {
        return ORION_TYPES;
    }

    public BSchemaVersion getSchemaVersion() {
        return VERSION;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase bLocalOrionDatabase, BSchemaVersion bSchemaVersion) throws Exception {
        this.schemaManager.performSchemaUpgrade(bLocalOrionDatabase, bSchemaVersion);
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

