/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.query.BExpression;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.util.Columns;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class ResizeDatabase
extends AlarmRecordTransaction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        int n = 0;
        Object object = bOrionAlarmService.getAlarmClasses();
        for (int i = 0; i < ((BAlarmClass[])object).length; ++i) {
            n += object[i].getTotalAlarmCount();
        }
        if (n <= bOrionAlarmService.getCapacity()) {
            return;
        }
        object = (BOrionAlarmDatabase)bOrionAlarmService.getAlarmDb();
        Object object2 = ((BOrionAlarmDatabase)((Object)object)).exclusiveAccessMutex;
        synchronized (object2) {
            block18: {
                OrionSession orionSession = null;
                try {
                    if (BOrionAlarmDatabase.log.isTraceOn()) {
                        BOrionAlarmDatabase.log.trace("Resizing to capacity " + bOrionAlarmService.getCapacity() + ", currently " + n);
                    }
                    orionSession = ((BOrionAlarmDatabase)((Object)object)).getOrionSession(null);
                    BSqlQuery bSqlQuery = BSqlQuery.make((OrionType)BOrionAlarmRecord.ORION_TYPE);
                    BProjection bProjection = new BProjection();
                    bProjection.add(SqlColumns.make((BSqlField)new BSqlField(BOrionAlarmRecord.ORION_TYPE, BOrionAlarmRecord.timestamp)).as("timestamp"));
                    bSqlQuery.select(bProjection);
                    BOrdering bOrdering = new BOrdering();
                    bOrdering.add(Columns.orderBy((BExpression)Exprs.field((Property)BOrionAlarmRecord.timestamp)).asc());
                    bSqlQuery.orderBy(bOrdering);
                    bProjection = orionSession.select((BQuery)bSqlQuery);
                    try {
                        if (bProjection.next()) {
                            boolean bl = true;
                            while ((bl = bProjection.next()) && --n > bOrionAlarmService.getCapacity()) {
                            }
                            if (!bl) {
                                throw new BajaRuntimeException("Unable to resize, ran out of alarms to remove.");
                            }
                            BDynamicOrionObject bDynamicOrionObject = (BDynamicOrionObject)bProjection.get();
                            BAbsTime bAbsTime = (BAbsTime)bDynamicOrionObject.get("timestamp");
                            orionSession.delete(BOrionAlarmRecord.ORION_TYPE, Predicates.le((Property)BOrionAlarmRecord.timestamp, (BSimple)bAbsTime));
                            ((BOrionAlarmDatabase)((Object)object)).recalculateAlarmClassStatistics();
                            break block18;
                        }
                        throw new BajaRuntimeException("Unable to resize, no alarms to remove.");
                    }
                    finally {
                        bProjection.close();
                    }
                }
                catch (Exception exception) {
                    BOrionAlarmDatabase.log.error("Error resizing database.", (Throwable)exception);
                }
                finally {
                    if (orionSession != null) {
                        orionSession.close();
                    }
                }
            }
        }
    }
}

