/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import com.tridium.alarmOrion.transactions.AlarmRecordTransaction;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.alarmOrion.BOrionAlarmClass;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.ICoalesceable;

public class ClearAlarmRecord
extends AlarmRecordTransaction
implements ICoalesceable {
    BUuid uuid;

    public ClearAlarmRecord(BUuid bUuid) {
        this.uuid = bUuid;
    }

    public ICoalesceable coalesce(ICoalesceable iCoalesceable) {
        return iCoalesceable;
    }

    public Object getCoalesceKey() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase bOrionAlarmDatabase = (BOrionAlarmDatabase)bOrionAlarmService.getAlarmDb();
        Object object = bOrionAlarmDatabase.exclusiveAccessMutex;
        synchronized (object) {
            OrionSession orionSession = null;
            try {
                orionSession = bOrionAlarmDatabase.getOrionSession(null);
                orionSession.setAutoCommit(false);
                BOrionAlarmRecord bOrionAlarmRecord = (BOrionAlarmRecord)orionSession.read(BOrionAlarmRecord.ORION_TYPE, new PropertyValue(BOrionAlarmRecord.uuid, (BValue)this.uuid));
                if (bOrionAlarmRecord != null) {
                    BOrionAlarmClass bOrionAlarmClass = bOrionAlarmRecord.resolveAlarmClass(orionSession);
                    bOrionAlarmClass.setTotalAlarmCount(bOrionAlarmClass.getTotalAlarmCount() - 1);
                    if (!bOrionAlarmRecord.isAcknowledged()) {
                        bOrionAlarmClass.setUnackedAlarmCount(bOrionAlarmClass.getUnackedAlarmCount() - 1);
                    }
                    if (!bOrionAlarmRecord.isNormal()) {
                        bOrionAlarmClass.setInAlarmCount(bOrionAlarmClass.getInAlarmCount() - 1);
                    }
                    if (bOrionAlarmRecord.isOpen()) {
                        bOrionAlarmClass.setOpenAlarmCount(bOrionAlarmClass.getOpenAlarmCount() - 1);
                    }
                    orionSession.update((BIOrionObject)bOrionAlarmClass);
                    orionSession.delete(BOrionAlarmRecord.ORION_TYPE, Predicates.eq((Property)BOrionAlarmRecord.id, (BSimple)BInteger.make((int)bOrionAlarmRecord.getId())));
                }
                orionSession.commit();
            }
            catch (Exception exception) {
                if (orionSession != null) {
                    orionSession.rollback();
                }
                BOrionAlarmDatabase.log.error("Unable to clear alarm " + this.uuid, (Throwable)exception);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                }
            }
        }
    }
}

