/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.transactions;

import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Queue;

public class BOrionAlarmTransactionStatistics
extends BComponent {
    public static final Property queueSize = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property processRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property peekProcessRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property enqueueRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property peekEnqueueRate = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"per minute"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Property alarmCount = BOrionAlarmTransactionStatistics.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action update = BOrionAlarmTransactionStatistics.newAction((int)4, null);
    public static final Action transactionEnqueued = BOrionAlarmTransactionStatistics.newAction((int)4, null);
    public static final Action transactionProcessed = BOrionAlarmTransactionStatistics.newAction((int)4, (BValue)new BComponent(), null);
    public static final Action reset = BOrionAlarmTransactionStatistics.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics == null ? (class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics = BOrionAlarmTransactionStatistics.class$("com.tridium.alarmOrion.transactions.BOrionAlarmTransactionStatistics")) : class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics));
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"charts/line.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private static final int FLAGS = 11;
    private int processedCount = 0;
    private int enqueuedCount = 0;
    private Clock.Ticket ticket;
    private static final BRelTime updateRate = BRelTime.makeSeconds((int)10);
    static /* synthetic */ Class class$com$tridium$alarmOrion$transactions$BOrionAlarmTransactionStatistics;

    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    public void setQueueSize(int n) {
        this.setInt(queueSize, n, null);
    }

    public double getProcessRate() {
        return this.getDouble(processRate);
    }

    public void setProcessRate(double d) {
        this.setDouble(processRate, d, null);
    }

    public double getPeekProcessRate() {
        return this.getDouble(peekProcessRate);
    }

    public void setPeekProcessRate(double d) {
        this.setDouble(peekProcessRate, d, null);
    }

    public double getEnqueueRate() {
        return this.getDouble(enqueueRate);
    }

    public void setEnqueueRate(double d) {
        this.setDouble(enqueueRate, d, null);
    }

    public double getPeekEnqueueRate() {
        return this.getDouble(peekEnqueueRate);
    }

    public void setPeekEnqueueRate(double d) {
        this.setDouble(peekEnqueueRate, d, null);
    }

    public int getAlarmCount() {
        return this.getInt(alarmCount);
    }

    public void setAlarmCount(int n) {
        this.setInt(alarmCount, n, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public void transactionEnqueued() {
        this.invoke(transactionEnqueued, null, null);
    }

    public void transactionProcessed(BComponent bComponent) {
        this.invoke(transactionProcessed, (BValue)bComponent, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)updateRate, (Action)update, null);
    }

    public void stopped() {
        if (this.ticket != null && !this.ticket.isExpired()) {
            this.ticket.cancel();
        }
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent.getType().is(BOrionAlarmService.TYPE) && bComponent.getChildren(((Object)((Object)this)).getClass()).length == 0;
    }

    public BIcon getIcon() {
        BValue bValue = this.get("icon");
        if (bValue instanceof BIcon) {
            return (BIcon)bValue;
        }
        return icon;
    }

    public void doReset() {
        Property[] propertyArray = this.getDynamicPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!Flags.isTransient((BComplex)this, (Slot)propertyArray[i])) continue;
            this.remove(propertyArray[i]);
        }
        this.enqueuedCount = 0;
        this.processedCount = 0;
        this.update();
    }

    public void doTransactionEnqueued() {
        ++this.enqueuedCount;
    }

    public void doTransactionProcessed(BComponent bComponent) {
        BRelTime bRelTime;
        BRelTime bRelTime2;
        String string = ((BString)bComponent.get("className")).toString();
        long l = ((BRelTime)bComponent.get("processTime")).getMillis();
        String string2 = string + "Count";
        String string3 = string + "Avg";
        String string4 = string + "Total";
        ++this.processedCount;
        BDouble bDouble = (BDouble)this.get(string2);
        if (bDouble == null) {
            bDouble = BDouble.DEFAULT;
            this.add(string2, (BValue)bDouble, 11, BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)), null);
        }
        if ((bRelTime2 = (BRelTime)this.get(string3)) == null) {
            bRelTime2 = BRelTime.DEFAULT;
            this.add(string3, (BValue)bRelTime2, 11, BFacets.make((String)"showMilliseconds", (boolean)true), null);
        }
        if ((bRelTime = (BRelTime)this.get(string4)) == null) {
            bRelTime = BRelTime.DEFAULT;
            this.add(string4, (BValue)bRelTime, 11, BFacets.make((String)"showMilliseconds", (boolean)true), null);
        }
        bDouble = BDouble.make((double)(bDouble.getDouble() + 1.0));
        bRelTime = BRelTime.make((long)(bRelTime.getMillis() + l));
        bRelTime2 = BRelTime.make((long)(bRelTime.getMillis() / bDouble.getLong()));
        this.set(string2, (BValue)bDouble);
        this.set(string3, (BValue)bRelTime2);
        this.set(string4, (BValue)bRelTime);
    }

    public void doUpdate() {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        this.setQueueSize(((Queue)bOrionAlarmService.fw(601)).size());
        this.setAlarmCount(bOrionAlarmService.getAlarmDb().getRecordCount());
        this.setProcessRate(this.processedCount * (60 / updateRate.getSeconds()));
        this.setPeekProcessRate(Math.max(this.getPeekProcessRate(), this.getProcessRate()));
        this.processedCount = 0;
        this.setEnqueueRate(this.enqueuedCount * (60 / updateRate.getSeconds()));
        this.setPeekEnqueueRate(Math.max(this.getPeekEnqueueRate(), this.getEnqueueRate()));
        this.enqueuedCount = 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

