/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.util.SchemaUpgradeUtil;
import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarmOrion.BOrionAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmSource;
import javax.baja.alarmOrion.BOrionAlarmSourceOrder;
import javax.baja.rdb.ddl.AlterColumn;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public class Upgrade_1_2_to_1_3
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BSchemaVersion.make((String)"1.2");
    private static final BSchemaVersion TO_VERSION = BSchemaVersion.make((String)"1.3");

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase bLocalOrionDatabase, BIOrionApp bIOrionApp, OrionSession orionSession) throws Exception {
        block6: {
            try {
                BAlarmService.logger.message("Attempting to resize BOrionAlarmSource.source...");
                AlterColumn alterColumn = SchemaUpgradeUtil.alterColumn((OrionType)BOrionAlarmSource.ORION_TYPE, (Property)BOrionAlarmSource.source, (BLocalOrionDatabase)bLocalOrionDatabase);
                orionSession.invokeDdl((DdlCommand)alterColumn);
                BAlarmService.logger.message("Width change for BOrionAlarmSource.source complete.");
            }
            catch (Exception exception) {
                BAlarmService.logger.trace("Problem resizing database since some BOrionAlarmSource data is too long.", (Throwable)exception);
                if (BOrionAlarmSource.SOURCE_LENGTH >= 256) break block6;
                BAlarmService.logger.warning("Removing records of BOrionAlarmSource length of 256 to comply with new limit of " + BOrionAlarmSource.SOURCE_LENGTH + "...");
                try {
                    BOrionAlarmSource bOrionAlarmSource;
                    String string = orionSession.getOrionDatabase().getTableName(BOrionAlarmSource.ORION_TYPE);
                    OrionCursor orionCursor = orionSession.select(BOrionAlarmSource.ORION_TYPE, "select * from " + string + " where " + ((RdbmsDialect)orionSession.getRdbmsContext()).getStringLengthFunctionName() + "(" + string + "." + BOrionAlarmSource.source.getName() + ") > " + BOrionAlarmSource.SOURCE_LENGTH);
                    while (orionCursor.next()) {
                        bOrionAlarmSource = (BOrionAlarmSource)orionCursor.get();
                        OrionCursor orionCursor2 = orionSession.select(BOrionAlarmSourceOrder.ORION_TYPE, new PropertyValue(BOrionAlarmSourceOrder.alarmSource, (BValue)BRef.make((BIOrionObject)bOrionAlarmSource)));
                        while (orionCursor2.next()) {
                            BOrionAlarmSourceOrder bOrionAlarmSourceOrder = (BOrionAlarmSourceOrder)orionCursor2.get();
                            BOrionAlarmRecord bOrionAlarmRecord = bOrionAlarmSourceOrder.resolveAlarm(orionSession);
                            if (bOrionAlarmRecord == null) continue;
                            orionSession.delete((BIOrionObject)bOrionAlarmRecord);
                        }
                        BAlarmService.logger.warning(bOrionAlarmSource.getSource().toString().length() + " > " + BOrionAlarmSource.SOURCE_LENGTH + ", removing all records associated with " + bOrionAlarmSource.getSource());
                        orionSession.delete((BIOrionObject)bOrionAlarmSource);
                    }
                    BAlarmService.logger.message("Attempting to resize BOrionAlarmSource.source again...");
                    bOrionAlarmSource = SchemaUpgradeUtil.alterColumn((OrionType)BOrionAlarmSource.ORION_TYPE, (Property)BOrionAlarmSource.source, (BLocalOrionDatabase)bLocalOrionDatabase);
                    orionSession.invokeDdl((DdlCommand)bOrionAlarmSource);
                    BAlarmService.logger.message("Width change for BOrionAlarmSource.source completed on second attempt.");
                }
                catch (Exception exception2) {
                    BAlarmService.logger.error("Upgrade_1_2_to_1_3 Schema Upgrade either not needed or failed", (Throwable)exception2);
                }
            }
        }
    }
}

