/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarmOrion.conversion.file;

import com.tridium.alarm.BTextOp;
import com.tridium.alarm.db.file.BFileAlarmDatabase;
import com.tridium.alarmOrion.conversion.BAlarmConversion;
import com.tridium.alarmOrion.conversion.BAlarmConversionJob;
import com.tridium.orion.OrionSession;
import java.io.IOException;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarmOrion.BOrionAlarmDatabase;
import javax.baja.alarmOrion.BOrionAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import javax.baja.util.TextUtil;

public class BFileAlarmConversionJob
extends BAlarmConversionJob {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$alarmOrion$conversion$file$BFileAlarmConversionJob == null ? (class$com$tridium$alarmOrion$conversion$file$BFileAlarmConversionJob = BFileAlarmConversionJob.class$("com.tridium.alarmOrion.conversion.file.BFileAlarmConversionJob")) : class$com$tridium$alarmOrion$conversion$file$BFileAlarmConversionJob));
    private boolean running = true;
    private BAlarmConversion conversion;
    static /* synthetic */ Class class$com$tridium$alarmOrion$conversion$file$BFileAlarmConversionJob;

    public Type getType() {
        return TYPE;
    }

    public BFileAlarmConversionJob() {
    }

    public BFileAlarmConversionJob(BAlarmConversion bAlarmConversion) {
        this.conversion = bAlarmConversion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context context) {
        BOrionAlarmService bOrionAlarmService = (BOrionAlarmService)Sys.getService((Type)BOrionAlarmService.TYPE);
        BOrionAlarmDatabase bOrionAlarmDatabase = (BOrionAlarmDatabase)bOrionAlarmService.getAlarmDb();
        OrionSession orionSession = bOrionAlarmDatabase.getOrionSession(context);
        Queue queue = (Queue)bOrionAlarmService.fw(601);
        this.log().start("Conversion started");
        this.recordsConverted = 0.0;
        this.recordsFailed = 0.0;
        this.running = true;
        try {
            BFileAlarmDatabase bFileAlarmDatabase = new BFileAlarmDatabase();
            try {
                bFileAlarmDatabase.open();
                this.recordsTotal = bFileAlarmDatabase.getRecordCount();
                Cursor cursor = bFileAlarmDatabase.scan();
                while (cursor.next() && this.running) {
                    String string;
                    BString bString;
                    String string2;
                    BAlarmRecord bAlarmRecord = new BAlarmRecord();
                    bAlarmRecord.copyFrom((BComplex)((BAlarmRecord)cursor.get()));
                    if (this.conversion.getChangeLastUpdated()) {
                        bAlarmRecord.setLastUpdate(Clock.time());
                    }
                    if ((string2 = this.conversion.getAlarmClass()) != null && !string2.equals("")) {
                        bAlarmRecord.setAlarmClass(SlotPath.escape((String)TextUtil.replace((String)string2, (String)"%alarmClass%", (String)SlotPath.unescape((String)bAlarmRecord.getAlarmClass()))));
                    }
                    if ((bString = (BString)bAlarmRecord.getAlarmData().get("sourceName")) != null) {
                        string = this.conversion.getSourceName().customize(bString.toString());
                        bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)string)));
                    } else if (this.conversion.getSourceName().getOp() == BTextOp.replace) {
                        string = this.conversion.getSourceName().customize("");
                        bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (String)"sourceName", (BIDataValue)BString.make((String)string)));
                    }
                    this.progress();
                    bOrionAlarmDatabase.update(bAlarmRecord);
                    try {
                        while (queue.size() > 250) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.recordsConverted += 1.0;
                }
            }
            finally {
                bFileAlarmDatabase.close();
            }
        }
        catch (IOException iOException) {
            this.failed(iOException);
        }
        finally {
            orionSession.close();
        }
    }

    public void doCancel(Context context) {
        this.running = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

