/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sms.serial.command;

import com.tridium.sms.gprs.BGprsSmsTransport;
import com.tridium.sms.serial.command.SmsCommand;
import com.tridium.sms.util.SmsToolkit;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmsSignalStrengthCommand
extends SmsCommand {
    private double signalStrength;

    public final boolean doRun() {
        boolean bl;
        block11: {
            bl = false;
            try {
                if (this.comms instanceof BGprsSmsTransport) {
                    int n;
                    if (SmsToolkit.log.isTraceOn()) {
                        SmsToolkit.log.trace("Running on an internal GRPS Modem board");
                    }
                    String string = this.comms.write("AT^MONI\r", "OK\r\n");
                    if ((string = string.toLowerCase()).indexOf("searching", n = string.indexOf("serving cell")) != -1) {
                        if (SmsToolkit.log.isTraceOn()) {
                            SmsToolkit.log.trace("MONI Response shows modem as searching for a network, setting signal stren to 0");
                        }
                        this.signalStrength = 0.0;
                        bl = true;
                    } else if (string.indexOf("limited service", n) != -1) {
                        if (SmsToolkit.log.isTraceOn()) {
                            SmsToolkit.log.trace("MONI Response shows modem as having limited service, setting signal stren to 0");
                        }
                        this.signalStrength = 0.0;
                        bl = true;
                    }
                }
                if (!bl) {
                    if (SmsToolkit.log.isTraceOn()) {
                        SmsToolkit.log.trace("Reading normal signal strength");
                    }
                    bl = this.parseSignalStrengthFromCsq(this.comms.write("AT+CSQ\r", "OK\r\n"));
                }
            }
            catch (Exception exception) {
                if (!SmsToolkit.log.isTraceOn()) break block11;
                SmsToolkit.log.trace("SMSSignalStrengthCommand.execute(CommsManager): Failed to send message through SMS manager");
            }
        }
        return bl;
    }

    public final boolean parseSignalStrengthFromCsq(String string) {
        boolean bl = false;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            Pattern pattern = perl5Compiler.compile("\\+[Cc][Ss][Qq]\\: *([0-9]+)");
            if (perl5Matcher.contains(string, pattern)) {
                String string2 = perl5Matcher.getMatch().group(1);
                if (SmsToolkit.log.isTraceOn()) {
                    SmsToolkit.log.trace("AT+CSQ reports signal strength of " + string2);
                }
                this.signalStrength = SmsSignalStrengthCommand.getSignalStrengthAsPercentage(Double.parseDouble(string2));
                bl = true;
            }
        }
        catch (MalformedPatternException malformedPatternException) {
            SmsToolkit.log.error("Can't compile Signal Strength RegEx Pattern", (Throwable)malformedPatternException);
        }
        return bl;
    }

    private static final double getSignalStrengthAsPercentage(double d) {
        double d2 = 0.0;
        d2 = d > 31.0 ? 0.0 : d / 31.0 * 100.0;
        return Math.round(d2);
    }

    public final double getSignalStrength() {
        return this.signalStrength;
    }

    public final String toString() {
        return SmsToolkit.getText("smsCommand.signal");
    }

    private final /* synthetic */ void this() {
        this.signalStrength = 0.0;
    }

    public SmsSignalStrengthCommand(SmsCommand.ICommsImplementer iCommsImplementer) {
        super(iCommsImplementer);
        this.this();
    }
}

